/*
 * Created on 16/02/2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.pilot;
import axeBots.AxeBot;
import axeBots.data.SegmentedGFs;
import axeBots.okami.AxeTarget;
import axeBots.okami.AxeVector;
import axeBots.pilot.navigator.Course;
import axeBots.pilot.navigator.WaveNavigator;
import axeBots.pilot.waves.EnemyWave;
import java.awt.Color;
import java.awt.geom.*;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import robocode.robocodeGL.EllipseGL;
import robocode.robocodeGL.LabelGL;
import robocode.robocodeGL.PointGL;
import robocode.robocodeGL.RectangleGL;
import robocode.robocodeGL.system.GLRenderer;
/**
 * @author Marcos
 * 
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class WaveSurferPilot extends FlatPilot {
    
    public static final double MIN_DIST= 450;
    public static final double RUN_DIST= 150;
    //	private int hiVel = true;
    private double timeToInvert;
    //private static final double AVOID_RAMM = 150;
    public static final double[] DIST_SEG_FLAT_FACTORS = {2.5, 1.25, 2.25, 4, 4};
    //	public static final double[] DIST_SEG_BULL_SYNC_RATE=
    //			{ 0, 0, 0.25, 0.25, 0.25 };
    private EllipseGL ellipse;
    private EllipseGL re;
    private PointGL centerPt;
    private PointGL wallPt;
    private PointGL testpt;
    private EllipseGL myGF;
    private LabelGL myGFlabel;
    private EllipseGL desiredGF;
    private LabelGL desiredGFlabel;
    private PointGL moveAmtPt;
    private LabelGL moveAmt;
    private PointGL gfPts[] = null;
    private RectangleGL wall;
    private GLRenderer renderer;
    private boolean beeingRammed = false;
    private Color centerCl = new Color(255, 0, 0);
    private Color wallPtCl = new Color(255, 255, 0);
    private Color wallCl = new Color(64, 64, 0);
    private Color trajCl = new Color(0, 64, 0);
    private Color gfBAD = Color.red;//new Color(128, 0, 0);
    private Color gfOK = Color.green;//new Color(0, 128, 0);
    //private Color gfOK= new Color(0, 128, 0);
    private EnemyWave wave = null;
    private WaveNavigator navigator;
    /**
     * JamPilot, by Axe. This class based in Jamougha's ideas of how achieving
     * a flat profile. Credits goes to him, whow implemented that equation on
     * Raiko bots.
     */
    public WaveSurferPilot() {
        super();
        navigator = new WaveNavigator(this);
        if (AxeBot.GL) {
            gfPts = new PointGL[SegmentedGFs.GF_QT];
            renderer = GLRenderer.getInstance();
            myGF = new EllipseGL();
            myGF.setFrame(AxeBot.getIt().getBattleFieldWidth() - 15, AxeBot
                    .getIt().getBattleFieldHeight() - 50, 8, 8);
            myGF.setFilled(true);
            myGF.setColor(Color.green);
            myGFlabel = new LabelGL("0");
            myGF.addLabel(myGFlabel);
            renderer.addRenderElement(myGF);
            desiredGF = new EllipseGL();
            desiredGF.setFrame(AxeBot.getIt().getBattleFieldWidth() - 15,
                    AxeBot.getIt().getBattleFieldHeight() - 10, 8, 8);
            desiredGF.setFilled(true);
            desiredGF.setColor(Color.green);
            desiredGFlabel = new LabelGL("0");
            desiredGF.addLabel(desiredGFlabel);
            renderer.addRenderElement(desiredGF);
            moveAmtPt = new PointGL();
            moveAmtPt.setPosition(AxeBot.getIt().getBattleFieldWidth() - 12,
                    AxeBot.getIt().getBattleFieldHeight() - 110);
            moveAmtPt.setSize(0);
            moveAmt = new LabelGL("0");
            moveAmtPt.addLabel(moveAmt);
            renderer.addRenderElement(moveAmtPt);
            re = new EllipseGL();
            re.setFrame(AxeBot.getIt().getBattleFieldWidth() - 15, AxeBot
                    .getIt().getBattleFieldHeight() - 160, 8, 8);
            re.setFilled(true);
            re.setColor(Color.green);
            re.addLabel(new LabelGL("Re"));
            renderer.addRenderElement(re);
            centerPt = new PointGL();
            centerPt.setPosition(0, 0);
            centerPt.setSize(4);
            centerPt.setColor(centerCl);
            testpt = new PointGL();
            testpt.setPosition(0, 0);
            testpt.setSize(8);
            testpt.setColor(Color.cyan);
            centerPt = new PointGL();
            centerPt.setPosition(getMe().getX(), getMe().getY());
            centerPt.setSize(4);
            centerPt.setColor(wallPtCl);
            wallPt = new PointGL();
            wallPt.setPosition(getMe().getX(), getMe().getY());
            wallPt.setSize(4);
            wallPt.setColor(centerCl);
            ellipse = new EllipseGL();
            ellipse.setLineWidth(1.0);
            ellipse.setColor(trajCl);
            //ellipse.addLabel(new LabelGL("This is an ellipse"));
            wall = new RectangleGL();
            wall.setLineWidth(1.0);
            wall.setColor(wallCl);
            DecimalFormat fmt = new DecimalFormat("0");
            double ptsPerVel = (SegmentedGFs.GF_QT-1) / (8D * 2D);
            for (int i = 0; i < gfPts.length; i++) {
                PointGL pt = new PointGL();
                pt.setPosition(-100, -100);
                pt.setColor(Color.green);
                if ((i % ptsPerVel) == 0) {
                    String lab = ""
                            + fmt.format((i - ((SegmentedGFs.GF_QT-1) / 2D))
                                    / ptsPerVel);
                    pt.addLabel(new LabelGL(lab));
                    pt.setSize(4);
                } else {
                    pt.setSize(2);
                }
                renderer.addRenderElement(pt);
                gfPts[i] = pt;
            }
            renderer.addRenderElement(ellipse);
            //			renderer.addRenderElement(testpt);
            renderer.addRenderElement(wall);
            renderer.addRenderElement(centerPt);
            renderer.addRenderElement(wallPt);
        }
    }
    public void invert() {
        //        int d= this.getDistanceIndex();
        //        double changeFactor= DIST_SEG_FLAT_FACTORS[d];
        //        double toReach= estimateTravelTime();
        //        // double prob=
        //        // Math.pow(
        //        // 1 / (toReach * changeFactor),
        //        // 1 / (toReach * changeFactor));
        //        timeToInvert= super.getMe().getTime();
        //        // while((Math.random() * prob)<1){
        //        double factor= 1 / (toReach * changeFactor);
        //        while (Math.random() < Math.pow(factor, factor)) {
        //            timeToInvert++;
        //        }
        super.invert();
        //        System.out.println(">>> invertendo." + timeToInvert);
    }
    /*
     * (non-Javadoc)
     * 
     * @see axeBots.pilot.AxePilot#move()
     */
    public void move() {
        super.setHim(getMe().getMyTarget());
        if (super.getHim() == null) {
            return;
        }
        SegmentedGFs gfs = super.getHim().getBotData().getGfHistory();
        Point2D.Double myPos = super.getMe().pos();
        wave = EnemyWave.getCurrentWave(myPos); //EnemyWave.getLastWave();//
        navigator.setWave(wave);
        super.setFlat(false);
        setUseSynchro(false); //getHim().getDistance() > AVOID_RAMM);
        //        System.out.println("flat:" + super.isFlat());
        Point2D.Double center = (wave == null) ? null : wave.getCenter();
        center = ((center == null) || (getHim().getDistance() < RUN_DIST))
                ? super.getHim().pos()
                : center;
        double wallsSmooth = noFearFromWalls(30, center);
        super.setWallsFear(true);
        //Double.isNaN(wallsSmooth) || (super.getHim().getDistance() < 300));
        //        this.doTheFlatThing(center);
        int distanceManager = HOLD_OFF;
        if (getMe().getWallAlert().test()){//  || (getMe().getEnergy() >= getHim().getLastEnergy()*2D )) {
            distanceManager = GET_CLOSER;
        } else if (super.getHim().getDistance() < RUN_DIST) {
            distanceManager = RUN_AWAY;
        } else if ((getMe().getEnergy()*1.5 <= getHim().getLastEnergy() )){//super.getHim().getDistance() < MIN_DIST) {
            distanceManager = GET_AWAY;
        } else {
            distanceManager = HOLD_OFF;
        }
        if (super.isWallsFear()) {
            super.setAwayAmt(15);
            super.setCloserAmt((getHim().getDistance() > 100) ? -15 : 0);
            //((him.getDistance() < 300) || (!flat)) ? -15 : 0);
            super.setHoldOffAmt(0);
            super.setRunAwayAmt(45);
            this.doPerpendicularGigle(0, distanceManager, center);
            //him.pos() );
        } else {
            getMe().setTurnRight(wallsSmooth);
        }
        if (getMe().getTime() > 10) {
            if (getHim().getDistance() < RUN_DIST ) {
                
                super.walk(50);
            } else {
                beeingRammed = false;
                //        	if(navigator.getTimeToStop()>this.getMe().getTime() ){
                //        	
                //            this.walk(50);
                //        	}else{
                this.walk(navigator.getTravelDistance());
                //        	}
            }
        }
        this.draw();
    }
    public void walk(double dist) {
        double walkAmt = dist;
        walkAmt *= (getMe().isRe()) ? -1 : 1;
        getMe().setAhead(walkAmt);
    }
    public void enemyFired() {
        if (isFlat() && wave != null) {
            double dist = wave.getCenter().distance(getMe().pos());
            SegmentedGFs gfHolder = this.getHim().getBotData().getGfHistory();
            int newVel = 0;
            int lo = 0;
            int hi = 0;
            for (int i = -4; i <= 4; i++) {
                lo += gfHolder.countGF(dist, i + 8, 0, 4);
            }
            for (int i = 5; i <= 8; i++) {
                hi += gfHolder.countGF(dist, i + 8, 0, 2);
                hi += gfHolder.countGF(dist, -i + 8, 0, 4);
            }
            ArrayList goodGfs = gfHolder.getBestGFs(dist);
            newVel = ((Integer) goodGfs.get((int) Math.floor(Math.random()
                    * goodGfs.size()))).intValue();
            getMe().setMaxVelocity(newVel);
            if (Math.random() > 0.90) {
                invert();
            }
        }
    }
    /*
     * (non-Javadoc)
     * 
     * @see axeBots.pilot.FlatPilot#hitByBullet(double)
     */
    public void hitByBullet(double pw) {
//        EnemyWave wave = EnemyWave.getCurrentWave(super.getMe().pos());
        Course.hitByBullet();
//        if ((wave != null)
//                && Math.abs(wave.getGF(super.getMe().pos()) - 8) == 8) {
//            //            invert();
//        }
    }
    private void draw() {
        if (AxeBot.GL && (wave != null)) {
            double d = (getMe().getBotDim() / 2.0) * Math.sqrt(2.0);
            double h = getMe().getBattleFieldHeight() - (2 * d);
            double w = getMe().getBattleFieldWidth() - (2 * d);
            //            int
            // myDir=super.getMe().getDirection((int)super.getMe().getTime() ,
            // this.getHim());
            //gf0
            AxeVector gf = new AxeVector(wave.getCenter(), wave
                    .getMyOriginalPos());
            testpt.setPosition(wave.getMyOriginalPos().x, wave
                    .getMyOriginalPos().y);
            AxeVector vec = new AxeVector(wave.getCenter(), super.getMe().pos());
            double ray = vec.getModule();
            double arcWd = SegmentedGFs.getGFArcWdt(wave.getBulletPower(), ray);
            double sliceWd = SegmentedGFs.getGFSliceWdt(arcWd);
            //posiciona no meio da gf inicial
            gf.addTheta((wave.getDir() * (arcWd / 2D))
                    + (wave.getDir() * -1 * (sliceWd / 2D)));
            gf.setModule(ray);
            int myGf = wave.getMyGF();
            SegmentedGFs gfHolder = this.getHim().getBotData().getGfHistory();
            ellipse.setFrame(wave.getCenter().x - ray,
                    wave.getCenter().y + ray, ray * 2, ray * 2);
            centerPt.setPosition(wave.getCenter().x, wave.getCenter().y);
            wall.setBounds(d, d, w, h);
            Boolean dgrs[] = Course.getDangerPts ();
            //			(int i=(myDir<0)?gfPts.length-1: 0; (myDir<0)?(i >0):(i <
            // gfPts.length); i+=(myDir<0)?-1:1)
            for (int i = 0; i < gfPts.length; i++) {
                PointGL pt = gfPts[i];
                pt.setPosition(gf.getX(), gf.getY());
                //pt.setSize(6);
                Color c = dgrs[i]==null?Color.yellow : dgrs[i].booleanValue () ? gfBAD : gfOK;
                //gfHolder.isDangerPoint(3, ray, i) ? gfBAD : gfOK;
                if (i == myGf) {
                    //pt.setSize(8);
                    c = c.brighter();
                    c = c.brighter();
                    c = c.brighter();
                    c = c.brighter();
                    c = c.brighter();
                }
                pt.setColor(c);
                gf.addTheta(wave.getDir() * -1 * sliceWd);
            }
            DecimalFormat fmt = new DecimalFormat("0.00");
            double ptsPerVel = (SegmentedGFs.GF_QT-1)/ (8D * 2D);
            myGF.setColor(dgrs[myGf ]==null?Color.yellow : dgrs[myGf].booleanValue () ? gfBAD : gfOK);
            myGFlabel.setString(fmt.format((myGf - ((SegmentedGFs.GF_QT-1) / 2D))
                    / ptsPerVel));
            desiredGF
                    .setColor(navigator.getAimedGF()!=myGf ? Color.red : Color.green);
            desiredGFlabel
                    .setString(fmt
                            .format((navigator.getAimedGF() - ((SegmentedGFs.GF_QT-1) / 2D))
                                    / ptsPerVel));
            moveAmt.setString(Integer.toString(navigator.getTravelDistance()));
            re.setColor(getMe().isRe() ? Color.green : Color.red);
        }
    }
}
