package pl.Utilities;

/*******************************************************************************
 * A class with a few useful methods for use in Robocode bullet calculations.
 * All methods are static for ease of use.
 * 
 * Calculations are taken from http://robowiki.net/cgi-bin/robowiki?BeginnersFAQ
 ******************************************************************************/
public class BulletUtils {
	/**
	 * Calculates the velocity of a bullet based on power.
	 * 
	 * @param power Power of the bullet
	 * @return velocity of the bullet
	 */
	public static double bulletVelocity(double power) {
		return 20 - 3 * power;
	}

	/**
	 * Calculates the damage of a bullet based on power.
	 * 
	 * @param power Power of the bullet
	 * @return damage caused by the bullet
	 */
	public static double bulletDamage(double power) {
		return 4 * power + 2 * Math.max(power - 1, 0);
	}

	/**
	 * Calculates the heat generated by a bullet based on power.
	 * 
	 * @param power Power of the bullet
	 * @return heat generated by the bullet
	 */
	public static double bulletHeat(double power) {
		return 1 + (power / 5);
	}
}
