package jwst.DAD.Movement;

import java.awt.geom.*;

/********************************************************************************************
 * 
 * This class helps to keep track of all the information of the ourselves so that we can see
 * what the enemy is tracking about our information and move to a place where they won't hit 
 * us. If the enemy is using Guess Factor Targeting, he most likely tracks all this information
 * about us at the same time, so we can see what he is trying to do to us.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * @date June 10th, 2009
 * 
 * Credit: http://testwiki.roborumble.org/w/index.php?title=Wave_Surfing_Tutorial
 * Credit: http://testwiki.roborumble.org/w/index.php?title=BasicSurfer/Code
 * 
 ********************************************************************************************/
public class EnemyWave
{
    // a double array
    private double[] segment;
    // a location of where the enemy fired from, and a location from where I was when the
    // enemy DID fire
    private Point2D.Double firedLocation, myLocationAtFire;
    // keep track of my velocity, distance traveled, bearing, and direction in relation to
    // the enemy robot
    private double velocity, distanceTraveled, bearing, sign;
    // the time at which the enemy fired at me
    private long fireTime;
    
    /**
     * set the segment to be passed to this enemy wave
     * @param segment - an array
     */
    public void setSegment(double[] segment)
    { 
        this.segment = segment; 
    }
    
    /**
     * @return the segment passed earlier
     */
    public double[] getSegment()
    { 
        return segment; 
    }
    
    /**
     * set the location fired from
     * @param firedLocation - point2D from the location in which the enemy fired from
     */
    public void setFiredLocation(Point2D.Double firedLocation)
    { 
        this.firedLocation = firedLocation; 
    }
    
    /**
     * @return the location the enemy fired from
     */
    public Point2D.Double getFiredLocation()
    { 
        return firedLocation; 
    }
    
    /**
     * set the location i was at when the enemy fired
     * @param myLocationAtFire - a point2D of where i was when the enemy fired
     */
    public void setMyLocationAtFire(Point2D.Double myLocationAtFire)
    { 
        this.myLocationAtFire = myLocationAtFire; 
    }
    
    /**
     * @return the location i was at when the enemy fired at me
     */
    public Point2D.Double getMyLocationAtFire()
    { 
        return myLocationAtFire; 
    }
    
    /**
     * set the velocity i was traveling at when I was fired at
     * @param velocity - the velocity i was traveling at when the enemy fired
     */
    public void setVelocity(double velocity)
    { 
        this.velocity = velocity; 
    }
    
    /**
     * @return the velocity i was traveling at when the enemy fired at me
     */
    public double getVelocity()
    { 
        return velocity; 
    }
    
    /**
     * the distance I have traveled thus far from my starting position
     * @param distanceTraveled - the distance I have traveled thus far from my original
     * point when the enemy fired at me
     */
    public void setDistanceTraveled(double distanceTraveled)
    { 
        this.distanceTraveled = distanceTraveled; 
    }
    
    /**
     * @return the distance I have traveled thus far from my original point
     */
    public double getDistanceTraveled()
    { 
        return distanceTraveled; 
    }
    
    /**
     * set the bearing I was at from the point of view of the enemy robot when they fired
     * @param bearing - my bearing from the perspective of the enemy when they fired
     */
    public void setBearing(double bearing)
    { 
        this.bearing = bearing; 
    }
    
    /**
     * @return the bearing I was at when the enemy fired at me
     */
    public double getBearing()
    { 
        return bearing; 
    }
    
    /**
     * set the direction, from the point of view of the enemy, I was traveling in
     * @param sign - 1 or -1 depending on the direction I was traveling in from the perspective
     * of the enemy when they fired at me
     */
    public void setSign(double sign)
    { 
        this.sign = sign;
    }
    
    /**
     * @return the direction I was traveling in from the point of view of the enemy robot when they
     * fired at me
     */
    public double getSign()
    { 
        return sign; 
    }
    
    /**
     * set the time at which the enemy fired
     * @param fireTime - the time in the game at which the enemy fired
     */
    public void setFireTime(long fireTime)
    { 
        this.fireTime = fireTime; 
    }
    
    /**
     * @return the time in the game at which the enemy fired at me
     */
    public long getFireTime()
    { 
        return fireTime; 
    }
}