package jwst.DAD.Targeting;

import java.awt.geom.Point2D;
import robocode.util.Utils;
import jwst.DAD.utils.DADUtils;

/**********************************************************************************************
 * 
 * This wavebullet class helps to keep track of all of the enemies information. In the code
 * below our robot uses the enemy's movement patterns in order to figure out where he is most
 * likely to move and fire in that location.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * 
 * Credit: http://testwiki.roborumble.org/w/index.php?title=Maximum_Escape_Angle
 * Credit: http://testwiki.roborumble.org/w/index.php?title=GuessFactor_Targeting_Tutorial
 * 
 *********************************************************************************************/
public class WaveBullet
{
	//instance variables(variables that have several instances throguhout the code)
    private Point2D.Double myLocation;
    private double startBearing, power;
    private long fireTime;
    private int direction;
    private double[] binSegment;
    private boolean hasBullet;
    
    /**
     * A constructor for a wave bullet. To be used by the GFT gun
     * @param location
     * @param bearing
     * @param power
     * @param direction
     * @param time
     * @param binSegment
     * @param stats
     * @param indexes
     */
    public WaveBullet(Point2D.Double location, double bearing,
                      double power, int direction,
                      long time, double[] binSegment, 
                      double[][][][][] stats,
                      int[] indexes )
    {
        myLocation = location;
        startBearing = bearing;
        this.power = power;
        this.direction = direction;
        fireTime = time;
        this.binSegment = binSegment;
    }

    /**
     * set the boolean value if the wave does indeed have a bullet
     * @param b
     */
    public void setHasBullet(boolean b)
    { 
        hasBullet = b; 
    }
    
    /**
     * get the boolean value to see if the wave does indeed have a bullet
     * @return boolean value whether wave has a bullet
     */
    public boolean getHasBullet()
    { 
        return hasBullet; 
    }
    
    /**
     * @return my location when I fired the bullet
     */
    public Point2D.Double getMyLocation()
    { 
        return myLocation; 
    }
    
    /**
     * @return the time at which the bullet was fired
     */
    public long getFireTime()
    { 
        return fireTime; 
    }
    
    /**
     * @return the power of the bullet, whether it be imaginary or real
     */
    public double getPower()
    { 
        return power; 
    }
    
    /**
     * Check to see if the wave has passed the enemy
     * @param enemyLocation
     * @param currentTime
     * @return the boolean value indication whether the wave has passed the enemy
     */
    public boolean checkHit( Point2D.Double enemyLocation, long currentTime )
    {
        // if the distance from the wave origin to our enemy has passed
        // the distance the bullet would have traveled...
        if ( myLocation.distance( enemyLocation ) <= ( currentTime - fireTime )
            * DADUtils.bulletVelocity(power) )
        {
            double desiredDirection = Math.atan2( enemyLocation.getX()
                - myLocation.getX(), enemyLocation.getY() - myLocation.getY() );
            
            double angleOffset = Utils.normalRelativeAngle( desiredDirection
                - startBearing );
            double guessFactor = Math.max( -1, Math.min( 1, angleOffset
                / DADUtils.maxEscapeAngle(DADUtils.bulletVelocity(power)) ) )
                * direction;
            int index = (int)Math.round( ( binSegment.length - 1 ) / 2
                * ( guessFactor + 1 ) );
            // simple bin smoothing... basically add little to outsides lot to
            // the actual index to get a more curvy graph
            if(hasBullet)
                for (int i = 0; i < binSegment.length; i++) 
                {
                    binSegment[i] += 1D / (Math.pow(index - i, 2) + 1);
                }
            else
                for (int i = 0; i < binSegment.length; i++) 
                {
                    // basically make the ones that don't come with a bullet
                    // worth half as much
                    binSegment[i] += 1D / (Math.pow(index - i, 2) + 2);
                }
            
            return true;
        }
        return false;
    }
}