package theo.real.gun;
import theo.real.Ahab;
import theo.real.enemy.*;
import theo.real.wave.*;
import theo.real.utils.*;
import java.awt.geom.*;
import java.util.*;
import robocode.*;
import robocode.util.Utils;
/**
 * MyClass - a class by (your name here)
 */
public class GunHandler
{

	protected int gun = 0;

	public Ahab owner;
	Enemy enemy;
	static double bPower;
	static double bSpeed;
	
	ScannedRobotEvent ref;
	
	static double MAX_DISTANCE;
	static double MAX_TIME;
	
	public static List<Wave> waveList;
	
	static HashMap<double[],Double> factorMap, theoryMap;
	static List<double[]> theoryList;
	
	static double passingGF;
	
	static double[] stats;
	
	static final int NUM_NEIGHBORS;
	static final int SHOT_TIMER = 2;
	
	static double mainGunShots, theoryGunShots, antiSurferGunShots;
	static double mainGunHits, theoryGunHits, antiSurferGunHits;
	public static double mainGunAcc, theoryGunAcc, antiSurferGunAcc;
	static double mainGunAngle, theoryGunAngle, antiSurferGunAngle;
	boolean mainGun,theoryGun,antiSurferGun;
	public static long mainGunUses, antiSurferGunUses, theoryGunUses;
	public static long mainGunShotsFired, antiSurferGunShotsFired, theoryGunShotsFired;
	
	static {
		waveList = new ArrayList<Wave>();
		factorMap = new HashMap<double[],Double>();
		theoryMap = new HashMap<double[],Double>();
		theoryList = new ArrayList<double[]>();
		stats = new double[12];
		NUM_NEIGHBORS = 11;//9;
		passingGF = 0.0;
	}

	public GunHandler(Ahab owner, Enemy enemy){
		this.owner = owner;
		this.enemy = enemy;
		MAX_DISTANCE = owner.getBattleFieldWidth()*owner.getBattleFieldWidth();
		MAX_DISTANCE += owner.getBattleFieldHeight()*owner.getBattleFieldHeight();
		MAX_DISTANCE = Math.sqrt(MAX_DISTANCE);
		MAX_TIME = MAX_DISTANCE;
	}
	
	public void update(ScannedRobotEvent ref){
	
		this.MAX_TIME = Math.abs(this.liveMaxEscapeAngle())*Enemy.distance/5.5;
		
		this.ref = ref;
		this.advanceWaves();
		this.calcBPower();
		this.takeAim();
		this.fire();
		
	}
	
	public void calcBPower(){
		if(owner.isMC){
			this.bPower = 3.0;
		}
		else{
			//bPower = 1.7;
			bPower = Math.random()*(.2) + 1.5;
			if (Enemy.energy < 4.0){
				this.bPower =  WaveUtils.limit(0.1,Enemy.energy / 4.0,3.0);
			}
			else if (Enemy.energy <= 16.0){
				this.bPower = WaveUtils.limit(0.1,(Enemy.energy+2.0)/6.0,3.0);
			}
		}
		if(owner.getEnergy()<this.bPower&&owner.isMC){
			this.bPower = owner.getEnergy();
		}
		this.bSpeed = WaveUtils.bSpeed(bPower);
	}
	
	public void takeAim(){
	//////////////////////////////////////////////////////////////////////////////
		/*double bearingFromGun = Enemy.absBearing - owner.getGunHeadingRadians();
		bearingFromGun = Utils.normalRelativeAngle(bearingFromGun);
		owner.setTurnGunRightRadians(bearingFromGun);*/
	//////////////////////////////////////////////////////////////////////////////
		double maxTurn = Math.PI/15d;
		
		this.stats[0] = Enemy.distance/MAX_DISTANCE;
		this.stats[1] = Math.abs(Enemy.velocity)/8.0;
		this.stats[2] = radianToWallRatio();
		this.stats[3] = Math.min(Math.abs(Utils.normalRelativeAngle(Enemy.heading-Enemy.absAngle))/(Math.PI/2.0),1.0);
		this.stats[4] = Math.min((double)Enemy.timeSinceDirChange/(double)MAX_TIME, 1.0);
		this.stats[5] = passingGF*passingGF;
		this.stats[6] = Math.abs(Enemy.lastVelocity-Enemy.velocity)/2.0;
		this.stats[7] = Enemy.deltaHeading/maxTurn*Enemy.latDirection;// *(Enemy.velocity<0?-1:1);
		this.stats[8] = Math.abs(Enemy.latVelocity)/8.0;
		this.stats[9] = Enemy.latHeading/(Math.PI);
		this.stats[10] = bPower / 3.0;
		this.stats[11] = 36.0 / Enemy.distance;

		for (int i = 0; i < this.stats.length; i ++) {
			//if(Math.abs(this.stats[i])>1.0){
			//	System.out.println(this.stats[i] + " at " + i + " in gun");
			//}
			this.stats[i] = WaveUtils.limit(-1.0,this.stats[i],1.0);
		}

		///////////////////////////////////////////////////////////////////////////////////////////
		List<Double> offsetGroup = WaveUtils.findNearestNeighbors(stats, factorMap, NUM_NEIGHBORS);
		///////////////////////////////////////////////////////////////////////////////////
		List<Double> offsetGroup2 = WaveUtils.findNearestNeighbors(stats, theoryMap, 4*NUM_NEIGHBORS);
		//////////////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////////////////////
		
		Enemy.width = 36.0/Enemy.distance;
		long density, maxDensity = 0;
		double angle1, angle2, deltaTheta;
		double desiredAngle = Enemy.absBearing;

		mainGunAngle = (antiSurferGunAngle = (theoryGunAngle = (desiredAngle)));

		for(Double offset1 : offsetGroup){
			density = 0;
			angle1 = liveAngleForOffset(offset1);
			for(Double offset2 : offsetGroup){
				if (offset1 != offset2){
					angle2 = liveAngleForOffset(offset2);
					deltaTheta = Utils.normalRelativeAngle(angle2-angle1);
					if (Math.abs(deltaTheta) < Enemy.width){
						density ++;
					}
				}
			}
			if (density >= maxDensity){
				maxDensity = density;
				//desiredAngle = angle1;//liveAngleForOffset(offset1*((double)Enemy.latDirection));
				mainGunAngle = angle1;
			}
		}
		
		///////////////////////////////////////////////////////////////////////////////////
		//offsetGroup = (List<Double>)WaveUtils.findNearestNeighbors(stats, theoryMap, NUM_NEIGHBORS);
		//////////////////////////////////////////////////////////////////////////////////
		double minOffset = 0.0;
		double maxOffset = 0.0;
		for(Double offset1 : offsetGroup){
			if(offset1<minOffset){
				minOffset = offset1;
			}
			if(offset1>maxOffset){
				maxOffset = offset1;
			}
		}


		maxDensity = 0;
	//	for(double offset1 = minOffset; offset1 < maxOffset; offset1 += 0.001){
		for(Double offset1 : offsetGroup){
	//	for(double offset1 = -1*Math.abs(liveMaxEscapeAngle()); offset1 <= Math.abs(liveMaxEscapeAngle()); offset1 += Enemy.width){
	//	for(double fact = -.750; fact <= .750; fact += 0.01){
			density = 0;
			angle1 = liveAngleForOffset(offset1);
		//	angle1 = liveAngleForOffset(fact);
		//	angle1 = Utils.normalRelativeAngle(offset1 + Enemy.absBearing);
	//		for(double fact = -1.0; fact <= 1.0; fact += 0.01){
			for(Double offset2 : offsetGroup2){
				if(offset2!=offset1){
					angle2 = liveAngleForOffset(offset2);
					deltaTheta = Utils.normalRelativeAngle(angle2-angle1);
					density += Math.pow(Math.E, .5d*(deltaTheta/Enemy.width)*(deltaTheta/Enemy.width))/8.0;
				}
			/*	if (density >= maxDensity){
				maxDensity = density;
				//desiredAngle = angle1;//liveAngleForOffset(offset1*((double)Enemy.latDirection));
				antiSurferGunAngle = angle1;
			}*/
			}
			for(Double offset3 : offsetGroup){
				angle2 = liveAngleForOffset(offset3);
				deltaTheta = Utils.normalRelativeAngle(angle2-angle1);
				density += Math.pow(Math.E, .5d*(deltaTheta/Enemy.width)*(deltaTheta/Enemy.width));
			}
		/*	for(Double offset2 : offsetGroup){
				if (offset1 != offset2){
					angle2 = liveAngleForOffset(offset2);
					deltaTheta = Utils.normalRelativeAngle(angle2-angle1);
					density += Math.pow(Math.E, .5d*(deltaTheta/Enemy.width)*(deltaTheta/Enemy.width));
				}
			} */
			if (density >= maxDensity){
				maxDensity = density;
				//desiredAngle = angle1;//liveAngleForOffset(offset1*((double)Enemy.latDirection));
				antiSurferGunAngle = angle1;
			}
		}	

		maxDensity = 0;
		for(Double offset1 : offsetGroup2){
			density = 0;
			angle1 = liveAngleForOffset(offset1);
			for(Double offset2 : offsetGroup2){
				if (offset1 != offset2){
					angle2 = liveAngleForOffset(offset2);
					deltaTheta = Utils.normalRelativeAngle(angle2-angle1);
					if (Math.abs(deltaTheta) < Enemy.width){
						density ++;
					}
				}
			}
			if (density >= maxDensity){
				maxDensity = density;
				//desiredAngle = angle1;//liveAngleForOffset(offset1*((double)Enemy.latDirection));
				theoryGunAngle = angle1;
			}
		}
		
		double maxAcc = Math.max(Math.max(mainGunAcc,theoryGunAcc),antiSurferGunAcc);
		
		
		if(maxAcc == antiSurferGunAcc){
			gun = 1;
			if(!antiSurferGun){
				mainGun = false; theoryGun = false; antiSurferGun = true;
				System.out.println("Switching: Anti-Surfer Gun");
				antiSurferGunUses ++;
			}
		}
		else if(maxAcc == mainGunAcc){
			gun = 0;
			if(!mainGun){
				mainGun = true; theoryGun = false; antiSurferGun = false;
				System.out.println("Switching: Main Gun");
				mainGunUses ++;
			}
		}
		else if(maxAcc == theoryGunAcc){
			gun = 2;
			if(!theoryGun){
				mainGun = false; theoryGun = true; antiSurferGun = false;
				System.out.println("Switching: Theory Gun");
				theoryGunUses ++;
			}
		}
		
		switch(gun){
			case 0:
				desiredAngle = mainGunAngle;
				break;
			case 1:
				desiredAngle = antiSurferGunAngle;
				break;
			case 2:
				desiredAngle = theoryGunAngle;
				break;
			default:
				desiredAngle = Enemy.absBearing;
				break;
		}
		
		double bearingFromGun = desiredAngle - owner.getGunHeadingRadians();
		bearingFromGun = Utils.normalRelativeAngle(bearingFromGun);
		owner.setTurnGunRightRadians(bearingFromGun);
	}
	
	public void fire(){
		if(owner.getGunTurnRemainingRadians() < Enemy.width / 3.0
			&& owner.getGunHeat() == 0
				&& (owner.getEnergy() > bPower
					| owner.isMC) && owner.getEnergy() > 0
						&& (waveList.size() <= 1 
							| Enemy.energy < owner.getEnergy() | true )){
			this.spawnWave(true);
			this.mainGunShots++; this.antiSurferGunShots++; this.theoryGunShots++;
		}
		if(owner.getTime()%SHOT_TIMER == 0 && owner.getEnergy() > bPower){
			this.spawnWave(false);
			/*this.antiSurferGunShots++;*/// this.theoryGunShots++;
		}
	}
	
	public void spawnWave(boolean real){
		Wave wave = new Wave();
		wave.startPoint = (Point2D.Double)this.owner.pos.clone();
		wave.velocity = bSpeed;
		wave.targetVelocity = Enemy.velocity;
		wave.startBearing = WaveUtils.absBearing(owner.pos,Enemy.pos);//Enemy.absBearing;
		wave.maxEscapeAngle = Math.asin(8/bSpeed) * Enemy.latDirection;
		wave.distance = Enemy.distance;
		wave.timeOfShot = owner.getTime();
		wave.stats = this.stats.clone();
		wave.isReal = real;
		wave.mainGunAngle = this.mainGunAngle;
		wave.antiSurferGunAngle = this.antiSurferGunAngle;
		wave.theoryGunAngle = this.theoryGunAngle;
		if(wave.isReal){
			if(mainGun==true){
				mainGunShotsFired++;
			}
			else if(theoryGun==true){
				theoryGunShotsFired++;
			}
			else if(antiSurferGun==true){
				antiSurferGunShotsFired++;
			}
		}
		waveList.add(wave.doClone());
		owner.setFire(bPower);
	}
	
	public void advanceWaves(){
		for (int i = 0; i < waveList.size(); i ++){
			Wave wave = waveList.get(i);
			wave.distTraveled = (owner.getTime() - wave.timeOfShot) * wave.velocity;
			if(wave.distTraveled > wave.startPoint.distance(Enemy.pos)){
				storeWave(wave);
				waveList.remove(wave);
				i --;
			}
		}
	}
	
	public void storeWave(Wave wave){
		wave.endBearing = WaveUtils.absBearing(wave.startPoint,Enemy.pos);
		wave.factor = Utils.normalRelativeAngle(wave.endBearing-wave.startBearing);
		wave.factor /= wave.maxEscapeAngle;
		assert Math.abs(wave.factor) <= 1;
		if(wave.isReal){
			factorMap.put(wave.stats.clone(),wave.factor);
			mainGunHits += checkHit(0, wave);
			mainGunAcc = mainGunHits / mainGunShots;
			antiSurferGunHits += checkHit(1, wave);
			antiSurferGunAcc = antiSurferGunHits / antiSurferGunShots;
			theoryGunHits += checkHit(2, wave);
			theoryGunAcc = theoryGunHits / theoryGunShots;
		}
		else{
			theoryMap.put(wave.stats,wave.factor);
			theoryList.add(wave.stats);
			if(theoryMap.keySet().size()>=500){
				try{
					theoryMap.remove(theoryList.get(0));
				}
				catch(Exception e){
					System.out.println("Not Removing");
				}
				theoryList.remove(theoryList.get(0));
			}
		}
		passingGF = wave.factor;
		//System.out.println("caught at : " + passingGF);
	}
	
	double checkHit(int g, Wave wave){
		double startAngle = wave.mainGunAngle;
		switch(g){
			case 0:
				startAngle = wave.mainGunAngle;
				break;
			case 1:
				startAngle = wave.antiSurferGunAngle;
				break;
			case 2:
				startAngle = wave.theoryGunAngle;
				break;
			default:
				break;
		}
		double diff = Utils.normalRelativeAngle(wave.endBearing - startAngle);
	//	double botWidths = 36d/wave.startPoint.distance(Enemy.pos);
		return (Math.abs(diff/Enemy.width)<=1.0?1:0);
	}

	double liveAngleForOffset(double offset){
		return Utils.normalRelativeAngle(
				offset*liveMaxEscapeAngle()+Enemy.absBearing);
	}
	double liveMaxEscapeAngle(){
		return Math.asin(8.0/this.bSpeed)*Enemy.latDirection;
	}
	
	double radianToWallRatio(){
		Point2D.Double projPos = (Point2D.Double)Enemy.pos.clone();
		double mEA = Math.abs(liveMaxEscapeAngle()), thetaOffset = 0;
		while(Math.abs(thetaOffset) < mEA && owner.playField.contains(projPos)){
			thetaOffset += 0.015 * Enemy.latDirection;
			projPos = WaveUtils.project(owner.pos, Enemy.distance, Enemy.absBearing + thetaOffset);
		}
		thetaOffset = Math.min(Math.abs(thetaOffset), mEA);
		return thetaOffset/mEA;
	}
	
	

}
