package axeBots.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import axeBots.AxeException;
import axeBots.util.RoboMath;

/**
 * OptimizedBitBuffer - 11/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZs comment about
 * OpenSouce: "At least is a good Karma".
 */

public class OptimizedBitBuffer {

	private StringBuffer bitBuffer = new StringBuffer();
	private long size = 0;
	private long readIndex = 0;
	private int tail = 0;

	public OptimizedBitBuffer() {
		super();
	}

	public void clear() {
		bitBuffer = new StringBuffer();
		size = 0;
		tail = 0;
	}

	public double getCoded(int bits, double divs, double min, double max)
			throws AxeException {
		if ((bits > 32) || (bits == 0)) {
			throw new AxeException("parametro divs invalido!");
		}

		if ((min >= max)) {
			throw new AxeException("parametro min >= max");
		}

		double deslocamento0 = 0 - min;
		double ret = this.get(bits);
		double delta = max - min;
		double x = delta / divs;
		ret = ret * x;
		ret -= deslocamento0;
		return ret;
	}

	public void addCoded(int bits, double val, double divs, double min,
			double max) throws AxeException {
		if ((bits > 32) || (bits == 0)) {
			throw new AxeException("parametro divs invalido!");
		}

		if ((min >= max)) {
			throw new AxeException("parametro min >= max");
		}

		double desloc = 0 - min;
		val = (val < min) ? min : (val > max) ? max : val;
		double delta = max - min;
		double x = delta / divs;
		val = RoboMath.roundToPrecision(val, x);
		val = val + desloc;
		char out = (char) Math.round(val / x);
		add(out, bits);

	}

	public void add(char val, int bits) {

		int tam = (int) bits;
		int resto = (int) (size % 16);
		int mask = this.getMask(bits);
		val = (char) (val & mask);
		int intVal = ((int) val) << (16 + (16 - tam - resto));
		mask <<= (16 + (16 - tam - resto));
		tail |= intVal;

		size += bits;
		tam = (int) (size / 16);
		resto = (int) (size % 16);

		if (tam > bitBuffer.length()) {
			this.grow();
		}

	}

	public char get(int bits) {
		int pos = (int) (readIndex / 16);
		int resto = (int) (readIndex % 16);

		int ahd = ((pos + 1) >= bitBuffer.length()) ? 0 : bitBuffer
				.charAt(pos + 1);

		int zoom = (((int) bitBuffer.charAt(pos)) << 16) + ahd;

		int mask = this.getMask(bits);
		mask <<= (16 + (16 - resto - bits));
		int ret = zoom & mask;
		ret >>>= (16 + (16 - resto - bits));
		readIndex += bits;
		return (char) ret;
	}

	public void setBuffer(String buf) {
		bitBuffer = new StringBuffer(buf);
		size = bitBuffer.length();
		tail = 0;
	}

	public String getBuffer() {
		StringBuffer ret = new StringBuffer(bitBuffer.toString());
		ret.append((char) (tail >>> 16));
		return ret.toString();
	}

	public void saveTo(DataOutputStream w) throws IOException {
		String out = getBuffer();
		w.writeInt((int) out.length());
		for (int k = 0; k < out.length(); k++) {
			w.writeChar(out.charAt(k));
		}
	}

	public void loadFrom(DataInputStream r) throws IOException {
		int strSz = r.readInt();
		StringBuffer inbuf = new StringBuffer(strSz);
		for (int k = 0; k < strSz; k++) {
			char in = r.readChar();
			inbuf.append(in);
		}
		this.setBuffer(inbuf.toString());
	}

	private int getMask(int bits) {
		int ret = (int) (Math.pow(2, bits) - 1);
		return ret;
	}

	private void grow() {
		bitBuffer.append((char) (tail >>> 16));
		tail <<= 16;
	}

}