package axeBots.data;

import java.util.ArrayList;

import axeBots.util.RoboMath;

/**
 * PMShootingData - 28/10/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZs comment about
 * OpenSouce: "At least is a good Karma".
 */
public class PMShootingData {

	private double[] bukmax;
	private double[] bukmin;
	private double[] bukAmt;

	private ArrayList bukPS[];
	private int bestBuk;
	private double refAng;
	private int buks;

	public PMShootingData() {
		super();
	}

	public int rateAngs(PatternSample ps[], double[] angs, double refAng,
			double dist, double precision) {

		if (angs.length < 1) {
			return 0;
		}
		this.refAng = refAng;
		
		double min = 400;
		double max = -400;
		//pega o delta dos angulos
		int cnt = 0;
		for (int i = 0; i < angs.length; i++) {
			if (Double.isNaN(angs[i])) {
				continue;
			}
			if (angs[i] < min) {
				min = angs[i] - 0.001;
			}

			if (angs[i] > max) {
				max = angs[i] + 0.001;
			}
			cnt++;
		}

		if (cnt == 0) {
			return 0;
		}

		//calcula a granulometria baseado no deslocamento nesta distancia e
		// deltaAng
		double diff = Math.abs(max - min);
		diff = (diff < 1) ? 1 : diff;
		double desloc = (2 * Math.PI * dist) * (diff / 360);

		buks = (int) Math.ceil(desloc / precision);
		double bukSz = diff / buks;

		//////ALTERADO: NOVA ESCOLHA DE ANGULO PARA PM-GUN!!!
		bukmax = new double[buks];
		bukmin = new double[buks];
		bukAmt = new double[buks];
		bukPS = new ArrayList[buks];

		for (int i = 0; i < buks; i++) {
			bukmin[i] = min + (i * bukSz);
			bukmax[i] = bukmin[i] + bukSz;
			bukPS[i] = new ArrayList();
		}

		for (int j = 0; j < angs.length; j++) {
			if (Double.isNaN(angs[j])) {
				continue;
			}
			for (int i = 0; i < buks; i++) {
				if ((angs[j] >= bukmin[i]) && (angs[j] <= bukmax[i])) {
					bukAmt[i] += 1D / (ps[j].getItsRate() + 1D);
					bukPS[i].add(ps[j]);
					ps[j].setBucket(i);
					break;
				}
			}
		}
		bukAmt = RoboMath.smooth(bukAmt, 2.00);
		bestBuk = RoboMath.getMaxIndex(bukAmt);
		double mid = (bukmax[bestBuk] + bukmin[bestBuk]) / 2;
		int midSmp = 0;
		double midMin = Double.POSITIVE_INFINITY;

		//procura a amostra mais proxima do meio do bucket
		for (int j = 0; j < angs.length; j++) {

			if (Double.isNaN(angs[j]) || ps[j].getBucket() != bestBuk) {
				continue;
			}

			double dif = Math.abs(angs[j] - mid);
			if (dif < midMin) {
				midMin = dif;
				midSmp = j;
			}

		}
		
		return midSmp; 

	}

	public void hit(double ang, double dist) {
		
		double tol = (360D * 20D) / (2D * Math.PI * dist);
		for (int i = 0; i < buks; i++) {
			double mid = ((bukmax[i] + bukmin[i]) / 2D)+refAng;
			if (Math.abs(mid - ang) <= tol) {
				for (int j = 0; j < bukPS[bestBuk].size(); j++) {
					((PatternSample) bukPS[bestBuk].get(j)).hit();
				}
			}
		}

	}

}