/*
 * Created on 01/11/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.pilot;
//import java.awt.Color;
import java.awt.geom.*;

//import robocode.robocodeGL.system.GLRenderer;
import axeBots.silversurfer.*;
import axeBots.util.*;
import axeBots.*;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class AxePilot {
    private SilverSurfer me= null;
    private int wallBk= (8 + 6 + 4 + 2);
    private double maxVelocity= AxeBot.MAX_VEL;
    private boolean useSynchro= true;
    private boolean synchroWall= false;
    private boolean wallsFear= true;
    private long lastReversed= 0;
    private int holdOffAmt= 0;
    private int runAwayAmt= 30;
    private int awayAmt= 15;
    private int closerAmt= -15;
    //private boolean rammAvoid = false;

    public static final int HOLD_OFF= 0;
    public static final int GET_CLOSER= -1;
    public static final int GET_AWAY= 1;
    public static final int RUN_AWAY= 2;
//    private GLRenderer renderer;

    /**
     * 
     */
    public AxePilot() {
        super();
        me= (SilverSurfer)AxeBot.getIt();
    }

    public abstract void move();

    public abstract void start();

    public abstract void stop();

    /**
    	 * @return
    	 */
    public long getLastReversed() {
        return lastReversed;
    }

    /**
     * @param l
     */
    public void setLastReversed(long l) {
        lastReversed= l;
    }

    public abstract void botHitBot();
    public abstract void botHitWall();

    public void invert() {
        this.synchroWall= false;
        getMe().doRe();
        lastReversed= getMe().getTime();
        //			  AxeBot.getIt().out.println(">>> invertendo." + lastReversed);
    }

    public SilverSurfer getMe() {
        return me;
    }
    protected double getAngleTo(Point2D.Double p) {
        AxeVector meTo= new AxeVector(getMe().pos(), p);

        return RoboMath.normalRelativeAngle(meTo.getRelativeTheta());
    }

    public void walk(double dist) {

        //        double velmod= Math.abs(getMe().getVelocity());
        //        while (velmod > 0) {
        //            wallBk += velmod;
        //            velmod -= 2;
        //        }
        //wallBk += (8+6+4+2);
        double walkAmt= dist;

        if (wallsFear) {

            int wallSlack= wallBk;
            int synchroSlack= wallSlack + 100;
            if (me.isRe()) {
                dist *= -1;
                wallSlack *= -1;
                //synchroSlack *= -1;
            }

            //newSmoother();
            AxeVector moving=
                new AxeVector(me.getX(), me.getY(), me.getHeading(), wallSlack);
            int ma= (int)getDistToWall(moving);
            //		me.out.println(" wallBk:" + wallSlack+" ma:" + ma+ " at:"+me.getTime() + " re:"+me.isRe()+" head:"+me.getHeading()+" pos:"+me.pos()  );
            if (Math.abs(ma) < Math.abs(wallSlack)) {
                //                        me.out.println(
                //                            "RRRRRRRREEEEEEEEEEE!!!!! ma:" + ma + " wallBk:" + wallSlack);
                if (!wallsFear) {

                    this.wallBk=
                        (int) (20.00 + Math.random() * 40.00) + (8 + 6 + 4 + 2);
                }else{
					wallBk= (8 + 6 + 4 + 2);
                }
                //            me.out.println(
                //                "RRRRRRRREEEEEEEEEEE!!!!! ma:" + ma + " wallBk:" + wallBk);
                this.botHitWall();
                //me.doRe();

            }

            if (wallsFear) {
                moving.setModule(Math.abs(synchroSlack));
                ma= (int)getDistToWall(moving);

                this.synchroWall=
                    (useSynchro)
                        ? (Math.abs(ma) < Math.abs(synchroSlack))
                        : false;
            }

        }
        //		me.out.println(
        //						"walk ma:" + ma + " re:" + me.isRe() );
        walkAmt *= (me.isRe()) ? -1 : 1;
        me.setAhead(walkAmt);
    }

    public void synchro() {
        //me.out.println("synchro?");
        if (synchroWall && useSynchro) {
//            me.out.println("synchro!!!!!!!!!!!!!!!!!!!!!");
            this.botHitWall();
        }
    }

    protected double noFearFromWalls(double limitAng, Point2D.Double center) {
        double slack= 40;
        if (me.isRe()) {
            slack *= -1;
        }

        double toEnemy= this.getAngleTo(center);
        //double perpendicular= toEnemy + 90;

        //newSmoother();
        AxeVector moving=
            new AxeVector(me.getX(), me.getY(), me.getHeading(), slack);

        double ret= Double.NaN;
        double d= (me.getBotDim() / 2.0) * Math.sqrt(2.0);
        double h= me.getBattleFieldHeight() - d;
        double w= me.getBattleFieldWidth() - d;
        //double s= this.getHeight();
        Line2D.Double no= new Line2D.Double(d, h, w, h);
        Line2D.Double su= new Line2D.Double(d, d, w, d);
        Line2D.Double le= new Line2D.Double(w, h, w, d);
        Line2D.Double oe= new Line2D.Double(d, d, d, h);
        Line2D.Double to=
            new Line2D.Double(moving.getStartPoint(), moving.getEndPoint());
        //			  me.out.println("EU: p1:" + to.getP1() + ", p2:" + to.getP2());
//        Point2D.Double ptUs= moving.getStartPoint();
        double realHead=
            RoboMath.normalRelativeAngle(moving.getRelativeTheta());
        //			me.out.println((me.goingNorte())?"me.goingNorte()":(me.goingSul())?"me.goingSul()":(me.goingLeste ())?"me.goingLeste()":(me.goingOeste())?"me.goingOeste()":"me.goingNONE");

        //        //verifica se jah passou do ponto:
        //        if ((me.goingNorte() && (me.getY() >= h))
        //            || (me.goingSul() && (me.getY() <= d))
        //            || (me.goingLeste() && (me.getX() >= w))
        //            || (me.goingOeste() && (me.getX() <= d))) {
        //            ret= 0;
        //            //				  me.out.println(
        //            //					   "PASSOU DO PONTO:" + ret + " EU:" + ptUs.x + "," + ptUs.y);
        //        } else 
        if (to.intersectsLine(no)
            && me.goingNorte()
            && (Math.abs(Math.abs(toEnemy) - 90) > limitAng)) {
            ret= (realHead > 0) ? (90D - realHead) : (-90D - realHead);
            //			me.out.println("no fear parede norte. "+toEnemy);
        } else if (
            to.intersectsLine(su)
                && me.goingSul()
                && (Math.abs(Math.abs(toEnemy) - 90) > limitAng)) {
            ret= (realHead > 0) ? (90D - realHead) : (-90D - realHead);
            //			me.out.println("no fear parede sul. "+toEnemy);
        } else if (
            to.intersectsLine(le)
                && me.goingLeste()
                && ((Math.abs(toEnemy) > limitAng)
                    && (Math.abs(toEnemy) < (180 - limitAng)))) {
            ret= (realHead > 90) ? (180D - realHead) : (-realHead);
            //			me.out.println("no fear parede leste. "+toEnemy);
        } else if (
            to.intersectsLine(oe)
                && me.goingOeste()
                && ((Math.abs(toEnemy) > limitAng)
                    && (Math.abs(toEnemy) < (180 - limitAng)))) {
            ret= (realHead > -90) ? (-realHead) : (-180D - realHead);
            //			me.out.println("no fear parede oeste. "+toEnemy);
        }

        return ret;
    }
    
	protected boolean isFear(Point2D.Double center,AxeVector vec,double limitAng) {
//		AxeVector meTo= new AxeVector(vec.getStartPoint() , center);
			
		double toEnemy= this.getAngleTo(center);

//			double ret= Double.NaN;
			double d= (me.getBotDim() / 2.0) * Math.sqrt(2.0);
			double h= me.getBattleFieldHeight() - d;
			double w= me.getBattleFieldWidth() - d;
			//double s= this.getHeight();
			Line2D.Double no= new Line2D.Double(d, h, w, h);
			Line2D.Double su= new Line2D.Double(d, d, w, d);
			Line2D.Double le= new Line2D.Double(w, h, w, d);
			Line2D.Double oe= new Line2D.Double(d, d, d, h);
			Line2D.Double to=
				new Line2D.Double(vec.getStartPoint(), vec.getEndPoint());
			//			  me.out.println("EU: p1:" + to.getP1() + ", p2:" + to.getP2());
//			Point2D.Double ptUs= vec.getStartPoint();
//			double realHead=
//				RoboMath.normalRelativeAngle(vec.getRelativeTheta());
			//			me.out.println((me.goingNorte())?"me.goingNorte()":(me.goingSul())?"me.goingSul()":(me.goingLeste ())?"me.goingLeste()":(me.goingOeste())?"me.goingOeste()":"me.goingNONE");

			//        //verifica se jah passou do ponto:
			//        if ((me.goingNorte() && (me.getY() >= h))
			//            || (me.goingSul() && (me.getY() <= d))
			//            || (me.goingLeste() && (me.getX() >= w))
			//            || (me.goingOeste() && (me.getX() <= d))) {
			//            ret= 0;
			//            //				  me.out.println(
			//            //					   "PASSOU DO PONTO:" + ret + " EU:" + ptUs.x + "," + ptUs.y);
			//        } else 
			if (to.intersectsLine(no)
				
				&& (Math.abs(Math.abs(toEnemy) - 90) > limitAng)) {
				return true;
				//			me.out.println("no fear parede norte. "+toEnemy);
			} else if (
				to.intersectsLine(su)
				
					&& (Math.abs(Math.abs(toEnemy) - 90) > limitAng)) {
						return true;
				//			me.out.println("no fear parede sul. "+toEnemy);
			} else if (
				to.intersectsLine(le)
				
					&& ((Math.abs(toEnemy) > limitAng)
						&& (Math.abs(toEnemy) < (180 - limitAng)))) {
							return true;
				//			me.out.println("no fear parede leste. "+toEnemy);
			} else if (
				to.intersectsLine(oe)
				
					&& ((Math.abs(toEnemy) > limitAng)
						&& (Math.abs(toEnemy) < (180 - limitAng)))) {
							return true;
				//			me.out.println("no fear parede oeste. "+toEnemy);
			}

			return false;
		}

    protected double getDistToWall(AxeVector moving) {
        double ret= moving.getModule();
        double d= (me.getBotDim() / 2.0) * Math.sqrt(2.0);
        double h= me.getBattleFieldHeight() - d;
        double w= me.getBattleFieldWidth() - d;
        //double s= this.getHeight();
        Line2D.Double no= new Line2D.Double(d, h, w, h);
        Line2D.Double su= new Line2D.Double(d, d, w, d);
        Line2D.Double le= new Line2D.Double(w, h, w, d);
        Line2D.Double oe= new Line2D.Double(d, d, d, h);
        Line2D.Double to=
            new Line2D.Double(moving.getStartPoint(), moving.getEndPoint());
        //        me.out.println("EU: p1:" + to.getP1() + ", p2:" + to.getP2());
        Point2D.Double ptUs= moving.getStartPoint();

        //		me.out.println((me.goingNorte())?"me.goingNorte()":(me.goingSul())?"me.goingSul()":(me.goingLeste ())?"me.goingLeste()":(me.goingOeste())?"me.goingOeste()":"me.goingNONE");

        //verifica se jah passou do ponto:
        if ((me.goingNorte() && (me.getY() >= h))
            || (me.goingSul() && (me.getY() <= d))
            || (me.goingLeste() && (me.getX() >= w))
            || (me.goingOeste() && (me.getX() <= d))) {
            ret= 0;
            //            me.out.println(
            //            	   "PASSOU DO PONTO:" + ret + " EU:" + ptUs.x + "," + ptUs.y);
        } else if (to.intersectsLine(no) && me.goingNorte()) {
            ret= 0;
            //no.setLine(d, h - s, w, h - s);
            Point2D.Double intWall= RoboMath.lineIntersectsLine(to, no);
            if (intWall != null) {

                ret= ptUs.distance(intWall);
                //                                 me.out.println(
                //                                				"VAI BATER NORTE:"
                //                                					+ ret
                //                                					+ " PT:"
                //                                					+ intWall.x
                //                                					+ ","
                //                                					+ intWall.y
                //                                					+ " EU:"
                //                                					+ ptUs.x
                //                                					+ ","
                //                                					+ ptUs.y);
            }
        } else if (to.intersectsLine(su) && me.goingSul()) {
            ret= 0;
            //su.setLine(d, d + s, w, d + s);
            Point2D.Double intWall= RoboMath.lineIntersectsLine(to, su);
            if (intWall != null) {

                ret= ptUs.distance(intWall);
                //                                me.out.println(
                //                                			   "VAI BATER SUL:"
                //                                				   + ret
                //                                				   + " PT:"
                //                                				   + intWall.x
                //                                				   + ","
                //                                				   + intWall.y
                //                                				   + " EU:"
                //                                				   + ptUs.x
                //                                				   + ","
                //                                				   + ptUs.y);
            } /*else
                                                                                                               																																																																																																																																																																																																																																																																																																																																																																																																																																																																																													   out.println("VAI BATER sul.");*/
        } else if (to.intersectsLine(le) && me.goingLeste()) {
            ret= 0;
            //no.setLine(w - s, h, w - s, d);
            Point2D.Double intWall= RoboMath.lineIntersectsLine(to, le);
            if (intWall != null) {

                ret= ptUs.distance(intWall);
                //                                me.out.println(
                //                                			   "VAI BATER LESTE:"
                //                                				   + ret
                //                                				   + " PT:"
                //                                				   + intWall.x
                //                                				   + ","
                //                                				   + intWall.y
                //                                				   + " EU:"
                //                                				   + ptUs.x
                //                                				   + ","
                //                                				   + ptUs.y);
            } /*else
                                                                                                               																																																																																																																																																																																																																																																																																																																																																																																																																																																																																													   out.println("VAI BATER leste.");*/
        } else if (to.intersectsLine(oe) && me.goingOeste()) {
            ret= 0;
            //no.setLine(d + s, d, d + s, h);
            Point2D.Double intWall= RoboMath.lineIntersectsLine(to, oe);
            if (intWall != null) {

                ret= ptUs.distance(intWall);
                //                                me.out.println(
                //                                			   "VAI BATER OESTE:"
                //                                				   + ret
                //                                				   + " PT:"
                //                                				   + intWall.x
                //                                				   + ","
                //                                				   + intWall.y
                //                                				   + " EU:"
                //                                				   + ptUs.x
                //                                				   + ","
                //                                				   + ptUs.y);
            } /*else
                                                                                                               																																																																																																																																																																																																																																																																																																																																																																																																																																																																																													   out.println("VAI BATER oeste:");*/
        }

        if (ret < 0)
            ret= 0;
        //out.println("getDistToWall: ret" + ret);
        return Math.round(ret);
    }

    protected void doPerpendicular() {
        if (getMe().getTurnRemaining() == 0) {
            if ((getMe().getMyTarget() != null)
                && (getMe().getMyTarget().isAlive())) {

                Point2D.Double myTargetPos= getMe().getMyTarget().pos();
                double toEnemy= this.getAngleTo(myTargetPos);
//                double var= 90;
                double rnd= 0;
                //(Math.random() * var) - (var / 2);
                //perpendicular
                double perpendicular;
                if (getMe().isRe()) {
                    perpendicular= toEnemy + (90 + rnd);
                } else {
                    perpendicular= toEnemy - (90 + rnd);
                }

                double turnRight= realTurnBotTo(perpendicular);
                getMe().setTurnRight(turnRight);
            }
        }
    }

    protected void doPerpendicularGigle(
        double gigle,
        int distManagementMode,
        Point2D.Double center) {
        // double gig = 45;
        //out.println("   GIGLE:" + this.getTurnRemaining());
        if (((int)getMe().getTurnRemaining() == 0)
            && (getMe().getMyTarget() != null)
            && (getMe().getMyTarget().isAlive())) {
            double away= 0;
            switch (distManagementMode) {
                case HOLD_OFF :
                    away= this.getHoldOffAmt();
                    break;
                case RUN_AWAY :
                    away= this.getRunAwayAmt();
                    break;
                case GET_AWAY :
                    away= this.getAwayAmt();
                    break;

                case GET_CLOSER :
                    away= this.getCloserAmt(); //-15;
                    break;
            }

            away *= (getMe().isRe()) ? -1 : 1;

            double toEnemy= this.getAngleTo(center);
            double perpendicular= toEnemy + 90 + away;
            double turnRight= turnBotTo(perpendicular);
            getMe().setTurnRight(turnRight);

        }
    }

    //    protected void doPerpendicularGigle(double gigle) {
    //        //out.println("   GIGLE:" + this.getTurnRemaining());
    //        if ((int)getMe().getTurnRemaining() == 0) {
    //            if ((getMe().getMyTarget() != null)
    //                && (getMe().getMyTarget().isAlive())) {
    //
    //                Point2D.Double myTargetPos=
    //                    new Point2D.Double(
    //                        getMe().getMyTarget().getX(),
    //                        getMe().getMyTarget().getY());
    //                double toEnemy= this.getAngleTo(myTargetPos);
    //
    //                double bear=
    //                    RoboMath.normalRelativeAngle(
    //                        Math.toDegrees(getMe().getMyTarget().getBearing()));
    //                double var= gigle / 2; // div 2
    //                // double rnd= 0;
    //                double absBear= Math.abs(RoboMath.normalRelativeAngle(bear));
    //                //(Math.random() * var) - (var / 2);
    //                //perpendicular
    //                if ((absBear) > 90) {
    //                    var *= -1;
    //                }
    //
    //                double perpendicular= toEnemy + (90 + var);
    //
    //                //                if (isRe()) {
    //                //                    perpendicular= toEnemy + (90 + var);
    //                //                } else {
    //                //                    perpendicular= toEnemy - (90 + var);
    //                //                }
    //                //                out.println(
    //                //                    "   GIGLE:"
    //                //                        + absBear
    //                //                        + " perp:"
    //                //                        + perpendicular
    //                //                        + " toEnemy"
    //                //                        + toEnemy);
    //                double turnRight= turnBotTo(perpendicular);
    //                //                out.println("   GIGLE: turnRight:" + turnRight);
    //                getMe().setTurnRight(turnRight);
    //            }
    //        }
    //    }

    public boolean fire() {
        return true;
    }

    protected double turnBotTo(double to) {
        double ret;
        to= RoboMath.normalAbsoluteAngle(to);
        //if(!re)
        ret=
            RoboMath.normalRelativeAngle(
                to - RoboMath.normalAbsoluteAngle(getMe().getHeading()));
        //else
        //	ret= (normalRelativeAngle(to - normalAbsoluteAngle(normalAbsoluteAngle(getHeading())-180)));
        //out.println("turnBotTo:"+to+" => "+ret);
        return ret;
    } /** retorna o angulo necessario para ser aplicado
                         																																																																																										 * na funccao setTurnRigth() levando em consideraccao 
                         																																																																																										 * o heading real (considerando re') em funccao do eixo, 
                         																																																																																									 * -180 - 180.
                         																																																																																										 * 
                         																																																																																										 */
    protected double realTurnBotTo(double to) {
        double ret;
        to= RoboMath.normalAbsoluteAngle(to);
        //if(!re)
        ret=
            RoboMath.normalRelativeAngle(
                to - RoboMath.normalAbsoluteAngle(getMe().getMoveHeading()));
        //else
        //	ret= (normalRelativeAngle(to - normalAbsoluteAngle(normalAbsoluteAngle(getHeading())-180)));
        //out.println("turnBotTo:"+to+" => "+ret);
        return ret;
    }

    protected Point2D.Double getCornerCenter(double w, double h) {

        double d= 0; //this.getHeight();
        double maxY= this.getMe().getBattleFieldHeight(); // - d;
        double maxX= this.getMe().getBattleFieldWidth(); // - d;
        //double s= this.getHeight() * 4;

        Rectangle2D.Double uplft= new Rectangle2D.Double(d, maxY - h, w, h);
        Rectangle2D.Double uprit=
            new Rectangle2D.Double(maxX - w, maxY - h, w, h);
        Rectangle2D.Double dolft= new Rectangle2D.Double(d, d, w, h);
        Rectangle2D.Double dorit= new Rectangle2D.Double(maxX - w, d, w, h);

        Point2D.Double me= this.getMe().pos();

        //		getMe().out.println("my pos:"+me+" h:"+h+" w:"+w);
        //			getMe().out.println("uplft:"+uplft.getMinX()+", "+ uplft.getMinY()+", "+ uplft.getMaxX()+", "+ uplft.getMaxY());
        //		getMe().out.println("uprit:"+uprit.getMinX()+", "+ uprit.getMinY()+", "+ uprit.getMaxX()+", "+ uprit.getMaxY());
        //		getMe().out.println("dolft:"+dolft.getMinX()+", "+ dolft.getMinY()+", "+ dolft.getMaxX()+", "+ dolft.getMaxY());
        //		getMe().out.println("dorit:"+dorit.getMinX()+", "+ dorit.getMinY()+", "+ dorit.getMaxX()+", "+ dorit.getMaxY());

        if (uplft.contains(me)) {
            return new Point2D.Double(uplft.getMaxX(), uplft.getMinY());
        }

        if (uprit.contains(me)) {
            return new Point2D.Double(uprit.getMinX(), uprit.getMinY());
        }

        if (dolft.contains(me)) {
            return new Point2D.Double(dolft.getMaxX(), dolft.getMaxY());
        }

        if (dorit.contains(me)) {
            return new Point2D.Double(dorit.getMinX(), dorit.getMaxY());
        }

        return null;

    }
    /**
     * @return
     */
    public double getMaxVelocity() {
        return maxVelocity;
    }

    /**
     * @param d
     */
    public void setMaxVelocity(double d) {
        maxVelocity= d;
        me.setMaxVelocity(d);
    }

    /**
     * 
     */
    public void enemyFired() {


    }

    /**
     * @param string
     */
    public void load(String string) {

    }

    /**
     * @param string
     */
    public void save(String string) {

    }

    /**
     * @return
     */
    public boolean isWallsFear() {
        return wallsFear;
    }

    /**
     * @param b
     */
    public void setWallsFear(boolean b) {
        wallsFear= b;
    }

    /**
     * @return
     */
    public int getAwayAmt() {
        return awayAmt;
    }

    /**
     * @return
     */
    public int getCloserAmt() {
        return closerAmt;
    }

    /**
     * @return
     */
    public int getHoldOffAmt() {
        return holdOffAmt;
    }

    /**
     * @return
     */
    public int getRunAwayAmt() {
        return runAwayAmt;
    }

    /**
     * @param i
     */
    public void setAwayAmt(int i) {
        awayAmt= i;
    }

    /**
     * @param i
     */
    public void setCloserAmt(int i) {
        closerAmt= i;
    }

    /**
     * @param i
     */
    public void setHoldOffAmt(int i) {
        holdOffAmt= i;
    }

    /**
     * @param i
     */
    public void setRunAwayAmt(int i) {
        runAwayAmt= i;
    }

    /**
     * @return
     */
    public boolean isUseSynchro() {
        return useSynchro;
    }

    /**
     * @param b
     */
    public void setUseSynchro(boolean b) {
        useSynchro= b;
    }

    

}
