/*
 * Created on 14/12/2003
 * 
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.util;
import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import robocode.*;
import axeBots.AxeBot;
/**
 * @author Marcos
 * 
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AxeFiles {
	public static final String FLAT_FILE_EXTENSION = ".flat";
	public static final String GFS_FILE_EXTENSION = ".gfs";
	public static final String STAT_FILE_EXTENSION = ".zx";
	public static final String STAT_FILE_PREFIX = "stat_";
	public static final long QUOTA_LIMIT = 3000;
	/**
	 *  
	 */
	public AxeFiles() {
		super();
	}
	private static AxeBot getFather() {
		return AxeBot.getIt();
	}
	private static ArrayList filesFilter(ArrayList lista) {
		ArrayList novo = new ArrayList();
		for (int i = 0; i < lista.size(); i++) {
			File f = (File) (lista.get(i));
			//            System.out.println(f.getName()+":"+f.getName().endsWith(GFS_FILE_EXTENSION));
			if (f.isFile() && (!f.getName().endsWith(FLAT_FILE_EXTENSION))
					&& (!f.getName().endsWith(GFS_FILE_EXTENSION))) {
				//					System.out.println("add
				// "+f.getName()+":"+f.getName().endsWith(GFS_FILE_EXTENSION));
				novo.add(f);
			}
		}
		return novo;
	}
	private static long cleanOld(File dir, ArrayList lista, long quota) {
		getFather().out.println(dir.getName() + ":" + dir.length());
		//long quota= getFather().getDataQuotaAvailable();
		Collections.sort(lista, new Comparator() {
			public int compare(Object a, Object b) {
				File aFile = (File) a;
				File bFile = (File) b;
				double aTot = aFile.lastModified();
				double bTot = bFile.lastModified();
				double diff = bTot - aTot;
				if (diff > 0)
					return +1;
				if (diff < 0)
					return -1;
				return 0;
			}
		});
		GregorianCalendar pt = new GregorianCalendar();
		GregorianCalendar ut = new GregorianCalendar();
		File primeiro = ((File) lista.get(0));
		File ultimo = ((File) lista.get(lista.size() - 1));
		getFather().out.println("cleanOld primeiro:" + primeiro.getName());
		getFather().out.println("cleanOld ultimo:" + ultimo.getName());
		
		ut.setTime(new Date(ultimo.lastModified()));
		pt.setTime(new Date(primeiro.lastModified()));
		pt.add(Calendar.DATE, -30);
		//		while ((quota < QUOTA_LIMIT)
		while ((quota < QUOTA_LIMIT) && (lista.size() > 1) && (ut.before(pt))) {
			try {
				//quota= this.getDataQuotaAvailable();
				getFather().out.println("cleanOld apagando arquivo:"
						+ ultimo.getName() + " quota:" + quota);
				double len = ultimo.length();
				if (!ultimo.delete()) {
					getFather().out.println("cleanOld nao apagou arquivo:"
							+ ultimo.getName());
				} else {
					quota += len;
				}
				lista.remove(lista.size() - 1);
			} catch (SecurityException e) {
				getFather().out.println("cleanOld SecurityException ao apagar:"
						+ ultimo.getName());
			}
			ultimo = ((File) lista.get(lista.size() - 1));
			ut.setTime(new Date(ultimo.lastModified()));
		}
		return quota;
	}
	private static long cleanRates(File dir, ArrayList lista, long quota) {
		getFather().out.println(dir.getName() + ":" + dir.length());
		//long quota= getFather().getDataQuotaAvailable();
		Collections.sort(lista, new Comparator() {
			public int compare(Object a, Object b) {
				File aFile = (File) a;
				File bFile = (File) b;
				String aNam = aFile.getName();
				String bNam = bFile.getName();
				return aNam.compareTo(bNam);
			}
		});
		File ultimo = ((File) lista.get(lista.size() - 1));
		//			while ((quota < QUOTA_LIMIT)
		while ((quota < QUOTA_LIMIT) && (lista.size() > 0)) {
			try {
				//quota= this.getDataQuotaAvailable();
				getFather().out.println("cleanRates apagando arquivo:"
						+ ultimo.getName() + " quota:" + quota);
				double len = ultimo.length();
				if (!ultimo.delete()) {
					getFather().out.println("cleanRates nao apagou arquivo:"
							+ ultimo.getName());
				} else {
					quota += len;
				}
				lista.remove(lista.size() - 1);
			} catch (SecurityException e) {
				getFather().out
						.println("cleanRates SecurityException ao apagar:"
								+ ultimo.getName());
			}
			ultimo = ((File) lista.get(lista.size() - 1));
		}
		return quota;
	}
	
	
	
	public static void cleanDir() {
		long quota = getFather().getDataQuotaAvailable();
		File dir = getFather().getDataDirectory();
		long used = dir.length();
		getFather().out.println("quota:" + quota + " used:" + used);
		if (quota > QUOTA_LIMIT) {
			return;
		}
		File[] dirList = dir.listFiles();
		ArrayList lista = new ArrayList(Arrays.asList(dirList));
		lista = filesFilter(lista);
		for (int i = 0; i < lista.size(); i++) {
			getFather().out.println(">" + ((File) lista.get(i)).getName());
		}
		quota = cleanOld(dir, lista, quota);
		if (quota > QUOTA_LIMIT) {
			return;
		}
		cleanRates(dir, lista, quota);
	}
	public static File findBotsFile(String name) {
		name = STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;
		File ret = null;
		File dir = AxeBot.getIt().getDataDirectory();
		String[] lst = dir.list();
		for (int i = 0; i < lst.length; i++) {
			if (lst[i].endsWith(name)) {
				ret = getFather().getDataFile(lst[i]);
				break;
			}
		}
		return ret;
	}
	public static File findFile(String name) {
		File ret = null;
		//File tmp = AxeBot.getIt().getDataFile(name);
		File dir = AxeBot.getIt().getDataDirectory();
		//			  long used= dir.length();
		File[] dirList = dir.listFiles();
		for (int i = 0; i < dirList.length; i++) {
			if (dirList[i].isFile()) {
				String fname = dirList[i].getName();
				//log.println("findBotsFile trying:"+fname+" ends?:
				// "+STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION);
				if (fname.equals(name)) {
					ret = dirList[i];
					//	log.println("findBotsFile found:"+ret.getName());
					break;
				}
			}
		}
		return ret;
	}
	public static File cleanBotsFiles(String name) {
		File ret = null;
		//File tmp = AxeBot.getIt().getDataFile(name);
		File dir = AxeBot.getIt().getDataDirectory();
		//				  long used= dir.length();
		int tail = name.indexOf(" ");
		//        System.out.println("name:" + name);
		name = (tail > -1) ? name.substring(0, name.indexOf(" ")) : name;
		//        System.out.println("name:" + name);
		File[] dirList = dir.listFiles();
		for (int i = 0; i < dirList.length; i++) {
			if (dirList[i].isFile()) {
				String fname = dirList[i].getName();
				tail = fname.indexOf(" ");
				int head = fname.indexOf("_stat_");
				//                System.out.println("fname:" + fname);
				fname = ((tail > -1) && (tail > head))
						? (head > -1) ? fname.substring(head + 6, tail) : fname
								.substring(0, tail)
						: fname;
				//                System.out.println("fname:" + fname);
				//log.println("findBotsFile trying:"+fname+" ends?:
				// "+STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION);
				if (fname.equals(name)) {
					dirList[i].delete();
					//					System.out.println("deleted:"+ret.getName());
					break;
				}
			}
		}
		return ret;
	}
	public static DataOutputStream getDataOutputStream(String dataFileName)
			throws IOException {
		return new DataOutputStream(new RobocodeFileOutputStream(getFather()
				.getDataFile(dataFileName)));
	}
	public static GZIPInputStream getGZipInputStream(String dataFileName)
			throws IOException {
		return new GZIPInputStream(new FileInputStream(getFather().getDataFile(
				dataFileName)));
	}
	public static GZIPOutputStream getGZipOutputStream(String dataFileName)
			throws IOException {
		return new GZIPOutputStream(new RobocodeFileOutputStream(getFather()
				.getDataFile(dataFileName)));
	}
	public static PrintStream getPrintStream(String dataFileName)
			throws IOException {
		return new PrintStream(new RobocodeFileOutputStream(getFather()
				.getDataFile(dataFileName)));
	}
	public static ZipOutputStream getZipOutputStream(String dataFileName)
			throws IOException {
		return new ZipOutputStream(new RobocodeFileOutputStream(getFather()
				.getDataFile(dataFileName)));
	}
}