package cw.megas;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import java.util.ArrayList;
import robocode.*;
import robocode.util.*;
 
public class GhostShell extends AdvancedRobot {
	
	//arraylist for movement waves
	ArrayList<MovementWave> moveWaves=new ArrayList<MovementWave>();
	double enemyEnergy = 100;
	MovementWave surfWave = null;
	
	//movement variables
	int moveDirection = 1;
	static Point2D.Double nextDestination;
	static Point2D.Double lastPosition;
	static Point2D.Double myPos;
	static Point2D.Double precisePredictionDestionation;
	Rectangle2D.Double myPosRect;
	Point2D.Double dodgePredictBullet1Location;
	Point2D.Double dodgePredictBullet2Location;
	
	Point2D.Double maxEscapeAngle1;
	Point2D.Double maxExcapeAngle2;
	
	static double learningAngle[] = new double[12]; //arraylist for learning angles
	double counter = 0;
	
	
	//gun variables
	final static boolean PAINT_GUN=true;
 	
	static double hotBulletHitCount = 1;
	static double latBulletHitCount = 0;
	static double patternBulletHitCount = 0;
	
	double[] gunNum = {hotBulletHitCount,latBulletHitCount,patternBulletHitCount};
	double gunTurnAngle;
	String selectingBestGun;
	static double bestGun;
	static double bulletPower = 2;
	
	//power gun variables
	static StringBuffer enemyLog = new StringBuffer("000000000000000000000000000000"); //The list where enemy lateral velocites are stored
	
	//pattern gun variables
	static final double bPow = 2.2; // Bullet Power - change it to whatever you like.
	static final double bVel = 20-3*bPow;
	static final int patDep = 30;
	static String eLog = "00000000000000000000000000888888";
	static double absB;
 
    //Constants
    static final double BULLETVEL = 20-3*bulletPower; //The velocity of the bullet fired at FIREPOWER
    static final int PATTERN_DEPTH = 30; //The lenght of the pattern we try to find each turn in enemyLog

 
	ArrayList<GunWave> gunWaves=new ArrayList<GunWave>();
 
	/*
	 * This Array will hold the most recent movement angle for every lateral velocity segment;
	 */
	static double gunAngles[]=new double[16];
	public void run(){
		enemyEnergy=100;
 
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		setBodyColor(new Color(0,20,100));
		setGunColor(Color.darkGray);
		setRadarColor(Color.black);
		setScanColor(Color.white);
		
		nextDestination = lastPosition = myPos = new Point2D.Double(getX(), getY());
		
		execute();
 
		//This is the best possible radar lock
		while(true){
			myPos = new Point2D.Double(getX(),getY());
			if(getRadarTurnRemainingRadians()==0){
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			}
			//This method paints the waves.
			
			execute();
		}
	}
	/*
	 * In this robot, as in many others, onScannedRobot is used as the main place to put actions done every tick.
	 */
	public void onScannedRobot(ScannedRobotEvent e){
		//gunRadar(e);
		patternGun(e);
		//powerGunRadar(e);
		movement(e);
		//maxExcape(e);
	}
	
	public void patternGun(ScannedRobotEvent e) {
		int i;
		
		absB = e.getBearingRadians();
		
		int mLen = patDep;
		int indX;
		eLog = String.valueOf( (char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB+=getHeadingRadians() )))).concat(eLog);
		while((indX = eLog.indexOf(eLog.substring(0, mLen--), (i = (int)((e.getDistance())/bVel)))) < 0);
		while (--i > 0) {
			absB += Math.asin(((byte)eLog.charAt(indX--))/e.getDistance());
		}
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
		setFire(bulletPower);
	}
	
	public void powerGunRadar(ScannedRobotEvent e) {
 
 	 	double absB; //absolute bearing
           int index; //index of the match of the pm gun
           int matchLenght = PATTERN_DEPTH; //the number of data a pattern contains
           /*The pattern matcher gun
            *
            *It's a bit codesize-optimized version of Assertive's gun which is descend from FunkyChicken
            *I comment the gun in detail in order to make new robocoders more understandable. I'd have been
            *very glad if there had been such comments when I was learning symbolic pm. ;)
           */

           //Adding a new entry in the beginning of our pattern-list
           enemyLog.insert(0, (char)((int)(Math.sin(e.getHeadingRadians() - (absB=e.getBearingRadians()+getHeadingRadians()))*e.getVelocity())));

           //Reducing pattern lenght until there is a match in the list. The pattern is the first 'matchlenght' entries in the list.
           while ((index = enemyLog.toString().indexOf(enemyLog.substring(0, matchLenght--), 1)) < 0);

            //Now matchLenght will be the index of the pattern we estimate the enemy will do in the next turns.
            //The lenght of the etimated pattern equals the time our bullet reaching the enemy.
            matchLenght = index - (int)(e.getDistance()/BULLETVEL);
 
 
            //Converting lateral velocities of the estimated pattern to angular velocities, then adding them to absolute bearing
            do{
                absB += Math.asin(((byte)enemyLog.codePointAt(index--))/e.getDistance());
            }while(index >= Math.max(0, matchLenght));
 
            //Turning gun
            setTurnGunRightRadians(Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
 
            //Fire in the hall!
            setFire(bulletPower);
}
	
	public void movement(ScannedRobotEvent e) {
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		if (moveWaves.size() == 0) {
			setMaxVelocity(Math.random() * 5 + 2);
			setAhead(100 * moveDirection);
			double goalDirection = e.getBearing() - 90 - (moveDirection * 10);
			setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
		}
		setTurnRadarRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()) * 1.9);
		double energyChange=enemyEnergy - e.getEnergy();
		if( energyChange > 0 && energyChange <= 3) {
			logMovementWave(e,energyChange);
		}
		enemyEnergy = e.getEnergy();
		paintMovement();
		doMovement(e);
		chooseLocation(e,myPos);
	}
	
	public void gunRadar(ScannedRobotEvent e) {
		paintGun(e);
		double absBearing=e.getBearingRadians()+getHeadingRadians();
		/*
		 * logs a gun wave when we fire;
		 */
		if(getGunHeat()==0){
			logFiringWave(e);
			fire(2);
		}
		/*
		 * This method checks our waves to see if they have reached the enemy yet.
		 */
		checkFiringWaves(project(new Point2D.Double(getX(),getY()),e.getDistance(),absBearing));
 	
		chooseGun(e);
 		
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing-getRadarHeadingRadians()));
	}
	
	public void logMovementWave(ScannedRobotEvent e,double energyChange){
		double absBearing=e.getBearingRadians()+getHeadingRadians();
		MovementWave w=new MovementWave();
		//This is the spot that the enemy was in when they fired.
		w.origin=project(new Point2D.Double(getX(),getY()),e.getDistance(),absBearing);
		//20-3*bulletPower is the formula to find a bullet's speed.
		w.speed=20-3*energyChange;
		w.distanceTraveled = w.speed;
		//The time at which the bullet was fired.
		w.startTime=getTime();
		//The absolute bearing from the enemy to us can be found by adding Pi to our absolute bearing.
		w.angle=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI);
		/*
		 * Our lateral velocity, used to calculate where a bullet fired with linear targeting would be.
		 * Note that the speed has already been factored into the calculation.
		 */
		w.latVel=(getVelocity()*Math.sin(getHeadingRadians()-w.angle))/w.speed;
		
		w.hotPredictPoint = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle);
		w.latPredictPoint1 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle + w.latVel);
		w.latPredictPoint2 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle - w.latVel);
		
		w.learnBullet1PredictPoint1 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle + learningAngle[1]); 
		w.learnBullet1PredictPoint2 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle - learningAngle[1]); 
				
		w.learnBullet2PredictPoint1 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle + learningAngle[2]); 
		w.learnBullet2PredictPoint2 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle - learningAngle[2]); 
		
		
		w.learnBullet3PredictPoint1 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle + learningAngle[3]); 
		w.learnBullet3PredictPoint2 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle - learningAngle[3]); 
						
		w.maxExcapeAngle1 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle + 8 * Math.sin(getHeadingRadians()-w.angle)/w.speed);
		w.maxExcapeAngle2 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle - 8 * Math.sin(getHeadingRadians()-w.angle)/w.speed);
		
		w.myLocation = new Point2D.Double(getX(),getY());
		w.enemyLocation = new Point2D.Double(retrieveX(e),retrieveY(e));
		//This actually adds the wave to the list.
		moveWaves.add(w);
	}
	
	public double distanceFromTwoPoints(double x1, double y1, double x2, double y2) {
		return(Math.sqrt(((x1-x2) * (x1-x2)) + ((y1-y2) * (y1-y2))));
	}
	public Point2D.Double midPointFromTwoPoints(double x1, double y1, double x2, double y2) {
		Point2D.Double midPoint = new Point2D.Double((x1+x2)/2, (y1+y2)/2);
		return(midPoint);
	}

	public MovementWave getClosestSurfableWave() {
        double closestDistance = 50000; // I juse use some very big number here
       // MovementWave surfWave = null;
 
       for(int i=0;i<moveWaves.size();i++){
			MovementWave w=moveWaves.get(i);
			if(new Point2D.Double(getX(),getY()).distance(w.origin)<(getTime()-w.startTime)*w.speed+w.speed){
				moveWaves.remove(w);
			}
            double distance = myPos.distance(w.myLocation) - w.distanceTraveled;
 
            if (distance > w.speed && distance < closestDistance) {
                surfWave = w;
                closestDistance = distance;
            }
        }
        return surfWave;
    }
	
	public Point2D.Double bulletPredictDistanceDouble(double x, double y, double a, double b,double bulletAngle) {
		double xValue = 0;
		double yValue = distanceFromTwoPoints(x,y,a,b); // length of line
		double rotAngle = bulletAngle;//enter your own value(ratation angle) here later
		double rotateAngle = -(rotAngle);
		
		double hotXValue = xValue * Math.cos(rotateAngle) - Math.sin(rotateAngle) * (yValue);
		double hotYValue = xValue * Math.sin(rotateAngle) + Math.cos(rotateAngle) * (yValue);
		
		return new Point2D.Double(a + hotXValue,b + hotYValue);
	}

	public void doMovement(ScannedRobotEvent e) {
		setAhead(100 * moveDirection);
		Graphics g = getGraphics();
		myPosRect = new Rectangle2D.Double(getX() - 18, getY() - 18,36,36);
		double distanceToNextDestination = myPos.distance(nextDestination);
		for(int x=0;x<moveWaves.size();x++){
			MovementWave w=moveWaves.get(x);
			
			if(new Point2D.Double(getX(),getY()).distance(w.origin)<(getTime()-w.startTime)*w.speed+w.speed) {
				/*
				||
				myPosRect.contains(w.hotPredictPoint) ||
				myPosRect.contains(w.latPredictPoint1) ||
				myPosRect.contains(w.latPredictPoint2) ||
				myPosRect.contains(w.learnBullet1PredictPoint1) ||
				myPosRect.contains(w.learnBullet1PredictPoint2) ||
				myPosRect.contains(w.learnBullet2PredictPoint1) ||
				myPosRect.contains(w.learnBullet2PredictPoint2) ||
				myPosRect.contains(w.learnBullet3PredictPoint1) ||
				myPosRect.contains(w.learnBullet3PredictPoint2)) {
				*/
				
				Rectangle2D.Double battleField = new Rectangle2D.Double(30, 30, getBattleFieldWidth() - 60, getBattleFieldHeight() - 60);
				Point2D.Double testPoint;
				int i=0;
			
				do {
					
					g.setColor(Color.red);
					testPoint = precisePredictionDestionation;
					if(battleField.contains(testPoint)) {
						nextDestination = testPoint;
						g.drawLine((int)myPos.x,(int)myPos.y,(int)nextDestination.x - 18,(int)nextDestination.y - 18);
					
					}
				} while(i++ < 2000);
			
				lastPosition = myPos;
			
			} else {
			
				// just the normal goTo stuff
				double angle = calcAngle(nextDestination, myPos) - getHeadingRadians();
				double direction = 1;
			
				if(Math.cos(angle) < 0) {
					angle += Math.PI;
					direction = -1;
				}
				g.setColor(Color.white);
				g.drawLine((int)myPos.x,(int)myPos.y,(int)nextDestination.x,(int)nextDestination.y);
				g.drawRect((int)nextDestination.x - 18,(int)nextDestination.y - 18,36,36);
				g.setColor(Color.green);
				g.drawRect((int)myPos.x - 18,(int)myPos.y - 18,36,36);
				setAhead(distanceToNextDestination * direction);
				setTurnRightRadians(angle = robocode.util.Utils.normalRelativeAngle(angle));
				setMaxVelocity(Math.abs(angle) > 1 ? 0 : 8d);
			}
		}
	}
	
	public void maxExcape(ScannedRobotEvent e) {
		for(int x=0;x<moveWaves.size();x++){
			MovementWave w=moveWaves.get(x);
			Point2D.Double maxEscapeAngle1 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle + 8 * Math.sin(getHeadingRadians()-w.angle)/w.speed);
			Point2D.Double maxExcapeAngle2 = bulletPredictDistanceDouble(getX(),getY(),retrieveX(e),retrieveY(e),w.angle - 8 * Math.sin(getHeadingRadians()-w.angle)/w.speed);
			Graphics g = getGraphics();
			g.setColor(Color.cyan);
			g.drawLine((int)maxEscapeAngle1.x,(int)maxEscapeAngle1.y,(int)retrieveX(e),(int)retrieveY(e));
			g.drawLine((int)maxExcapeAngle2.x,(int)maxExcapeAngle2.y,(int)retrieveX(e),(int)retrieveY(e));
		}
	}
	public void chooseLocation(ScannedRobotEvent e,Point2D.Double myLocation) {
		Graphics g = getGraphics();
		
		for(int i=0;i<moveWaves.size();i++){
			//MovementWave w=moveWaves.get(i);
			MovementWave w = getClosestSurfableWave();
			
			if(new Point2D.Double(getX(),getY()).distance(w.origin)<(getTime()-w.startTime)*w.speed+w.speed){
				moveWaves.remove(w);
			}
		
			
			g.setColor(Color.white);
			g.fillRect((int)w.maxExcapeAngle1.x,(int)w.maxExcapeAngle1.y,10,10);
			g.fillRect((int)w.maxExcapeAngle2.x,(int)w.maxExcapeAngle2.y,10,10);
			g.setColor(Color.black);
			g.drawLine((int)w.maxExcapeAngle1.x,(int)w.maxExcapeAngle1.y,(int)w.myLocation.x,(int)w.myLocation.y);
			g.drawLine((int)w.maxExcapeAngle2.x,(int)w.maxExcapeAngle2.y,(int)w.myLocation.x,(int)w.myLocation.y);
			
			
			Point2D.Double maxEAngle1 = new Point2D.Double(w.maxExcapeAngle1.x, w.maxExcapeAngle1.y);
			Point2D.Double maxEAngle2 = new Point2D.Double(w.maxExcapeAngle2.x, w.maxExcapeAngle2.y);
			
			Point2D.Double latEAngle1 = new Point2D.Double(w.latPredictPoint1.x,w.latPredictPoint1.y);
			Point2D.Double latEAngle2 = new Point2D.Double(w.latPredictPoint2.x,w.latPredictPoint2.y);
			
			Point2D.Double learn1EAngle1 = new Point2D.Double(w.learnBullet1PredictPoint1.x,w.learnBullet1PredictPoint1.y);
			Point2D.Double learn1EAngle2 = new Point2D.Double(w.learnBullet1PredictPoint2.x,w.learnBullet1PredictPoint2.y);
			
			Point2D.Double learn2EAngle1 = new Point2D.Double(w.learnBullet2PredictPoint1.x,w.learnBullet2PredictPoint1.y);
			Point2D.Double learn2EAngle2 = new Point2D.Double(w.learnBullet2PredictPoint2.x,w.learnBullet2PredictPoint2.y);
			
			Point2D.Double learn3EAngle1 = new Point2D.Double(w.learnBullet3PredictPoint1.x,w.learnBullet3PredictPoint1.y);
			Point2D.Double learn3EAngle2 = new Point2D.Double(w.learnBullet3PredictPoint2.x,w.learnBullet3PredictPoint2.y);
			
			
			double distanceMyPosEAngle1 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,maxEAngle1.x, maxEAngle1.y);
			double distanceMyPosEAngle2 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,maxEAngle2.x, maxEAngle2.y);
			
			
			
			double distanceMyPosEAngleLat1 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.latPredictPoint1.x,w.latPredictPoint1.y);
			double distanceMyPosEAngleLat2 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.latPredictPoint2.x,w.latPredictPoint2.y);
			
			double distanceMyPosEAngleLearn1Bullet1 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.learnBullet1PredictPoint1.x,w.learnBullet1PredictPoint1.y);
			double distanceMyPosEAngleLearn1Bullet2 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.learnBullet1PredictPoint2.x,w.learnBullet1PredictPoint2.y);
			
			double distanceMyPosEAngleLearn2Bullet1 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.learnBullet2PredictPoint1.x,w.learnBullet2PredictPoint1.y);
			double distanceMyPosEAngleLearn2Bullet2 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.learnBullet2PredictPoint2.x,w.learnBullet2PredictPoint2.y);
			
			double distanceMyPosEAngleLearn3Bullet1 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.learnBullet3PredictPoint1.x,w.learnBullet3PredictPoint1.y);
			double distanceMyPosEAngleLearn3Bullet2 = distanceFromTwoPoints(w.myLocation.x,w.myLocation.y,w.learnBullet3PredictPoint2.x,w.learnBullet3PredictPoint2.y);
			
			
			
			if (myPosRect.contains(w.hotPredictPoint) ||
				myPosRect.contains(w.latPredictPoint1) ||
				myPosRect.contains(w.latPredictPoint2) ||
				myPosRect.contains(w.learnBullet1PredictPoint1) ||
				myPosRect.contains(w.learnBullet1PredictPoint2) ||
				myPosRect.contains(w.learnBullet2PredictPoint1) ||
				myPosRect.contains(w.learnBullet2PredictPoint2) ||
				myPosRect.contains(w.learnBullet3PredictPoint1) ||
				myPosRect.contains(w.learnBullet3PredictPoint2)) {
					
				out.println("danger");
				/*
				double goalDirection = e.getBearing() - 90 - (moveDirection * 10);
				setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
				*/
			}
			
			/*
			double minDistance = Math.max(Math.max(distanceMyPosEAngle1,distanceMyPosEAngle2),(Math.max(distanceMyPosEAngleLat1,distanceMyPosEAngleLat2)));
			double minDistance2 = Math.max(Math.max(distanceMyPosEAngleLearn1Bullet1,distanceMyPosEAngleLearn1Bullet1),(Math.max(distanceMyPosEAngleLearn2Bullet1,distanceMyPosEAngleLearn2Bullet1)));
			double minDistance3 = Math.max(distanceMyPosEAngleLearn3Bullet1,distanceMyPosEAngleLearn3Bullet2);
			double minDistance4 = Math.max(minDistance,minDistance2);
			double minDistance5 = Math.max(minDistance3,minDistance4);
			*/
			double[] distances = {distanceMyPosEAngle1,distanceMyPosEAngle2,distanceMyPosEAngleLat1,distanceMyPosEAngleLat2,distanceMyPosEAngleLearn1Bullet1,distanceMyPosEAngleLearn1Bullet2,distanceMyPosEAngleLearn2Bullet1,distanceMyPosEAngleLearn2Bullet2,distanceMyPosEAngleLearn3Bullet1,distanceMyPosEAngleLearn3Bullet2};
			Arrays.sort(distances);
			double minDistance5 = distances[9];
			
			if (minDistance5 == distanceMyPosEAngle1 || minDistance5 == distanceMyPosEAngle2) {
				/*Point2D.Double*/ dodgePredictBullet1Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,latEAngle1.x, latEAngle1.y));
				/*Point2D.Double*/ dodgePredictBullet2Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,latEAngle2.x, latEAngle2.y));
			}
			if (minDistance5 == distanceMyPosEAngleLearn1Bullet1 || minDistance5 == distanceMyPosEAngleLearn1Bullet2) {
				/*Point2D.Double*/ dodgePredictBullet1Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,learn1EAngle1.x, learn1EAngle1.y));
				/*Point2D.Double*/ dodgePredictBullet2Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,learn1EAngle2.x, learn1EAngle2.y));
			}
			if (minDistance5 == distanceMyPosEAngleLearn2Bullet1 || minDistance5 == distanceMyPosEAngleLearn2Bullet2) {
				/*Point2D.Double*/ dodgePredictBullet1Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,learn2EAngle1.x, learn2EAngle1.y));
				/*Point2D.Double*/ dodgePredictBullet2Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,learn2EAngle2.x, learn2EAngle2.y));
			}
			if (minDistance5 == distanceMyPosEAngleLearn3Bullet1 || minDistance5 == distanceMyPosEAngleLearn3Bullet2) {
				/*Point2D.Double*/ dodgePredictBullet1Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,learn3EAngle1.x, learn3EAngle1.y));
				/*Point2D.Double*/ dodgePredictBullet2Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,learn3EAngle2.x, learn3EAngle2.y));
			}
				
			/*			
			Point2D.Double dodgePredictBullet1Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,latEAngle1.x, latEAngle1.y));
			Point2D.Double dodgePredictBullet2Location = (midPointFromTwoPoints(w.myLocation.x,w.myLocation.y,latEAngle2.x, latEAngle2.y));
			*/
			
			
			g.drawOval((int)w.myLocation.x,(int)w.myLocation.y,20,20);
			g.drawOval((int)latEAngle1.x, (int)latEAngle1.y,20,20);
			/*
			g.drawString("distance of max angle 1 = " + minDistance5,(int)dodgePredictBullet1Location.x,(int)dodgePredictBullet1Location.y);
			g.drawString("distance of max angle 2 = " + -minDistance5,(int)dodgePredictBullet2Location.x,(int)dodgePredictBullet2Location.y);
			*/
			
			if (Math.random() > .5) {
				precisePredictionDestionation = new Point2D.Double(dodgePredictBullet1Location.x,dodgePredictBullet1Location.y);
			} else {
				precisePredictionDestionation = new Point2D.Double(dodgePredictBullet2Location.x,dodgePredictBullet2Location.y);
			}
			
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
	//returning gun angle
	counter++;
	for (int i = 0; i < moveWaves.size(); i++) {
		MovementWave w = moveWaves.get(i);
		double enemyFireX = w.enemyLocation.x;
		double enemyFireY = w.enemyLocation.y;
		double myFireX = w.myLocation.x;
		double myFireY = w.myLocation.y;
		double currentX = getX();
		double currentY = getY();
		double vector1X = enemyFireX - myFireX;
		double vector1Y = enemyFireY - myFireY;
		double vector2X = enemyFireX - currentX;
		double vector2Y = enemyFireY - currentY;
		double vector1AngleFromNorth = Math.atan2(vector1Y,vector1X);
		double vector2AngleFromNorth = Math.atan2(vector2Y,vector2X);
		double enemyGunAngle = vector2AngleFromNorth - vector1AngleFromNorth;
		if (counter == 1) {
			if (learningAngle[1] == 0) {
				learningAngle[1] = (enemyGunAngle);
			}
		}

		if (counter == 2) {
			if (learningAngle[1] != 0 && learningAngle[2] == 0 ){
				learningAngle[2] = (enemyGunAngle);
			}
		}

		if (counter == 3) {
			if (learningAngle[1] != 0 && learningAngle[2] != 0 && learningAngle[3] == 0) {
				learningAngle[3] = (enemyGunAngle);
			}
		}
		if (counter > 3) {
			counter = 0;
		}
	}
}
	
	public double getWallSmoothedTurn(double t) {
		double wSD = 20; //wall smooth distance
		double turn = t;
	    double predictiveDistance = 200;

		double ourHeading = getHeadingRadians();
		if (moveDirection == -1) {
			ourHeading += Math.PI;
		}
		Rectangle2D.Double bounds = new Rectangle2D.Double(wSD, wSD, getBattleFieldWidth() - 2 * wSD, getBattleFieldHeight() - 2 * wSD);
		
		while (true) {
			double totalTurn = turn + ourHeading;
			double dXTravel = Math.sin(totalTurn) * predictiveDistance;
			double dYTravel = Math.cos(totalTurn) * predictiveDistance;
			double finishX = getX() + dXTravel;
			double finishY = getY() + dYTravel;

			if (bounds.contains(finishX, finishY)) {
				return (turn);
			} else {
				turn += 0.1 * moveDirection;
			}
		}
	}									
	
	public void logFiringWave(ScannedRobotEvent e){
		GunWave w=new GunWave();
		double absBearing=e.getBearingRadians()+getHeadingRadians();
		w.absBearing=e.getBearingRadians()+getHeadingRadians();
		w.speed=20-bulletPower*3;
		w.origin=new Point2D.Double(getX(),getY());
		w.velSeg=(int)(e.getVelocity()*Math.sin(e.getHeadingRadians()-w.absBearing));
		w.startTime=getTime();
		w.angle = Utils.normalRelativeAngle(absBearing+Math.PI);
		w.latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing);
		w.learnAngle = gunAngles[8+(int)(e.getVelocity()*Math.sin(e.getHeadingRadians()-absBearing))];
		gunWaves.add(w);
	}
	public void chooseGun(ScannedRobotEvent e) {
		selectBestGun();
		for(int i=0;i<gunWaves.size();i++){
			GunWave w=gunWaves.get(i);
			double absBearing=e.getBearingRadians()+getHeadingRadians();
			if (bestGun == w.angle) {
				gunTurnAngle = w.angle;
				setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()));
			}
			if (bestGun == w.latVel) {
				gunTurnAngle = w.angle + w.latVel;
				setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians() + Math.asin(w.latVel / (20 - 3 * bulletPower))));
			}
			if (bestGun == w.learnAngle) {
				gunTurnAngle = w.angle + w.learnAngle;
				setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing-getGunHeadingRadians())
				+gunAngles[8+(int)(e.getVelocity()*Math.sin(e.getHeadingRadians()-absBearing))]);
			}
		}
	}
	/*
	 * This method checks firing waves to see if they have passed the enemy yet.
	 */
	public void checkFiringWaves(Point2D.Double ePos){
		GunWave w;
		for(int i=0;i<gunWaves.size();i++){
			w=gunWaves.get(i);
			if((getTime()-w.startTime)*w.speed>=w.origin.distance(ePos)){
				gunAngles[w.velSeg+8]=Utils.normalRelativeAngle(Utils.normalAbsoluteAngle(Math.atan2(ePos.x-w.origin.x, ePos.y-w.origin.y))-w.absBearing);
				gunWaves.remove(w);
			}
		}
	}
	public double retrieveX(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double X = getX() + Math.sin(edir) * e.getDistance();
		return(X);
	}

	public double retrieveY(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double Y = getY() + Math.cos(edir) * e.getDistance();
		return(Y);
	}
				
	/*
	 * This extremely useful method lets us project one point from another given a specific angle and distance.
	 */
	public Point2D.Double project(Point2D.Double origin,double dist,double angle){
		return new Point2D.Double(origin.x+dist*Math.sin(angle),origin.y+dist*Math.cos(angle));
	}
	/*
	 * This is where we will paint our waves;
	 */
	public void selectBestGun() {
		Arrays.sort(gunNum);
	}
	public void paintGun(ScannedRobotEvent e){
		Graphics g=getGraphics();
		double radius;
 		g.setColor(Color.white);
		
		g.drawString("hotBulletHitCount = " + hotBulletHitCount, 20, 20);
		g.drawString("latBulletHitCount = " + latBulletHitCount, 20, 40);
		g.drawString("patternBulletHitCount = " + patternBulletHitCount, 20, 60);
		
		Rectangle2D.Double enemyRect = new Rectangle2D.Double(retrieveX(e) - 18, retrieveY(e) - 18,36,36);
	
		if(PAINT_GUN){
			for(int i=0;i<gunWaves.size();i++){
				GunWave w=gunWaves.get(i);
				g.setColor(Color.blue);
				radius=(getTime()-w.startTime)*w.speed;
				Point2D.Double hotBullet=project(w.origin,-radius,w.angle);
				Point2D.Double latBullet=project(w.origin,-radius,w.angle + Math.asin(w.latVel / (20 - 3 * bulletPower)));
				
				Point2D.Double patternBullet = project(w.origin,-radius,w.angle + gunAngles[8+(int)w.latVel]);
				g.setColor(Color.cyan);
				g.fillOval((int)hotBullet.x-3,(int)hotBullet.y-3,6,6);
				//g.drawOval((int)(w.origin.x-radius),(int)(w.origin.y-radius),(int)radius*2,(int)radius*2);
				g.setColor(Color.yellow);
				g.fillOval((int)latBullet.x-3,(int)latBullet.y-3,6,6);
				
				g.setColor(Color.green);
				g.fillOval((int)patternBullet.x-3,(int)patternBullet.y-3,6,6);
				
				if (enemyRect.contains(hotBullet.x, hotBullet.y)) {

					hotBulletHitCount++;	
					break;
				}
				if (enemyRect.contains(latBullet.x, latBullet.y)) {	

					latBulletHitCount++;
					break;
				}
				if (enemyRect.contains(patternBullet.x, patternBullet.y)) {	

					patternBulletHitCount++;
					break;
				}
		
				double selectBestGun1 = Math.max(patternBulletHitCount,latBulletHitCount);
				double selectBestGun2 = hotBulletHitCount;
				double selectBestGun3 = Math.max(selectBestGun1,selectBestGun2);

				if (selectBestGun3 == hotBulletHitCount) {
					selectingBestGun = "hotBullet gun";
					bestGun = w.angle;
				}
				if (selectBestGun3 == latBulletHitCount) {
					selectingBestGun = "latBullet gun";
					bestGun = w.latVel;
				}
				if (selectBestGun3 == patternBulletHitCount) {
					selectingBestGun = "patternBullet gun";
					bestGun = w.learnAngle;
				}
				
				g.drawString("best gun = " + selectingBestGun,20,80);
			}
		}
	}

	private static double calcAngle(Point2D.Double p2,Point2D.Double p1){
		return Math.atan2(p2.x - p1.x, p2.y - p1.y);
	}
	
	public void paintMovement(){
		Graphics g=getGraphics();
		double radius;
 
		
		for(int i=0;i<moveWaves.size();i++){
			MovementWave w=moveWaves.get(i);
			g.setColor(Color.blue);
			radius=(getTime()-w.startTime)*w.speed+w.speed;
			g.drawOval((int)(w.origin.x-radius),(int)(w.origin.y-radius),(int)radius*2,(int)radius*2);
			Point2D.Double hotBullet=project(w.origin,radius,w.angle);
			Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);
			g.setColor(Color.red);
			g.fillOval((int)hotBullet.x-3,(int)hotBullet.y-3,6,6);
			g.fillOval((int)latBullet.x-3,(int)latBullet.y-3,6,6);
			
			Point2D.Double learnBullet = project(w.origin,radius,w.angle + learningAngle[1]);
			Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
			Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);

			if (learningAngle[1] != 0) {
				g.setColor(Color.black);
				g.fillOval((int)learnBullet.x - 6,(int)learnBullet.y-6,6,6);
			} 
			if (learningAngle[2] != 0) {
				g.setColor(Color.black);
				g.fillOval((int)learnBullet2.x - 6,(int)learnBullet2.y-6,6,6);
			}
			if (learningAngle[3] != 0) {
				g.setColor(Color.black);
				g.fillOval((int)learnBullet3.x - 6,(int)learnBullet3.y-6,6,6);
			}				
			
		}
	}
	
	/*
	 * This class is the data we will need to use for our targeting waves.
	 */
	public class GunWave{
		double speed;
		Point2D.Double origin;
		int velSeg;
		double absBearing;
		double startTime;
		double angle;
		double latVel;
		double learnAngle;
	}

	public static class MovementWave{
		Point2D.Double origin;
		double startTime;
		double speed;
		double distanceTraveled;
		double angle;
		double latVel;
		Point2D.Double hotPredictPoint;
		Point2D.Double latPredictPoint1;
		Point2D.Double latPredictPoint2;
		Point2D.Double learnBullet1PredictPoint1;
		Point2D.Double learnBullet1PredictPoint2;
		Point2D.Double learnBullet2PredictPoint1;
		Point2D.Double learnBullet2PredictPoint2;
		Point2D.Double learnBullet3PredictPoint1;
		Point2D.Double learnBullet3PredictPoint2;
		Point2D.Double maxExcapeAngle1;
		Point2D.Double maxExcapeAngle2;
		Point2D.Double myLocation;
		Point2D.Double enemyLocation;
	}

}			