package ntw;
import robocode.*;
import java.util.*;
import java.text.*;
import java.awt.Color;
import java.awt.geom.Point2D;

/**
 *  My first attempt at creating a robot all by myself.  Targeting at most a
 *  minibot.  The name follows from the Sigterm robot, which was done as a
 *  team-designed robot for a Uni project.  The names of all my bots will be
 *  Unix signals.  For other Unix signals, see
 *  <a href="http://www.cybermagician.co.uk/technet/unixsignals.htm">http://www.cybermagician.co.uk/technet/unixsignals.htm</a>.
 *  @author Nathanael Weldon
 */
public class Sighup extends AdvancedRobot
{
    private Random r;
    private HashMap otherBots;
    private Point2D.Double ourPosition;
    private Point2D.Double lastRobotScanned;
    private Point2D.Double target;
    private double lastScannedVelocity;
    private double lastScannedHeading;
    private double targetVelocity;
    private double targetHeading;
    private double predictedHeading;
    private boolean fired;

    private double wallDistance;
    private int overrideTicks;
    private final int OVERRIDE_TICKS = 20;
    private final int TARGET_TICKS = 5;
    private int targetTicks;

    private double maxDist;

    private Point2D.Double lastSeen;
    private static GuessFactor guessFactors;

    private double gravX;
    private double gravY;

    public Sighup()
    {
        super();
        if ( guessFactors == null )
        {
            guessFactors = new GuessFactor( "" );
        }
    }

    public void run()
    {
        setColors( Color.ORANGE, Color.DARK_GRAY, Color.GRAY );
        r = new Random();
        otherBots = new HashMap();
        ourPosition = new Point2D.Double();
        lastRobotScanned = null;
        target = null;
        targetVelocity = 0.0;
        predictedHeading = 0.0;
        overrideTicks = 0;
        targetTicks = 0;
        fired = true;
        gravX = 0.0;
        gravY = 0.0;

        //wallDistance = 3.0 * getWidth();
        setAdjustGunForRobotTurn( true );
        /*maxDist = Point2D.distance( 0.0, 0.0, getBattleFieldWidth(),
            getBattleFieldHeight() );*/
        while( true )
        {
            ourPosition.setLocation( getX(), getY() );
            move();
            shoot();
            virtualBullets();
            radar();
            execute();
        }
    }

    public void onScannedRobot( ScannedRobotEvent event )
    {
        double heading = getHeadingRadians() + event.getBearingRadians();
        double x = event.getDistance() * Math.sin( heading ) + getX();
        double y = event.getDistance() * Math.cos( heading ) + getY();
        if ( lastRobotScanned == null )
        {
            Point2D.Double pt = new Point2D.Double( x, y );
            lastRobotScanned = pt;
        }
        else
        {
            lastRobotScanned.setLocation( x, y );
        }
        lastScannedVelocity = event.getVelocity();
        lastScannedHeading = event.getHeading();

        double velX = event.getVelocity() * Math.sin(
            event.getHeadingRadians() );
        double velY = event.getVelocity() * Math.cos(
            event.getHeadingRadians() );

        Enemy e = new Enemy( event.getName() );
        e.velX = velX;
        e.velY = velY;
        e.x = x;
        e.y = y;
        e.velocity = event.getVelocity();
        e.heading = event.getHeading();
        e.distance = event.getDistance();

        Enemy prevEnemy = (Enemy)otherBots.remove( e.name );
        otherBots.put( e.name, e );

        if ( prevEnemy != null )
        {
            gravX -= prevEnemy.velX;
            gravY -= prevEnemy.velY;
        }
        gravX += velX;
        gravY += velY;
    }

    public void onRobotDeath( RobotDeathEvent event )
    {
        //target = null;
    }

    private void move()
    {
        if ( overrideTicks <= 0 )
        {
            double hdg = correctedATan( gravX, gravY + 0.001 );
            double mag = Math.sqrt( gravX * gravX + gravY * gravY );
            double bearing = correctAngle( hdg - getHeading() );
            setAhead( mag * 20.0 );
            setTurnRight( bearing );
            if ( bearing > 180.0 )
            {
                setTurnLeft( 360 - bearing );
            }
        }
        else
        {
            overrideTicks--;
        }
    }

    private void shoot()
    {
        double hdg;
        if ( targetTicks == 0 )
        {
            lastSeen = lastRobotScanned;
            if ( lastRobotScanned != null )
            {
                target = lastRobotScanned;
                targetTicks = TARGET_TICKS;
                targetVelocity = lastScannedVelocity;
                targetHeading = lastScannedHeading;
            }
        }
        else
        {
            lastSeen = target;
            targetTicks--;
        }

        if ( lastSeen != null )
        {
            double dist = lastSeen.distance( ourPosition );
            double firePower = getFirePower( dist );
            double factor = 2.0 * ( r.nextDouble() - 0.5 );
                //guessFactors.getBestGuess();

            if ( fired )
            {
                Point2D.Double prd = getFiringPoint( factor,
                    firePower );
                predictedHeading = heading( ourPosition, prd );
                //System.out.println( predicted );
                //System.out.println( predictedHeading );
                fired = false;
            }

            double diff = predictedHeading - getGunHeading();
            diff = correctAngle( diff );
            if ( diff > 180.0 )
            {
                setTurnGunLeft( 360.0 - diff );
            }
            else
            {
                setTurnGunRight( diff );
            }

            if ( Math.abs( predictedHeading - getGunHeading() ) < 1.0 )
            {
                fired = true;
                boolean energySafe = getEnergy() >= 3.0;
                if ( energySafe || dist < 50.0 )
                {
                    if ( Math.abs( getGunHeat() - 0.0 ) < 0.1 )
                    {
                        setFire( firePower );
                    }
                }
            }
            else
            {
                fired = false;
            }
        }
    }

    private void radar()
    {
        setTurnRadarRight( 360.0 );
    }

    private double heading( Point2D.Double a, Point2D.Double b )
    {
        double yDiff = ( b.getY() - a.getY() ) + 0.01;
        double xDiff = b.getX() - a.getX();

        double hdg = correctedATan( xDiff, yDiff );

        return hdg;
    }

    private double correctedATan( double a, double b )
    {
        double hdg = Math.toDegrees( Math.atan( a / b ) );

        if ( b < 0.0 )
        {
            hdg += 180.0;
        }
        else if ( a < 0.0 )
        {
            hdg += 360.0;
        }
        hdg = correctAngle( hdg );
        return hdg;
    }

    private double correctAngle( double angle )
    {
        if ( angle < 0.0 )
        {
            angle += 360.0;
        }
        return angle;
    }

    public void onHitWall( HitWallEvent event )
    {
        if ( event.getBearing() + 90.0 < 180.0 )
        {
            setBack( 100.0 );
            setTurnLeft( 45.0 );
            if ( event.getBearing() < 0.0 )
            {
                setTurnRight( 45.0 );
            }
            overrideTicks = OVERRIDE_TICKS;
        }
    }

    private Point2D.Double getFiringPoint( double factor, double firePower )
    {
        double dist = lastSeen.distance( ourPosition );
        double velX = targetVelocity * Math.sin( Math.toRadians(
                    targetHeading ) );
        double velY = targetVelocity * Math.cos( Math.toRadians(
                    targetHeading ) );
        double bulletSpeed = 20.0 - 3.0 * firePower;
        double bulletTime = dist / bulletSpeed;
        double newX = lastSeen.getX() + factor * bulletTime * velX;
        double newY = lastSeen.getY() + factor * bulletTime * velY;
        Point2D.Double predicted = new Point2D.Double( newX, newY );
        return predicted;
    }

    private double getFirePower( double dist )
    {
        double firePower = 0.1;
        if ( targetVelocity < 0.1 || dist < 250 )
        {
            firePower = 3.0;
        }
        else if ( dist < 400.0 )
        {
            firePower = 2.0;
        }
        else if ( dist < 600.0 )
        {
            firePower = 1.0;
        }
        else if ( dist < 800.0 )
        {
            firePower = 0.5;
        }
        return firePower;
    }

    private LinkedList predictions;

    private void virtualBullets()
    {
        /*if ( predictions == null )
        {
            predictions = new LinkedList();
        }

        if ( guessFactors == null )
        {
            guessFactors = new GuessFactor( "" );
        }

        if ( lastRobotScanned != null && lastSeen != null )
        {
            double time = getTime();
            double lastX = lastRobotScanned.getX();
            double lastY = lastRobotScanned.getY();
            ListIterator iter = predictions.listIterator();
            while ( iter.hasNext() )
            {
                GuessFactorBullet b = (GuessFactorBullet)iter.next();
                if ( b.impactTime > time - 2.0 )
                {
                    if ( b.impactTime < time + 2.0 )
                    {
                        if ( Math.abs( lastX - b.impactX ) < 10.0
                                && Math.abs( lastY - b.impactY ) < 10.0 )
                        {
                            guessFactors.hitFactor( b.factor );
                            //System.out.println( "Hit factor " + b.factor
                            //    + " new best guess is " +
                            //    guessFactors.getBestGuess() );
                        }
                        iter.remove();
                    }
                }
                else
                {
                    iter.remove();
                }
            }

            double guessFactor = -1.0;
            for ( int i = 0; i < GuessFactor.GUESS_FACTORS + 1; i++ )
            {
                double dist = lastSeen.distance( ourPosition );
                double firePower = getFirePower( dist );
                Point2D.Double pt = getFiringPoint( guessFactor, firePower );
                GuessFactorBullet b = new GuessFactorBullet( guessFactor,
                    pt.getX(), pt.getY(), dist / ( 20.0 - 3.0 * firePower ) );
                predictions.addLast( b );
                //System.out.println( guessFactor + " " + pt );
                guessFactor += GuessFactor.FACTOR_INCREMENT;
            }
        }*/
    }
}
