package robar.micro;

import robocode.*;
import robocode.util.Utils;

import java.awt.Color;
import java.awt.geom.*;

/**
 * Gladius - The big brother of Pugio
 * 
 * This bot is built upon my new innovative movement called Adaptive Oscillator Movement. It's a simple sin-based energy-drop dependent oscillator movement which
 * adjusts its own frequency. In this micro I develop a new version of this movement called Statistical AOM. It means that the movement makes statistics
 * about the frequencies to select the best one better.
 * 
 * 0.2 - First release, first version of sAOM  with sucky nano PM on velocity. 535 bytes, 10 June 2009
 * 
 * 0.25 - Several optimizations on the movement and the firepower-management. 540 bytes, 11 June 2009
 * 
 * 0.3 - Fixed a critical bug in distancing, improved energy-drop perception. 555 bytes, 12 June 2009
 * 
 * 1.01 - Finally, Gladius with GF-gun. :) Now it's pure GFTargetingBot's code with drastical codesize-reductions. :D 746 bytes, 18 June 2009
 * 
 * 1.1 - Replaced buggy gun with a slightly modified and heavily codesize-cured version of Aristocles's gun. Now it should be much more competitive. 748 bytes, 19 June 2009
 *
 * 1.15 - Added a little randomization to the moving angles, plus switched over 2.5 firepower. 744 bytes 22 June 2009
 */


public class Gladius extends AdvancedRobot {

	
	private static final double PREFDIST = 250;
	private static final double ADJUSTANGLE = 0.17;
	
	
	static final double FIREPOWER = 2.5;
	//static double firePower;
	
	static double[] freqStats = {200,199,198,197,196,195,194};
	static int currentFreqIndex = 0;
	static double prevEnergy;
	
	//static double firePower;
	static int timeSinceLastHit;

	static final double BATTLE_FIELD_WIDTH = 800;
    static final double BATTLE_FIELD_HEIGHT = 600;

    static final double MAX_DISTANCE = 900;
    static final double WALL_MARGIN = 18;
    static final double MAX_ESCAPE_ANGLE = 0.7;
    

    static final int DISTANCE_INDEXES = 5;
    static final int VELOCITY_INDEXES = 5;
    static final int LAST_VELOCITY_INDEXES = 5;
    static final int WALL_INDEXES = 2;
    static final int DECCEL_TIME_INDEXES = 6;
    static final int AIM_FACTORS = 25;
    static final int MIDDLE_FACTOR = (AIM_FACTORS - 1) / 2;

    static Point2D.Double enemyLocation;
    static double enemyVelocity;
    static int timeSinceDeccel;
    static double bearingDirection;
    static double adjustAngle;
    //static int[][][][][][] aimFactors = new int[DISTANCE_INDEXES][VELOCITY_INDEXES][LAST_VELOCITY_INDEXES][DECCEL_TIME_INDEXES][WALL_INDEXES][AIM_FACTORS];
    static int[][][][][] aimFactors = new int[DISTANCE_INDEXES][VELOCITY_INDEXES][LAST_VELOCITY_INDEXES][DECCEL_TIME_INDEXES][AIM_FACTORS];
	
	public void run(){
		
		//setColors(Color.black, Color.orange, Color.gray);
		setAdjustGunForRobotTurn(true);
		//setAdjustRadarForGunTurn(true);
		
		
		
		//while(true)turnRadarRight(36);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e){
		
		Wave wave = new Wave(); // 11 bytes gain if I put this here!!!
		double absB = getHeadingRadians() + e.getBearingRadians();			
		double dist;
		
		
		
		
		
        
        
        enemyLocation = new Point2D.Double(getX() + Math.sin(absB) * (dist = e.getDistance()),
				 			getY() + Math.cos(absB) * dist);
        
        wave.wGunLocation = new Point2D.Double(getX(),getY());
        //Rectangle2D fieldRectangle = new Rectangle2D.Double(WALL_MARGIN, WALL_MARGIN,
        //	    BATTLE_FIELD_WIDTH - WALL_MARGIN * 2, BATTLE_FIELD_HEIGHT - WALL_MARGIN * 2);
        
        
		 // --- Statistical AOM	---
		
        timeSinceLastHit++;
        
		 if(prevEnergy>(prevEnergy = e.getEnergy())){
			 
				setAhead(Math.sin(getTime()/ (5+2*currentFreqIndex))*300);
				setMaxVelocity(10 - (Math.random()*(currentFreqIndex+2)));
				adjustAngle = Math.random()/3 + 0.08;
				
			}
		 setTurnRightRadians(Math.cos(e.getBearingRadians())- Math.signum(getVelocity() * ((dist) - PREFDIST)) * adjustAngle);
	     //setTurnRightRadians(Math.cos(e.getBearingRadians())- Math.signum(getVelocity() * ((dist) - PREFDIST)) * ADJUSTANGLE);

         
         
         
		int lastVelocityIndex = (int)Math.abs(enemyVelocity) / 2;
		int velocityIndex = (int)Math.abs((enemyVelocity = e.getVelocity()) / 2);
		if (velocityIndex < lastVelocityIndex) {
			   timeSinceDeccel = 0;
		}
			
		if (enemyVelocity != 0) {
			    //bearingDirection = enemyVelocity * Math.sin(e.getHeadingRadians() - absB) > 0 ?
				//0.7 / (double)MIDDLE_FACTOR : -0.7 / (double)MIDDLE_FACTOR;
				
			bearingDirection = Math.signum(enemyVelocity * Math.sin(e.getHeadingRadians() - absB) - 0.00001) *
					MAX_ESCAPE_ANGLE / (double)MIDDLE_FACTOR;
		}
		wave.wBearingDirection = bearingDirection;
			
		//int distanceIndex = (int)(dist / (MAX_DISTANCE / DISTANCE_INDEXES));
			
		double firePower = FIREPOWER;
	         
	    if(e.getEnergy()<10)firePower = 1.1;
	    if((dist)<100.0)firePower = 3.0;   
	    
	    wave.wBulletPower = firePower;

	    wave.wAimFactors = aimFactors[(int)(dist / (MAX_DISTANCE / DISTANCE_INDEXES))]
	                                 [velocityIndex]
	                                 [lastVelocityIndex]
	                                 [Math.min(5, timeSinceDeccel++ / 13)];
			    //[fieldRectangle.contains(project(wave.wGunLocation, absB + wave.wBearingDirection * 13, dist)) ? 1 : 0];

		wave.wBearing = absB;

		int mostVisited = MIDDLE_FACTOR, i = AIM_FACTORS;
		do  {
			if (wave.wAimFactors[--i] > wave.wAimFactors[mostVisited]) {
				mostVisited = i;
			   }
		} while (i > 0);

		setTurnGunRightRadians(Utils.normalRelativeAngle(absB - getGunHeadingRadians() +
			   wave.wBearingDirection * (mostVisited - MIDDLE_FACTOR)));

		setFire(firePower);
		
		//if (getEnergy() >= FIREPOWER) {
			    addCustomEvent(wave);
		//}
 		
 		 // --- Firepower - management ---
 		 
 		//firePower = 3.5 - e.getDistance()/(Point2D.distance(0, 0, getBattleFieldWidth(), getBattleFieldHeight())/3.0);
 		 
 		/*firePower = FIREPOWER;
         
         if(e.getEnergy()<10)firePower = 1.1;
         if((dist)<100.0)firePower = 3.0;
         //if(getEnergy()<5)firePower = 0.2;
         
 		 
 		 
 		  		    		

 		//setTurnRadarRightRadians(2 * Utils.normalRelativeAngle((absB)-getRadarHeadingRadians()));
 		
 		
 		double enemyVelocity = e.getVelocity();
 		
		
		
		//Finish declaring a new wave
		
		
		
		
		//setTurnGunRightRadians(Utils.normalRelativeAngle(absB - getGunHeadingRadians() + wave.mostVisitedBearingOffset()));
		
		
		
		 
			
 		  if(!(getEnergy()<5.0 && getEnergy()>e.getEnergy())){
 			  
 			  setFire(firePower);
 		  }*/
 		 
 		
     
     
     //setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle((absB)-getRadarHeadingRadians()));
     setTurnRadarLeft(getRadarTurnRemaining());
    	 
	}
	
	
	
	
	
	
	//Updating frequency stats
	public void onHitByBullet(HitByBulletEvent e){
		
		
		//prevEnergy += e.getPower()*3;
		prevEnergy += Rules.getBulletDamage(e.getPower()); // 1 bytes less!!
		
		
		
		freqStats[currentFreqIndex] = (4*freqStats[currentFreqIndex]+timeSinceLastHit)/5;

		/*System.out.println(currentFreqIndex);
		System.out.println(timeSinceLastHit);
		
		System.out.println("---");*/
		
		timeSinceLastHit = 0;
		int index = 0;
		
		for(double v:freqStats){
			
			
			//System.out.println("index: " + index + " | hitcount: " + v + " current best: " + currentFreqIndex);
			
			//System.out.println("index: " + index + " |value: " + v);
			
			if(v > freqStats[currentFreqIndex]) currentFreqIndex = index;
			
			index++;
			
		}
		//System.out.println("---");
	}
	
	
	//WAVE CLASS
		
	

	    

	    

	    class Wave extends Condition {
	    	
		double wBulletPower;
		Point2D.Double wGunLocation;
		double wBearing;
		double wBearingDirection;
		int[] wAimFactors;
		double wDistance;

		public boolean test() {
			
		    if ((wDistance += Rules.getBulletSpeed(wBulletPower)) > wGunLocation.distance(enemyLocation) - 18) {
		    	
			try {
			    wAimFactors[(int)Math.round(((Utils.normalRelativeAngle(
			    		
			    		//absoluteBearing(wGunLocation, enemyLocation)
			    		Math.atan2(enemyLocation.x - wGunLocation.x, enemyLocation.y - wGunLocation.y)
			    		
			    		- wBearing)) /
					wBearingDirection) + MIDDLE_FACTOR)]++;
			}
			catch (Exception e) {
			}
				removeCustomEvent(this);
		    }
		    return false;
		}
	    }
	}

		
		
		

		
		
	

