package cw.megas;
import robocode.*;
import java.awt.*;

import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.*;
import java.awt.Graphics;
import java.util.ArrayList;

public class Polar extends AdvancedRobot {
	
	//distanceFromVirtualBullet varables
	double the;
	
	//gun variables
	static final double bPow = 2.2; // Bullet Power - change it to whatever you like.
	static final double bVel = 20-3*bPow;
	static final int patDep = 30;
	static String eLog = "00000000000000000000000000888888";
	static double absB;
	
	//choosing direction variables
	static Point2D.Double nextDestination;
	static Point2D.Double lastPosition;
	static Point2D.Double myPos;
	static double myEnergy;
	 
	//grid surfing variables
	ArrayList<Wave> waveArray = new ArrayList<Wave>();
	static double learningAngle[] = new double[12];	//arraylist for learning angles
	double bm;
	double myYIntercept;
	
	//grid surfing enemy gun variables
	double counter = 0;
		
	//energy management
	double previousEnergy = 100;
	//movement variables
	double moveDirection = 1;
	
	public void run() {
		if (getOthers() > 1) {
			stop();
			printString("Gridd unable to adjust to more than 1 enemy");
			printString("Solution:  hybernation");
		} else {
			setBodyColor(new Color(246,250,249));
			setGunColor(Color.white);
			setRadarColor(Color.white);
			setScanColor(Color.white);
		
			setAdjustGunForRobotTurn(true);
			setAdjustRadarForGunTurn(true);
		
			//setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			
			nextDestination = lastPosition = myPos = new Point2D.Double(getX(), getY());
			while(true) {
				turnRadarRightRadians(Math.PI);
				setTurnGunRightRadians(Math.PI);
			}
		}
	}

	//------------------------------------------------------------------------------------------
	//robocode events
	public void onScannedRobot(ScannedRobotEvent e)	{
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()) * 4);
		doMovement(e);
		gun(e);
		myPos = new Point2D.Double(getX(),getY());
		myEnergy = getEnergy();
		moveWaves(e);
		checkIfEnemyFired(e);
	}
	
	public void onHitWall(HitWallEvent e) {
		printString("Warning : hit wall");
	}
	public void onHitByBullet(HitByBulletEvent e) {
		//returning gun angle
		counter++;
		for (int i = 0; i < waveArray.size(); i++) {
			Wave w = waveArray.get(i);
			double enemyFireX = w.enemyX;
			double enemyFireY = w.enemyY;
			double myFireX = w.firePlaceX;
			double myFireY = w.firePlaceY;
			double currentX = getX();
			double currentY = getY();
			double vector1X = enemyFireX - myFireX;
			double vector1Y = enemyFireY - myFireY;
			double vector2X = enemyFireX - currentX;
			double vector2Y = enemyFireY - currentY;
			double vector1AngleFromNorth = Math.atan2(vector1Y,vector1X);
			double vector2AngleFromNorth = Math.atan2(vector2Y,vector2X);
			double enemyGunAngle = vector2AngleFromNorth - vector1AngleFromNorth;
			if (counter == 1) {
				if (learningAngle[1] == 0) {
					learningAngle[1] = (enemyGunAngle);
				}
			}
			if (counter == 2) {
				if (learningAngle[1] != 0 && learningAngle[2] == 0 ){
					learningAngle[2] = (enemyGunAngle);
				}
			}
			if (counter == 3) {
				if (learningAngle[1] != 0 && learningAngle[2] != 0 && learningAngle[3] == 0) {
					learningAngle[3] = (enemyGunAngle);
				}
			}
			if (counter > 3) {
				counter = 0;
			}
		}
	}
	//------------------------------------------------------------------------------------------
	//callable events
	public void gun(ScannedRobotEvent e) {
		int i;
		
		absB = e.getBearingRadians();
		
		int mLen = patDep;
		int indX;
		//setTurnRightRadians((Math.cos(absB = e.getBearingRadians())));
		eLog = String.valueOf( (char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB+=getHeadingRadians() )))).concat(eLog);
		while((indX = eLog.indexOf(eLog.substring(0, mLen--), (i = (int)((e.getDistance())/bVel)))) < 0);
		while (--i > 0) {
			absB += Math.asin(((byte)eLog.charAt(indX--))/e.getDistance());
		}
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
		setFire(bPow);
	}
	public Point2D.Double project(Point2D.Double origin,double dist,double angle){
		return new Point2D.Double(origin.x+dist*Math.sin(angle),origin.y+dist*Math.cos(angle));
	}

	public double retrieveX(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double X = getX() + Math.sin(edir) * e.getDistance();
		return(X);
	}

	public double retrieveY(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double Y = getY() + Math.cos(edir) * e.getDistance();
		return(Y);
	}

	public void predictPosition(double turn) {
		double ourHeading =- getHeadingRadians();
		double totalTurn = turn + ourHeading;
		double predictiveDistance2 = -90;
		double dXTravel2 = Math.sin(totalTurn) * predictiveDistance2;
		double dYTravel2 = Math.cos(totalTurn) * predictiveDistance2;
		double finishX2 = getX() + dXTravel2;
		double finishY2 = getY() + dYTravel2;
		double predictiveDistance = 90;
		double dXTravel = Math.sin(totalTurn) * predictiveDistance;
		double dYTravel = Math.cos(totalTurn) * predictiveDistance;
		double finishX = getX() + dXTravel;
		double finishY = getY() + dYTravel;
		boolean fill = true;
		paintOval(finishX,finishY,5,5,Color.orange,fill);
		paintOval(finishX2,finishY2,5,5,Color.cyan,fill);
		paintLine(getX(),getY(),finishX,finishY,Color.red);
		paintLine(getX(),getY(),finishX2,finishY2,Color.yellow);
	}
	public void doMovement(ScannedRobotEvent e) {
		double distanceToTarget = e.getDistance();
		double distanceToNextDestination = myPos.distance(nextDestination);
		
		//grid surfing variables
		for (int x = 0; x < waveArray.size(); x++) {
			double radius;
			Wave w = waveArray.get(x);
			radius=(getTime()-w.startTime)*w.waveSpeed+w.waveSpeed;
			Point2D.Double hotBullet=project(w.origin,radius,w.angle);
			Point2D.Double learnBullet = project(w.origin,radius,w.learning1);
			Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
			Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);
			Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);
			double hotBulletPX = hotBullet.x * Math.cos(hotBullet.x) - Math.sin(hotBullet.x) * (hotBullet.y + 100);
			double hotBulletPY = hotBullet.x * Math.sin(hotBullet.x) + Math. cos(hotBullet.x)+ (hotBullet.y + 100);
			Point2D.Double hotBulletP = new Point2D.Double(hotBulletPX,hotBulletPY);
			double size1 = 36;
			double size2 = 36;
			Rectangle2D.Double predictDestination = new Rectangle2D.Double(nextDestination.x,nextDestination.y, size1,size2);
			Rectangle2D.Double currentDestination = new Rectangle2D.Double(getX(),getY(),26,26);
			
			Point2D.Double hotValue = bulletPredictDistanceDouble(getX(),getY(),hotBullet.x,hotBullet.y,w.angle);
			Point2D.Double latValue = bulletPredictDistanceDouble(getX(),getY(),latBullet.x,latBullet.y,w.latVel + w.angle);
			Point2D.Double learn1Value = bulletPredictDistanceDouble(getX(),getY(),learnBullet.x,learnBullet.y,w.learning1);
			Point2D.Double learn2Value = bulletPredictDistanceDouble(getX(),getY(),learnBullet2.x,learnBullet2.y,w.angle + learningAngle[2]);
			Point2D.Double learn3Value = bulletPredictDistanceDouble(getX(),getY(),learnBullet3.x,learnBullet3.y,w.angle + learningAngle[3]);
			
			if(distanceToNextDestination <= 10 || 
				predictDestination.contains(hotValue) ||
				predictDestination.contains(latValue) ||
				predictDestination.contains(learn1Value) ||
				predictDestination.contains(learn2Value) ||
				predictDestination.contains(learn3Value) ||
				currentDestination.contains(learnBullet) ||
				currentDestination.contains(learnBullet2) ||
				currentDestination.contains(learnBullet3) ||
				currentDestination.contains(hotBullet) ||
				currentDestination.contains(latBullet) ||
				predictDestination.contains(learnBullet) ||
				predictDestination.contains(learnBullet2) ||
				predictDestination.contains(learnBullet3) ||
				predictDestination.contains(hotBullet) ||
				predictDestination.contains(latBullet)) {
			
			/*
			if(distanceToNextDestination <= 10 || 
				predictDestination.contains(learnBullet) ||
				predictDestination.contains(learnBullet2) ||
				predictDestination.contains(learnBullet3) ||
				predictDestination.contains(hotBullet) ||
				predictDestination.contains(latBullet) ||
				currentDestination.contains(learnBullet) ||
				currentDestination.contains(learnBullet2) ||
				currentDestination.contains(learnBullet3) ||
				currentDestination.contains(hotBullet) ||
				currentDestination.contains(latBullet)) {
			*/		
				Rectangle2D.Double battleField = new Rectangle2D.Double(45, 45, getBattleFieldWidth() - 90, getBattleFieldHeight() - 90);
				Point2D.Double testPoint;
				int i=0;
			
				do {
					testPoint = calcPoint(myPos, Math.min(distanceToTarget*0.8,(150*Math.random() + 40)), 2*Math.PI*Math.random());
					if(battleField.contains(testPoint)) {
						nextDestination = testPoint;
					
					}
				} while(i++ < 200);
			
				lastPosition = myPos;
			
			} else {
				double angle = calcAngle(nextDestination, myPos) - getHeadingRadians();
				double direction = 1;
				
				if(Math.cos(angle) < 0) {
					angle += Math.PI;
					direction = -1;
				}
				boolean fill = false;
				boolean filling = true;
				paintLine(myPos.x,myPos.y,nextDestination.x,nextDestination.y,Color.white);
				paintRect(nextDestination.x - 18,nextDestination.y - 18,36,36,Color.black,fill);
				paintRect(nextDestination.x - 20,nextDestination.y - 20,40,40,Color.black,fill);	
				paintRect(nextDestination.x - 22,nextDestination.y - 22,44,44,Color.black,fill);
				paintOval(nextDestination.x - 18,nextDestination.y - 18,36,36,new Color( 100, 0, 100,  80),filling);
				paintLine(nextDestination.x - 18,nextDestination.y - 18,getX(),getY(),Color.white);
				paintLine(nextDestination.x + 18,nextDestination.y + 18,getX(),getY(),Color.white);
				paintLine(nextDestination.x - 18,nextDestination.y - 18,getX(),getY(),Color.white);
				paintRect(myPos.x - 18,myPos.y - 18,36,36,Color.green,fill);
				paintRect(retrieveX(e) - 18,retrieveY(e) - 18,36,36,new Color(250,250,250,80),filling);
				setAhead(distanceToNextDestination * direction * moveDirection);	
				setTurnRightRadians(angle = Utils.normalRelativeAngle(angle));
				setMaxVelocity(Math.abs(angle) > 1 ? 0 : 8d);
				predictPosition(angle = Utils.normalRelativeAngle(angle));
			}
		}
	}

	//----------------------------------------------------------------------------------------------
	//outPrinting event
	public void printString(String string) {
		out.println(string);
	}
	public void printDouble(double d) {
		out.println(d);
	}
	public void printLong(long l) {
		out.println(l);
	}
	public void printFloat(float f) {
		out.println(f);
	}
	//painting events
	public void setColor(Color color) {
		Graphics g = getGraphics();
		g.setColor(color);
	}
	public void paintLine(double x, double y, double x2, double y2, Color color) {
		Graphics g = getGraphics();
		g.setColor(color);
		g.drawLine((int)x, (int)y, (int)x2, (int)y2);
	} 
	public void paintRect(double x, double y, double sizeX, double sizeY, Color color,boolean fill) {
		Graphics g = getGraphics();
		g.setColor(color);
		if (fill == true) {
			g.fillRect((int)x, (int)y, (int)sizeX,(int)sizeY);
		} else {
			g.drawRect((int)x, (int)y, (int)sizeX,(int)sizeY);
		}
	}
	public void paintOval(double x, double y, double sizeX, double sizeY, Color color,boolean fill) {
		Graphics g = getGraphics();
		g.setColor(color);
		if (fill == true) {
			g.fillOval((int)x, (int)y, (int)sizeX,(int)sizeY);
		} else {
			g.drawOval((int)x, (int)y, (int)sizeX,(int)sizeY);
		}
	}

	//- math ---------------------------------------------------------------------------------------
	public void bulletPredictDistance(double x, double y, double a, double b,double bulletAngle) {
		double xValue = 0;
		double yValue = distanceFromTwoPoints(x,y,a,b); // length of line
		double rotAngle = bulletAngle;//enter your own value(ratation angle) here later
		double rotateAngle = -(rotAngle);
		
		double hotXValue = xValue * Math.cos(rotateAngle) - Math.sin(rotateAngle) * (yValue);
		double hotYValue = xValue * Math.sin(rotateAngle) + Math.cos(rotateAngle) * (yValue);
		//Point2D.Double hotBulletP = new Point2D.Double(hotBulletPX,hotBulletPY);
		
		boolean fill = false;
		
		//paintLine(hotBullet.x,hotBullet.y,hotBulletP.x,hotBulletP.y,Color.white);
		//paintLine(a,b, hotXValue + a, hotYValue + b, Color.white);
		paintRect(hotXValue + a, hotYValue + b, 10,10,Color.red,fill);
	}
	public Point2D.Double bulletPredictDistanceDouble(double x, double y, double a, double b,double bulletAngle) {
		double xValue = 0;
		double yValue = distanceFromTwoPoints(x,y,a,b); // length of line
		double rotAngle = bulletAngle;//enter your own value(ratation angle) here later
		double rotateAngle = -(rotAngle);
		
		double hotXValue = xValue * Math.cos(rotateAngle) - Math.sin(rotateAngle) * (yValue);
		double hotYValue = xValue * Math.sin(rotateAngle) + Math.cos(rotateAngle) * (yValue);
		
		return new Point2D.Double(a + hotXValue,b + hotYValue);
	}
	private static Point2D.Double calcPoint(Point2D.Double p, double dist, double ang) {
		return new Point2D.Double(p.x + dist*Math.sin(ang), p.y + dist*Math.cos(ang));
	}
	
	private static double calcAngle(Point2D.Double p2,Point2D.Double p1){
		return Math.atan2(p2.x - p1.x, p2.y - p1.y);
	}	
	public double distanceFromTwoPoints(double x, double y, double a, double b) {
		for (int i = 0; i < waveArray.size(); i++) {
			double radius;
			Wave w = waveArray.get(i);
			radius=(getTime()-w.startTime)*w.waveSpeed+w.waveSpeed;
			Point2D.Double hotBullet=project(w.origin,radius,w.angle);
			
			//x + y = getX() + getY();
			//a + b = bullet x+ y;
			
			Point2D.Double point1 = new Point2D.Double(x, y);
			Point2D.Double point2 = new Point2D.Double(a, b);
			Point2D.Double rightPoint = new Point2D.Double(a, y);
			
			//paintLine(point1.x,point1.y, point2.x,point2.y,Color.white);
			//paintLine(point1.x,point1.y, rightPoint.x,rightPoint.y,Color.white);
			//paintLine(rightPoint.x,rightPoint.y,point2.x,point2.y,Color.white);
			double targetPlaceX = hotBullet.x;
			double targetPlaceY = hotBullet.y;
			targetPlaceX-=getX();
			targetPlaceY-=getY();
			//distance from points;
			double a2 = targetPlaceX;
			double b2 = targetPlaceY;
			out.println("a = " + a + " and b = " + b);
			double asquared = a2 * a2;
			double bsquared = b2 * b2;
			double difference = asquared + bsquared;
			out.println("difference = " + difference);
			double c2 = Math.sqrt(difference);			
			the = c2;
		}
		return(the);
	}
	public void moveWaves(ScannedRobotEvent e) {
		for (int i = 0; i < waveArray.size(); i++) {
			Wave w = waveArray.get(i);
			w.updateWaves(e);
			w.move();
			boolean fill = false;
			//paintLine(myPos.x,myPos.y,nextDestination.x,nextDestination.y,Color.white);
			//paintRect(nextDestination.x - 18,nextDestination.y - 18,36,36,Color.white,fill);
			paintLine(nextDestination.x - 18,nextDestination.y - 18,getX(),getY(),Color.white);
			paintRect((int)myPos.x - 18,(int)myPos.y - 18,36,36,Color.green,fill);
			if (w.isPast(e) == true) {
				waveArray.remove(w);//remove the wave once it passes us
			}
		}
	}
	public void checkIfEnemyFired(ScannedRobotEvent e) {
		double changeInEnergy = previousEnergy - e.getEnergy();
		if (changeInEnergy > 0 && changeInEnergy <= 3) {
			Wave w = new Wave(e, changeInEnergy);
			w.enemyX = retrieveX(e);
			w.enemyY = retrieveY(e);
			w.firePlace = getX() + getY();
			w.firePlaceX = getX();
			w.firePlaceY = getY();
			w.waveSpeed = 20 - (3 * changeInEnergy);
			double absBearing=e.getBearingRadians()+getHeadingRadians();
			w.startTime=getTime();
			w.angle=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI);
			w.learning1 = robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI + learningAngle[0]);
			w.latVel =(getVelocity()*Math.sin(getHeadingRadians()-w.angle))/w.waveSpeed;
			w.origin=project(new Point2D.Double(getX(),getY()),e.getDistance(),absBearing);
			waveArray.add(w);
		}
		previousEnergy = e.getEnergy();
	}
	//----------------------------------------------------------------------------------------------
	//classes
	//wave class
	public class Wave {
		//info stored in wave
		double firePlace;  //where I am when he fires
		double firePlaceX;  //my X when he fires
		double firePlaceY;  //my Y when he fires
		double enemyX;  //his X when he shot
		double enemyY;  //his Y when he shot
		double waveSpeed; //how fast the wave is moving
		
		//wave data
		double distanceFromOrigin = 0;  //how fast the wave is travelling
		
		//wave physics
		double originX;
		double originY;
		double startTime;
		
		//angle physics
		double angle;
		double latVel;
		
		double learning1;
		Point2D.Double origin;
		
		//info used with the wave
		double velCount;
		public Wave(ScannedRobotEvent e, double firePower) {
			//double changeInEnergy = previousEnergy - e.getEnergy();
			waveSpeed =20 - (3 * firePower);
			enemyX = retrieveX(e);
			enemyY = retrieveY(e);
			originX = retrieveX(e);
			originY = retrieveY(e);
		}
	
		public void move() {
			distanceFromOrigin += waveSpeed;
		}
		public void paint() {
			double bottomX = originX - distanceFromOrigin;
			double bottomY = originY - distanceFromOrigin;
			Graphics g = getGraphics();
			g.setColor(Color.red);
			g.drawOval((int) bottomX, (int) bottomY, (int) (distanceFromOrigin * 2), (int) (distanceFromOrigin * 2));
		}
		public void movement() {
			for (int i = 0; i < waveArray.size(); i++) {
				Graphics g = getGraphics();
				g.setColor(Color.red);
				g.fillRect((int)enemyX,(int)enemyY,10,10);
			}
		}
		public void updateWaves(ScannedRobotEvent e) {
			for (int i = 0; i < waveArray.size(); i++) {
				double radius;
				Wave w = waveArray.get(i);
				radius=(getTime()-w.startTime)*w.waveSpeed+w.waveSpeed;
				Point2D.Double hotBullet=project(w.origin,radius,w.angle);
				Point2D.Double learnBullet = project(w.origin,radius,w.learning1);
				Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
				Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);
				Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);

				/*
				double xValue = 0;
				double yValue = distanceFromTwoPoints(getX(),getY(),hotBullet.x,hotBullet.y); // length of line
				double rotAngle = angle;//enter your own value(ratation angle) here later
				double rotateAngle = -(rotAngle);
				
				double hotXValue = xValue * Math.cos(rotateAngle) - Math.sin(rotateAngle) * (yValue);
				double hotYValue = xValue * Math.sin(rotateAngle) + Math.cos(rotateAngle) * (yValue);
				//Point2D.Double hotBulletP = new Point2D.Double(hotBulletPX,hotBulletPY);
				*/
				boolean fill = true;
				
				//paintLine(hotBullet.x,hotBullet.y,hotBulletP.x,hotBulletP.y,Color.white);
				//paintLine(hotBullet.x, hotBullet.y, hotXValue + hotBullet.x, hotYValue + hotBullet.y, Color.white);
				
				bulletPredictDistance(getX(),getY(),hotBullet.x,hotBullet.y,angle);
				
				paintLine(getX(),getY(),0,0,Color.red);
				paintLine(getX(),getY(),getBattleFieldWidth(),0,Color.red);
				paintLine(getX(),getY(),getBattleFieldWidth(),getBattleFieldHeight(),Color.red);
				paintLine(getX(),getY(),0,getBattleFieldHeight(),Color.red);
				paintLine(getX(), getBattleFieldHeight(), getX(), getY(),Color.red);
				paintLine(getX(), 0, getX(), getY(),Color.red);
				paintLine(getBattleFieldWidth(), getY(), getX(), getY(),Color.red);
				paintLine(0, getY(), getX(), getY(),Color.red);
				/*
				paintOval(latBullet.x-7,latBullet.y-7,14,14,new Color(100,0,0),fill);
				paintOval(hotBullet.x-7,hotBullet.y-7,14,14,new Color(100,0,0),fill);
				*/
				
				//printDouble(hotBulletInterceptCoordinates.x + hotBulletInterceptCoordinates.y);
				//paintOval(hotBulletInterceptCoordinates.x,hotBulletInterceptCoordinates.y,20,20,Color.green,fill);
				if (learningAngle[1] != 0) {
					//paintOval(learnBullet.x - 6,learnBullet.y-6,12,12,new Color(0,0,100),fill);
				} 
				if (learningAngle[2] != 0) {
					//paintOval(learnBullet2.x - 6,learnBullet2.y-6,12,12,new Color(0,0,100),fill);
				}
				if (learningAngle[3] != 0) {
					//paintOval(learnBullet3.x - 6,learnBullet3.y-6,12,12,new Color(0,0,100),fill);
				}
			}
		}
	
		public boolean isPast(ScannedRobotEvent e) {
			if (distanceFromOrigin > e.getDistance()) {
				return (true);
			} else {
				return (false);
			}
		}
	}
}