package staticline.whiskey.intel;

import java.util.Vector;

import robocode.AdvancedRobot;
import robocode.RobocodeFileWriter;
import robocode.ScannedRobotEvent;
import staticline.IRobotManager;
import staticline.whiskey.AbstractWhiskeyManager;
import staticline.whiskey.Whiskey;
import staticline.whiskey.utils.DistanceMeasures;
import staticline.whiskey.utils.Pattern;

public class IntelligenceManager extends AbstractWhiskeyManager implements IRobotManager {
	
	public IntelligenceManager(AdvancedRobot b) {
		super(b);
	}

	public void initialize() {
		this.bot.towards = 0;
        this.bot.across = 0;
        this.bot.away = 0;
        
        //load a classifier and patterns - if not existing
        if((this.bot.classifier==null)||(this.bot.allPatterns.size()<=0)){
        	/*
        	System.out.println("load classifier and patterns");
	        try{
	        	//load classifier
	        	Base64.InputStream bin = new Base64.InputStream(new ByteArrayInputStream(Classifiers.SHORT__RF.getBytes()));
				GZIPInputStream gzin = new GZIPInputStream(bin);
				ObjectInputStream in = new ObjectInputStream(gzin);
				this.bot.classifier = (RandomForest)in.readObject();
				//load patterns
				bin = new Base64.InputStream(new ByteArrayInputStream(Classifiers.SHORT__PATTERNS.getBytes()));
				gzin = new GZIPInputStream(bin);
				in = new ObjectInputStream(gzin);
				this.bot.allPatterns = (Vector<Vector<Pattern>>)in.readObject();
				
				//make ARFF header
				this.bot.arffHeader = "@relation 'battle'\n";
		    	for(Vector<Pattern> pv : this.bot.allPatterns){
		    		for(Pattern p : pv){
		    			this.bot.arffHeader +=  "@attribute "+p.patternString+" numeric \n";
		    		}
		    	}
		    	this.bot.arffHeader += "@attribute towards numeric\n";
		    	this.bot.arffHeader += "@attribute across numeric\n";
		    	this.bot.arffHeader += "@attribute away numeric\n";
		    	this.bot.arffHeader += "@attribute class {wavesurfer,stopngo,antigrav,simple}\n\n@data\n";
	        }catch(Exception e){
	        	e.printStackTrace();
	        }
	        */
        }
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		try {
            //targets name
            this.bot.t_name = e.getName().hashCode();
            //targets deltas (velocity, heading, energy)
            this.bot.t_delta_v = e.getVelocity() - this.bot.t_velocity_old;
            this.bot.t_delta_h = e.getHeadingRadians() - this.bot.t_heading_old;
            this.bot.t_delta_energy = e.getEnergy() - this.bot.t_energy_old;
            //store targets data for next round
            this.bot.t_velocity_old = e.getVelocity();
            this.bot.t_heading_old = e.getHeadingRadians();
            this.bot.t_distance = e.getDistance();
            
            // Calculate the angle to the scanned robot
            double angle = Math.toRadians((this.bot.getHeading() + e.getBearing()) % 360);
            // Calculate the coordinates of the robot
            this.bot.scannedY = (int)(this.bot.getY() + Math.cos(angle) * this.bot.t_distance);
            this.bot.scannedX = (int)(this.bot.getX() + Math.sin(angle) * this.bot.t_distance);
            
            
            /* ----- classification ----- */
            char _dv = Whiskey.alphabet.handleDVelocity(this.bot.t_delta_v);
            char _dh = Whiskey.alphabet.handleDHeading(this.bot.t_delta_h);
            this.bot.dv_sym.push(""+_dv);
            this.bot.dh_sym.push(""+_dh);
            long time = this.bot.getTime();

            //if((dv_sym.size()>=windowSize) && (dh_sym.size()>=windowSize)){
            if(time % 20 == 0){ //less spam
            	String arff = this.bot.arffHeader;

            	String refPattern = "";
            	for(String c : this.bot.dh_sym){
            		refPattern += c;
            	}
            	//column patterns
            	for(Vector<Pattern> pv : this.bot.allPatterns){
            		for(Pattern p : pv){
            			double dist = DistanceMeasures.getLevenshteinDist(p.patternString, refPattern);
            			arff += dist+",";
            		}
            	}
            	//movement analysis
            	int mStatus = doMovementAnalysis(this.bot.scannedX, this.bot.scannedY, (int)this.bot.getX(), (int)this.bot.getY(), this.bot.t_heading_old);
            	switch (mStatus) {
				case 0:
					break;
				case 1:
					this.bot.towards++;
					break;
				case 2:
					this.bot.across++;
					break;
				case 3:
					this.bot.away++;
					break;
				}
            	//calculate movement stats
    			double tow = (double)this.bot.towards/time;
    			double acr = (double)this.bot.across/time;
    			double awa = (double)this.bot.away/time;
            	arff += tow+",";
            	arff += acr+",";
            	arff += awa+",";
            	arff += "?\n";
            	
            	RobocodeFileWriter writer = new RobocodeFileWriter(this.bot.getDataDirectory()+"/tmp.arff",false); 
            	writer.write(arff);
            	writer.close();
            	
            	/*
            	Instances unlabeled = new Instances(
            			new BufferedReader(
            					new FileReader(this.bot.getDataDirectory()+"/tmp.arff")));
            	unlabeled.setClassIndex(unlabeled.numAttributes()-1);
            	//Errors here? Check loaded classifier and fitting pattern-file (patterns numbers & length must fit)
            	double botClass = this.bot.classifier.classifyInstance(unlabeled.lastInstance());
            	double[] fDist = this.bot.classifier.distributionForInstance(unlabeled.lastInstance());
            	double confidence = fDist[(int)botClass];
            	System.out.println("[guess] "+unlabeled.classAttribute().value((int)botClass) + " " + confidence);
            	*/
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }

	}

	/**
	 * does a simple movement analysis
	 * @param x1 target's x
	 * @param y1 target's y
	 * @param x2 my x
	 * @param y2 my y
	 * @param heading target's heading in <b>Radians</b>
	 * @return int movement code <br/>
	 *	0 - no relative movement<br/>
	 * 	1 - movint towards me<br/>
	 * 	2 - moving across<br/>
	 * 	3 - moving away from me<br/> 
	 */
	public static int doMovementAnalysis(int x1, int y1, int x2, int y2, double heading){
		double relAngle = Math.toDegrees(Math.atan2(x1-x2,y2-y1));
        double absBearing = (360-relAngle)%360;
        // 3 types of movement
        boolean towards = false;
        boolean away = false;
        boolean across = false;
        //towards me?
        double leftBorder = absBearing<45 ? 360+absBearing-45 : absBearing-45;
        double rightBorder = (absBearing+45)%360;
        double eHeading = Math.toDegrees(heading);//==e.getheading but sparing the get() call
        
        //painting
        Whiskey.forward_left_angle = leftBorder;
        Whiskey.forward_right_angle = rightBorder;
        
        if(eHeading>leftBorder && eHeading<rightBorder && heading > 0){
        	towards = true;
        }else if(eHeading>leftBorder && eHeading<rightBorder && heading < 0){
        	away = true;
        }
        //away?
        absBearing = (absBearing+180)%360;
        leftBorder = (absBearing-45)<0 ? 360+absBearing-45 : absBearing-45;
        rightBorder = (absBearing+45)%360;
        
        //painting II
        Whiskey.backward_left_angle = leftBorder;
        Whiskey.backward_right_angle = rightBorder;
        
        if(eHeading>leftBorder && eHeading<rightBorder && heading > 0){
        	away = true;
        }else if(eHeading>leftBorder && eHeading<rightBorder && heading < 0){
        	towards = true;
        }
        //across
        if(towards == false && away == false && heading != 0){
        	across = true;
        }
        
        //output
        int status;
        if(towards){
        	status = 1;
        }else if(across){
        	status = 2;
        }else if(away){
        	status = 3;
        }else{
        	status = 0;
        }
        return status;
	}

}
