package staticline.whiskey.radar;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import staticline.IRobotManager;
import staticline.whiskey.AbstractWhiskeyManager;

public class RadarManager extends AbstractWhiskeyManager implements IRobotManager {
	
	public RadarManager(AdvancedRobot b) {
		super(b);
	}

	public void initialize() {
		this.bot.turnRadarRightRadians(Double.POSITIVE_INFINITY);
		this.bot.scan();
		
		this.bot.energy_old = this.bot.getEnergy();
		this.bot.delta_energy = this.bot.getEnergy() - this.bot.energy_old;
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double radarTurn =
            // Absolute bearing to target
            this.bot.getHeadingRadians() + e.getBearingRadians()
            // Subtract current radar heading to get turn required
            - this.bot.getRadarHeadingRadians();
		this.bot.setTurnRadarRightRadians(1.5*Utils.normalRelativeAngle(radarTurn));
	}
}
