package myl.micro;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import myl.shared.Scan;
import myl.shared.ScanMsg;
import java.io.*;

/**
 * Troodon "wounding tooth" - a microbot by Martin Y Lepsoy (DrLoco)
 * email: mlepsoy@yahoo.no
 *
 * Radar version of Troodon - An attempt to make a good 1-on-1 , melee and team robot in a microbot
 *
	 ** Features **
	 * - uses antigravity to choose the best next destination
	 * - stores information about all bots
	 * - team capabilities
	 * - I have also made a droid version of Troodon
	 **
 *
 * Version changes:
 *
 * 30.01.03 - first public release
 * 
 * droid version complete
 * two external classes: Scan and ScanMsg
 * many codesize tricks
 * now bearing is not stored, instead we always calculate the bearing from us to the stored point x,y
 *	this will make us aim better when we can't see that target anymore like on a 2000 x 2000 battlefield
 *
 * 27.01.03 - first jar file created, but not release
 *
 *
 * Special thanks to David Alves for teaching me about hashtables
 * I read DuelistMicroMelee (a fantastic bot) and now I understand so much more:-)
 */

public class Troodon extends TeamRobot {
	
	static Hashtable enemies;	//a hashtable of all enemies and teammates
	
	static Scan target;			//the current target we are tracking at the moment
	
	static double	destinationX;		//destinationX and destinationY makes the point we are currenlty driving to
	static double	destinationY;		// -
	
	public void run() {
		setAdjustGunForRobotTurn(true);
		enemies = new Hashtable();	//empty our hashtable when a new round is starting
		
		setTurnRadarRight( Double.POSITIVE_INFINITY );	//start spinning radar, and we never stop it
		
		setColors( Color.green.darker() , Color.green.darker() , Color.yellow );
		
		while( true ) {
			double ourX;
			double ourY;
			double testX;	//testX and testY makes a random testpoint around our tank
			double testY;	// -
			double fieldWidth;
			double fieldHeight;
			double force;	//the force of our testpoint. we will drive to the point with the smallest force
			double smallestForce;	//the force of the point with the smallest force found yet
			double distance;
			double move;
			double firePower;
			int pointCounter;	//an increasing counter when trying to find our next destination
			ourX = getX();
			ourY = getY();
			smallestForce = distance = 200;
			try {
				target = ( Scan ) enemies.get( target.name );
				
				distance = target.distance = Point2D.Double.distance( ourX , ourY , testX = target.x , testY = target.y );
				
				setTurnGunRightRadians( relative( Math.atan2( testX - ourX , testY - ourY ) - getGunHeadingRadians() ) );
				
				/**
				 * powersaving when low on energy and far from target.
				 * stop shooting if it will kill us, or when we have
				 * less than 3 hp left and the enemy has more hp than us
				 */
				
				if ( getEnergy() - ( firePower = getEnergy() * 40 / distance ) - 0.1 > Math.min( target.energy , 3 ) ) {
					setFire( firePower );
				}
			} catch( Exception exception ) { }
			
			if ( Math.abs( getDistanceRemaining() ) < 5 ) {
				pointCounter = 0;
				do {	//do{}while() cost less codesize than for(){}
					force = 0;
					
					/**
					 * move is used as a size for the area around our tank we will search for our testpoints.
					 * each side of the square is between 0 and ( 2 * 8 * e.getDistance() / 12 ).
					 *
					 * since we are in the middle of the square, our longest possible move (in turns) will be
					 * e.getDistance() / 12. that is a bit before a power 3 bullet will reach us.
					 */
					
					/**
					 * testX and testY makes a random point within our search square
					 * the coordinate is then fixed so it won't excede 20 pixles inside our battlefield
					 * and finally we multiply the distances from the point to the nearest walls (x * y).
					 * if the value is to small we discard the point. this makes us discard all points deep in a corner
					 */
					
					if ( Math.min( testX = Math.max( 20 , Math.min( ourX + Math.random() * 2 * ( move = Math.random() * distance * 0.6666666666666666666666666666666667 ) - move , ( fieldWidth = getBattleFieldWidth() ) - 20 ) ) , fieldWidth - testX )
					 * Math.min( testY = Math.max( 20 , Math.min( ourY + Math.random() * 2 * move - move , ( fieldHeight = getBattleFieldHeight() ) - 20 ) ) , fieldHeight - testY ) > 2500 ) {
							
						/**
						 * cycle all bots and add force to the point based on the distance to the bot.
						 * a teammate's antigravity force is 3/4 as much as the force of an enemy.
						 * then we add force to the point based on the distance to our bot, and if we
						 * are in a melee or a team battle we add a force based on distance to the
						 * middle of the field
						 */
						
						Enumeration n = enemies.elements();
						while( n.hasMoreElements() ) {
							Scan stored = ( Scan ) n.nextElement();
							force += 1 / Point2D.Double.distance( stored.x , stored.y , testX , testY );
						}
						force += 1 / Point2D.Double.distance( ourX , ourY , testX , testY );
						if ( getOthers() > 1 ) {
							force += 1 / Point2D.Double.distance( ourX , ourY , fieldWidth / 2 , fieldHeight / 2 );
						}
						
						/**
						 * if the force on this testpoint is less than the force
						 * of our current destination, that will be our destination
						 */
						
						if ( force < smallestForce ) {
							smallestForce = force;
							destinationX = testX;
							destinationY = testY;
						}
					}
					pointCounter++;
				} while( pointCounter < 200 );
				
			}
			
			/**
			 * this is the code of the smallest way to drive
			 * to a given point in the shortest route.
			 * - developed by David Alves and Dummy
			 */
			
			setAhead(
			 ( ( testX = relative( Math.atan2( destinationX - ourX , destinationY - ourY ) - getHeadingRadians() ) ) ==
			 ( testX = Math.atan( Math.tan( testX ) ) ) ? 1 : - 1 )
			 * Point2D.Double.distance( ourX , ourY , destinationX , destinationY ) );
			setTurnRightRadians( testX );
			
			/**
			 * stop when we are turning more than
			 * 45 degrees to make sharper turns
			 * unfortunately this was to coslty
			 */
			
			//setMaxVelocity( getTurnRemaining() > 45 ? 0 : 8 );
			
			execute();
		}
	}
	
	public void onScannedRobot( ScannedRobotEvent e ) {
		Scan scanned = new Scan();
		
		/**
		 * add all important information
		 */
		
		double bearing;
		scanned.name = e.getName();
		scanned.x = getX() + e.getDistance() * Math.sin( bearing = getHeadingRadians() + e.getBearingRadians() );
		scanned.y = getY() + e.getDistance() * Math.cos( bearing );
		scanned.energy = e.getEnergy();
		do_changeTarget( scanned );
		
		try {
			broadcastMessage( new ScanMsg( ( Scan ) scanned ) );
		} catch ( IOException ex ) { }
	}
	
	public void onMessageReceived( MessageEvent e ) {
		ScanMsg recieved = ( ScanMsg ) e.getMessage();
		
		do_changeTarget( recieved.msg );
	}
	
	void do_changeTarget( Scan bot ) {
		
		/**
		 * put the scanned bot's information in our hashtable
		 */
		
		enemies.put( bot.name , bot );
		
		/**
		 * make this bot our target if we have none,
		 * or this bot is closer than our current target
		 * but only as long as it is an enemy
		 */
		
		if ( isTeammate( bot.name ) == false && ( target == null || Point2D.Double.distance( getX() , getY() , bot.x , bot.y ) < target.distance ) ) {
			target = bot;
		}
	}
	
	/**
	 * get the angle relative to your heading where - pi < angle < pi
	 */
	
	public double relative( double angle ) {
		return Math.atan2( Math.sin( angle ) , Math.cos( angle ) );
	}
	
	/**
	 * when a bot is killed we remove it from our hashtable
	 */
	
	public void onRobotDeath( RobotDeathEvent e ) {
		enemies.remove( e.getName() );
	}
}