package sch;


import robocode.*;
import java.io.*;
import java.awt.Color;

/**
 * Simone - A Bot by Simone Chiaretta <simonech@logicapiu.it><br>
 * It's a test bot: just a structure test to see if my structure ideas works well.<br>
 * The goal of his follower (Piyo Bot) is to become competitive in IBM AlphaWorks Robocode Rumble.<br>
 * The final structure of this Piyo Bot should include:<br>
 * <ul>
 *	<li>Multiple Strategy (I prefer this name to "State")
 *	<li>Predictive Targeting (Still, linear and circular)
 *	<li>Anti Gravity in all strategies
 *	<li>Enemy position logging
 *	<li>Selective Targeting (based on how much a certain enemy is a threat for mine)
 *	<li>Local storage to remember past battles performances
 * </ul>
*/
public class Simone extends AdvancedRobot implements Constants {
	
	// Static variables: persistent through rounds
	private static EnemyManager enemyManager=null;
	private static StrategyManager strategyManager=null;
	
	// Instance variables	
	private Strategy currentStrategy=null;
	
	public Simone (){
	}
	
	// Routine called at the beginning of the first round
	private void inizialize() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.cyan,Color.blue,Color.green);
		
		//Create a new enemy manager
		enemyManager=new EnemyManager(this);
		
		//Create a new strategy manager
		strategyManager=new StrategyManager(this, enemyManager);
		
		//Adding to the strategy manager all defined strategy
		//strategyManager.addStrategy(new SimpleStrategy());
		strategyManager.addStrategy(new AntiGravityStrategy());
		strategyManager.addStrategy(new WinStrategy());
		strategyManager.addStrategy(new DodgeStrategy());
		
		//Initialize both enemy and strategy manager
		enemyManager.initialize();
		strategyManager.initialize();
		out.println("Version 0.3c initialized");
		out.println("DEBUG level: "+DEBUG);
	}
	
	// Routine called at the beginning of each round different from the first
	private void reinizialize() {
		// Reinitialize both enemy and strategy manager
		enemyManager.reinitialize();
		strategyManager.reinitialize();
		out.println("Version 0.3c re-initialized");
	}

	/**
	 * run: Simone's default behavior
	 */
	public void run() {
		//initialize the bot at the first round of a match
		if (getRoundNum()==0)
			inizialize();
		else
		//reinitialize the bot at the start of each round different from the first
			reinizialize();
		setTurnRadarRightRadians(2*PI);
		while(true) {
			// do this forever till you die
			// select the better strategy for this particular situation
			currentStrategy=strategyManager.getCurrentStrategy();
			// do the movement referring to the current strategy
			currentStrategy.setMovement();
			// do the scanning referring to the current strategy
			currentStrategy.setScan();
			// move the gun and eventually fire referring to the current strategy
			currentStrategy.setGunRotation();
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// pass the scanned bot information to the enemy manager
		enemyManager.onScannedRobot(e);
	}

	/**
	 * onHitWall: What to do when you hit by a wall
	 */
	public void onHitWall(HitWallEvent e) {
		// pass the hit wall event to the current strategy manager
    	currentStrategy.onHitWall(e);
	}

	/**
	 * onHitRobot: What to do when you collide with another robot
	 */
	public void onHitRobot(HitRobotEvent  e) {
		// pass the hit robot event to the current strategy manager
		currentStrategy.onHitRobot(e);
	}

	/**
	 * onHitByBullet: What to do when you hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		// pass the hit by bullet event to the current strategy manager
		currentStrategy.onHitByBullet(e);
	}

	/**
	 * onBulletHit: What to do when a bullet shot by you hits another bot
	 */
	public void onBulletHit(BulletHitEvent e) {
		Bullet currBullet=e.getBullet();
		String victimName=currBullet.getVictim();
		Bot hitBot=enemyManager.getBot(victimName);
		
		// Inform the bot object that a bullet hit its
		hitBot.addHit(currBullet);
   }

	/**
	 * onWin: What to do when you win :-)
	 */
	public void onWin(WinEvent e) {
		//I win when my current target dies, and since onWin has an higher
		//priority then onRobotDeath I call the same function
		strategyManager.computeCurrentStrategy();
		enemyManager.onRobotDeath(enemyManager.getCurrentTarget().getName());
		out.println("************ I WIN!!!!! **************");
		//I call the round finalization procedures
		finalizeRound();
		if(BotUtil.varContains(DEBUG,DEBUG_BRIEF_STATS)) enemyManager.printStats();
	}

	/**
	 * onDeath: What to do when you die :-(
	 */	
	public void onDeath(DeathEvent e) {
		finalizeRound();
		out.println("************ I DIED !!!!! **************");
		if(BotUtil.varContains(DEBUG,DEBUG_BRIEF_STATS)) enemyManager.printStats();
	}

	/**
	 * onRobotDeath: What to do when a robot dies
	 */	
	public void onRobotDeath(RobotDeathEvent e) {
		strategyManager.computeCurrentStrategy();
		enemyManager.onRobotDeath(e.getName());
	}

	/**
	 * onSkippedTurn: What to do when you skip a turn
	 */		
	public void onSkippedTurn(SkippedTurnEvent e) {
		/* removed because printing to System.out make the risk of a new skipped turn higher
		if (getOthers()!=0)
			System.out.println("-->> DAMN!!! I SKIPPED A TURN, close this fucking console to prevent this");
		*/
	}
	
	private void finalizeRound () {
		enemyManager.calculateStats();
		enemyManager.saveStatsFiles();
	}
}
