package sch;

import robocode.*;

/**
 * Model class used to specify strategy related task
 */

public abstract class Strategy implements Constants {
	
	protected StrategyManager strategyManager;
	protected AdvancedRobot myBot;
	protected EnemyManager enemyManager;

	public Strategy () {}

	public void setStrategyManager(StrategyManager strategyManager) {
		this.strategyManager=strategyManager;
		this.myBot=strategyManager.getMyBot();
		this.enemyManager=strategyManager.getEnemyManager();
	}
	
	public void initialize () {}
	
	public void reinitialize () {}
	
	public String getName() {return "";}
	
	public double getGoodness() {return 0.0;}

	public void setMovement() {}

	public void setScan() {}

	public void setGunRotation() {}

	/**
	 * onHitWall: What to do when you hit by a wall
	 */
	public void onHitWall(HitWallEvent e) {}

	/**
	 * onHitRobot: What to do when you collide with another robot
	 */
	public void onHitRobot(HitRobotEvent  e) {}

	/**
	 * onHitByBullet: What to do when you are hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {}
	
	
	protected double calculateRandomMovement() {
		double movementAmountRange = MAX_MOVEMENT_AMOUNT-MIN_MOVEMENT_AMOUNT;
		
		return MIN_MOVEMENT_AMOUNT + Math.random()*movementAmountRange;
	}

	protected double calculateRandomSpeed() {
		double movementSpeedRange = MAX_MOVEMENT_SPEED-MIN_MOVEMENT_SPEED;
		
		return MIN_MOVEMENT_SPEED + Math.random()*movementSpeedRange;
	}

	protected double calculateRandomTimeInterval() {
		double timeIntervalRange = MAX_TIME_INTERVAL-MIN_TIME_INTERVAL;
		
		return MIN_TIME_INTERVAL + Math.random()*timeIntervalRange;
	}

	/**Move towards an x and y coordinate**/
	protected void goTo(double x, double y) {
	    double dist = 2000.0*BotMath.getRange(myBot.getX(),myBot.getY(),x,y);
	    double angle = BotMath.absBearing(myBot.getX(),myBot.getY(),x,y);
	    double r = turnTo(angle);
	    if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) System.out.println("Moving at "+Math.toDegrees(angle)+" for "+dist * r+" px");
	    myBot.setAhead(dist * r);
	}


	/**Turns the shortest angle possible to come to a heading, then returns the direction the
	the bot needs to move in.**/
	protected double turnTo(double angle) {
	    double turnAmount;
    	double dir=1.0;
	    turnAmount = BotMath.normaliseBearing(angle - myBot.getHeadingRadians());
	    if (turnAmount > PI/2) {
	        turnAmount -= PI;
	        dir = -1.0;
	    }
	    else if (turnAmount < -PI/2) {
	        turnAmount += PI;
	        dir = -1.0;
	    }
	    else {
	        dir = 1.0;
	    }
	    myBot.setTurnRightRadians(turnAmount);
	    return dir;
	}
}
