package stelo;
import robocode.*;
//import java.awt.Color;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;

public class IntrinsicVolatility extends AdvancedRobot
{
	static DCGun_1on1 gun;
	static RandomMovement randomMove;
	static MirrorMovement mirrorMove;
	static WaveSurfingMovement wsMove;
	
	boolean stationary = false;
	boolean neverShoots = false;
	
	static double enemyEnergy;	
	static int moveMode = 2;
	
	static int[] hit = {5, 5, 5};
	static int[] enemyFired = {55, 55, 55};

	/**
	 * run: Mirror's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
				
		if (randomMove == null) randomMove = new RandomMovement(this);
		randomMove.initRound();		
		if (mirrorMove == null) mirrorMove = new MirrorMovement(this);
		mirrorMove.initRound();
		if (wsMove == null) wsMove = new WaveSurfingMovement(this);
		wsMove.initRound();
				
		if (gun == null) {
			gun = new DCGun_1on1(this);
			if (stationary) {
				gun.minBulletPower = 3;
				gun.referenceMode = true;
			}
			if (neverShoots) {
				gun.maxBulletPower = 0;
				gun.minBulletPower = 0;
			}
		}
		gun.initRound();		
		
		while(true) {
			if (moveMode == 0) {
				if (!stationary) randomMove.execute();
				else randomMove.radarOnly();
			} else if (moveMode == 1) {
				if (!stationary) mirrorMove.execute();
				else mirrorMove.radarOnly();
			} else {
				if (!stationary) wsMove.execute();
				else wsMove.radarOnly();			
			}
			//setTurnRightRadians(getTurnRemainingRadians() + Math.sin(getTime()) * getVelocity() / 8.0);
			if (Math.random() < 0.1)
				setMaxVelocity(3.0 + Math.random() * 10.0);
			
			
			gun.execute();
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		randomMove.update(e);
		mirrorMove.update(e);
		wsMove.update(e);
		
		if (!neverShoots) gun.update(e);
		
		if (enemyEnergy > (enemyEnergy = e.getEnergy())) {
			enemyFired[moveMode]++;
			//out.println("Enemy fired");
			
			out.println("---------------------------------------");
			out.println("RandomMove hit: " + hit[0] + " enemyFired: " + enemyFired[0]);
			out.println("MirrorMove hit: " + hit[1] + " enemyFired: " + enemyFired[1]);
			out.println("WaveSurfingMove hit: " + hit[2] + " enemyFired: " + enemyFired[2]);

			// when melee, use RandomMovement
			if (getOthers() > 1)
				moveMode = 0;
			else if ((double) (hit[0]) / enemyFired[0] <= (double) hit[1] / enemyFired[1]) {
				if ((double) (hit[2]) / enemyFired[2] <= (double) hit[0] / enemyFired[0])
					moveMode = 2;
				else
					moveMode = 0;
			} else {
				if ((double) (hit[1]) / enemyFired[1] <= (double) hit[2] / enemyFired[2])
					moveMode = 1;
				else
					moveMode = 2;
			}
			
			if (moveMode == 0)
				out.println("Movement: RandomMove");
			else if (moveMode == 1)
				out.println("Movement: MirrorMove");
			else
				out.println("Movement: WaveSurfingMove");				
		}
	}

	public void onHitWall(HitWallEvent e) {
		out.println("Hit wall");
	}

	public void onHitByBullet(HitByBulletEvent e) {
		if (getOthers() > 1)
			turnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()));
		wsMove.onHitByBullet(e);
		hit[moveMode]++;

		this.setMaxVelocity(8.0);
		
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		wsMove.onBulletHitBullet(e);
	}

	public void onRobotDeath(RobotDeathEvent e) {
		if (getOthers() == 0) {
			randomMove.cleanUpRound();
			mirrorMove.cleanUpRound();
			gun.cleanUpRound();
		}
	}

	public void onBulletHit(BulletHitEvent e) {
		gun.update(e);
	}
	
	public void onDeath(DeathEvent event) {
		if (getOthers() > 0) {
			randomMove.cleanUpRound();
			mirrorMove.cleanUpRound();
			wsMove.cleanUpRound();
			gun.cleanUpRound();
			

		}
	}
}
	