package kawigi.spare.parts;
import robocode.*;
/**
 * WallMovement - movement mode which causes the robot to move along the walls.
 */
public class WallMovement extends MovementStrategy implements java.io.Serializable
{
	private transient boolean back;
	private transient double distancefromwall;
	private transient double focaldistance;
	private transient int quickhits;
	private transient long lastHitTime;
	private double distanceFromRobots;
	
	public WallMovement(AdvancedRobot robot, TargetSelector targetter)
	{
		super (robot, targetter);
		distancefromwall = robot.getWidth();
		focaldistance = 300/Math.PI;
		quickhits = 0;
		back = false;
		distanceFromRobots = 100;
	}

	public void onEvent(Event e)
	{
		if (e instanceof HitRobotEvent)
		{
			if (((HitRobotEvent)e).isMyFault())
				flip();
		}
		else if (e instanceof HitByBulletEvent)
		{
			if (e.getTime() - lastHitTime < 35)
				flip();
			else
				quickhits = 0;
			quickhits++;
			lastHitTime = e.getTime();
		}
	}
	
	private void flip()
	{
		if ((robot.getVelocity() < 0) == back)
			back = !back;
	}

	public void setAction()
	{
		if (willHitWall())
		{
			if (back)
			{
				robot.setTurnLeft(80);
				robot.setBack(200);
			}
			else
			{
				robot.setTurnRight(80);
				robot.setAhead(200);
			}
		}
		else
		{
			int direction = (int)Math.round(robot.getHeading()/90);
			double theta = direction*90-robot.getHeading();
			//normalize:
			theta = ((theta + 180)%360-360)%360+180;
			if (theta > 0)
				robot.setTurnRight(theta);
			else if (theta < 0)
				robot.setTurnLeft(-theta);
			if (back)
				robot.setBack(50);
			else
				robot.setAhead(50);
		}
	}
	
	public boolean willHitWall()
	{
		double projX = Math.sin(robot.getHeadingRadians())*focaldistance;
		double projY = Math.cos(robot.getHeadingRadians())*focaldistance;
		if (back)
		{
			projX = robot.getX() - projX;
			projY = robot.getY() - projY;
		}
		else
		{
			projX += robot.getX();
			projY += robot.getY();
		}
		return (projX < distancefromwall || projY < distancefromwall || projX > robot.getBattleFieldWidth()-distancefromwall || projY > robot.getBattleFieldHeight()-distancefromwall);
	}
	
	private double wallDistance()
	{
		double dist = robot.getX();
		if (dist > robot.getY())
			dist = robot.getY();
		if (dist > robot.getBattleFieldWidth()-robot.getX())
			dist = robot.getBattleFieldWidth()-robot.getX();
		if (dist > robot.getBattleFieldHeight()-robot.getY())
			dist = robot.getBattleFieldHeight()-robot.getY();
		return dist;
	}
	
	private void goToWall()
	{
		if (wallDistance() > focaldistance);
		{
			robot.setTurnLeft(robot.getHeading()%90);
			robot.setAhead(Math.max(robot.getBattleFieldWidth(), robot.getBattleFieldHeight()));
		}
	}
}
