/*
 * Created on 13/11/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.data;

import java.text.DecimalFormat;
import java.util.ArrayList;
import axeBots.AxeBot;
import axeBots.AxeException;
import axeBots.musashi.AxeVector;
import axeBots.util.RoboMath;
import java.awt.geom.*;
import java.io.*;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class BotData {

    
    public static final char VERSION= 216;

    private String bot= null;

    public static final int MAX_SAMPLES= 25000;

    public static final int RADAR= 2000;
    
	public static final int HEADS= 180;

    private ArrayList interpolated= new ArrayList();

    private ArrayList samplesList= new ArrayList();

    //private ArrayList rounds= new ArrayList();

    private BotScore scorer= null;

    public BotData(String botName) {
        super();
        bot= botName;
        scorer= new BotScore(bot);
        //        AxeBot.getIt().out.println("Creating BotData:" + bot);
    }

    public void reset() {
        scorer= new BotScore(bot);
        interpolated= new ArrayList();
        samplesList= new ArrayList();
        newRound();
    }

    public int getSamplesListSize() {
        return samplesList.size();
    }

    public int getSamplesSize() {
        int sz= 0;
        for (int i= 0; i < samplesList.size(); i++) {

            sz += ((ArrayList) (samplesList.get(i))).size();
        }
        return sz;
    }

    public ArrayList getSamplesList() {
        return samplesList;
        //        Point thisRnd= (Point)rounds.get(rounds.size() - 1);
        //        int thisWide= thisRnd.y - thisRnd.x;
        //        int thisLimit= (thisWide < limit) ? thisWide : limit;
        //        int capacity=
        //            (int) ((samplesList.size()
        //                - ((rounds.size() - 1 * limit) + thisLimit))
        //                * 1.1);
        //        if (capacity < 0) {
        //            return new ArrayList();
        //        }
        //
        //        ArrayList ret= new ArrayList(capacity);
        //        int qtd= rounds.size();
        //        for (int i= 0; i < qtd; i++) {
        //            Point rnds= (Point)rounds.get(i);
        //            int from= rnds.x;
        //            int to=
        //                ((i == (qtd - 1)) ? samplesList.size() : rnds.y + 1) - limit;
        //
        //            if (to > from) {
        //
        //                ret.addAll(samplesList.subList(from, to));
        //            }
        //        }
        //
        //        //getMe().out.println("capacity:" + capacity + " real:" + ret.size());
        //        return ret;
    }

    public void newRound() {

        //        AxeBot.getIt().out.println("BotData new round.");

        //closeRound();

        restrictSamples(MAX_SAMPLES);
        samplesList.ensureCapacity(samplesList.size() + 1000);
        interpolated.ensureCapacity(interpolated.size() + 1000);
        samplesList.add(new ArrayList());
        interpolated.add(new ArrayList());
        scorer.newRound();
        //int sz = samplesList.size();

        //        int sz= samplesList.size();
        //
        //        rounds.add(new Point(sz, 0));
    }

    //    private void closeRound() {
    //
    //        //        AxeBot.getIt().out.println("BotData close round.");
    //
    //        int sz= samplesList.size();
    //        Point p= null;
    //        if (rounds.size() > 0) {
    //            p= ((Point)rounds.get(rounds.size() - 1));
    //            p.setLocation(p.x, (sz - 1));
    //        }
    //        AxeBot.getIt().out.println(
    //            "close round: time:"
    //                + AxeBot.getIt().getTime()
    //                + " interpol:"
    //                + interpolated.size()
    //                + " sapms sz:"
    //                + sz
    //                + " round:"
    //                + p);
    //
    //    }

    //    private void restrictInterpolatedSizes(int to) {
    //        double sampsSz= samplesList.size();
    //        double interSz= interpolated.size();
    //        to= (int) (to * (sampsSz / interSz));
    //        restrictSizes(to);
    //    };

    public void restrictSamples(int to) {

        int c= samplesList.size() - 1;

        if (c < 0) {
            return;
        }

        int samps= 0;
        do {
            samps += ((ArrayList) (samplesList.get(c))).size();
            c--;
        } while ((samps < to) && (c >= 0));

        if (c >= 0) {
            samplesList=
                new ArrayList(samplesList.subList(c + 2, samplesList.size()));
            interpolated=
                new ArrayList(interpolated.subList(c + 2, interpolated.size()));

        }

    }
    
	public void restrictRounds(int to) {

			if (samplesList.size() < to) {
				return;
			}
			
		samplesList=
							new ArrayList(samplesList.subList(samplesList.size()-to, samplesList.size()));
						interpolated=
							new ArrayList(interpolated.subList(interpolated.size()-to, interpolated.size()));

			

		}

    public void restrictInterpolated(int to) {

        int c= interpolated.size() - 1;
        if (c < 0) {
            return;
        }
        int iters= 0;
        do {
            iters += ((ArrayList) (interpolated.get(c))).size();
            c--;
        } while ((iters < to) && (c >= 0));

        if (c >= 0) {
            samplesList=
                new ArrayList(samplesList.subList(c + 2, samplesList.size()));
            interpolated=
                new ArrayList(interpolated.subList(c + 2, interpolated.size()));

        }

    }

    //    private void restrictSizes(int to) {
    //
    //        int sampsSz= samplesList.size();
    //
    //        //        AxeBot.getIt().out.println("restricting to:" + to + " now:" + sampsSz);
    //
    //        if (sampsSz > to) {
    //            //            getMe().out.println(
    //            //                "                                                          ****************           restricting sizes..."
    //            //                    + sampsSz);
    //            int start= 0;
    //            Point first= null;
    //            int szCont= 0;
    //            int here= 0;
    //
    //            //            for (int i= 0; i < rounds.size(); i++) {
    //            //                first= (Point)rounds.get(i);
    //            //                PatternSample smp=
    //            //                    (PatternSample)samplesList.get((int)first.getX());
    //            //                PatternSample smp2=
    //            //                    (PatternSample)samplesList.get((int)first.getY());
    //            //                getMe().out.println(
    //            //                    "samples n."
    //            //                        + i
    //            //                        + " start:"
    //            //                        + first.getX()
    //            //                        + " end:"
    //            //                        + first.getY()
    //            //                        + " i.e.:"
    //            //                        + smp.getPos()
    //            //                        + " - "
    //            //                        + smp2.getPos());
    //            //            }
    //
    //            for (int i= 0; i < rounds.size(); i++) {
    //                first= (Point)rounds.get(i);
    //                here= (int)first.getX();
    //                start= i;
    //                //                getMe().out.println(
    //                //                    "searching samples n."
    //                //                        + i
    //                //                        + " start:"
    //                //                        + first.getX()
    //                //                        + " end:"
    //                //                        + first.getY());
    //                if ((sampsSz - here) < to) {
    //                    break;
    //                }
    //            }
    //
    //            //            getMe().out.println(
    //            //                "restricting sizes... round start:"
    //            //                    + start
    //            //                    + " rounds.size()"
    //            //                    + rounds.size()
    //            //                    + " here:"
    //            //                    + here);
    //
    //            if (first != null) {
    //                PatternSample smp= (PatternSample)samplesList.get(here);
    //
    //                int interpolEdge= smp.getPos();
    //                //                getMe().out.println("samples edge before:" + interpolEdge);
    //                //atualiza a ref. das samples
    //                PatternSample.addErasedPos(interpolEdge);
    //
    //                //                getMe().out.println("samples edge after:" + smp.getPos());
    //
    //                //reduz a lista de samples
    //                //                getMe().out.println(
    //                //                    "samplesList size before:" + samplesList.size());
    //                samplesList=
    //                    new ArrayList(
    //                        samplesList.subList(here, samplesList.size()));
    //                //                getMe().out.println(
    //                //                    "samplesList size after:" + samplesList.size());
    //
    //                //                getMe().out.println(
    //                //                    "InterpolatedData size before:"
    //                //                        + InterpolatedData.get().size());
    //                //reduz a lista de interpolated
    //                //StaticDataCenter.trimFrom(interpolEdge);
    //                interpolated=
    //                    new ArrayList(
    //                        interpolated.subList(
    //                            interpolEdge,
    //                            interpolated.size()));
    //                //                getMe().out.println(
    //                //                    "InterpolatedData size after:"
    //                //                        + InterpolatedData.get().size());
    //
    //                //                getMe().out.println("rounds size before:" + rounds.size());
    //                rounds= new ArrayList(rounds.subList(start, rounds.size()));
    //                //                getMe().out.println("rounds size before:" + rounds.size());
    //
    //                for (int i= 0; i < rounds.size(); i++) {
    //                    Point rnd= (Point)rounds.get(i);
    //                    rnd.setLocation(rnd.getX() - here, rnd.getY() - here);
    //                    //                    getMe().out.println(
    //                    //                        "samples n."
    //                    //                            + i
    //                    //                            + " start:"
    //                    //                            + rnd.getX()
    //                    //                            + " end:"
    //                    //                            + rnd.getY());
    //
    //                }
    //            }
    //
    //        }
    //
    //        //		for (int i= 0; i < rounds.size(); i++) {
    //        //						Point first= (Point)rounds.get(i);
    //        //						PatternSample smp=
    //        //							(PatternSample)samplesList.get((int)first.getX());
    //        //						PatternSample smp2=
    //        //							(PatternSample)samplesList.get((int)first.getY());
    //        //						getMe().out.println(
    //        //							"samples n."
    //        //								+ i
    //        //								+ " start:"
    //        //								+ first.getX()
    //        //								+ " end:"
    //        //								+ first.getY()
    //        //								+ " i.e.:"
    //        //								+ smp.getPos()
    //        //								+ " - "
    //        //								+ smp2.getPos());
    //        //					}
    //    }

    /////////////////////////////////
    ///////////////////////////////// interpolated
    /////////////////////////////////

    public void add(
        double x,
        double y,
        double time,
        double timesDelta,
        double distMe, double headToMe) {

        ArrayList inter= (ArrayList)interpolated.get(interpolated.size() - 1);

        AxeVector last;
        if (inter.size() == 0) {
            last= new AxeVector(x, y);
        } else {
            last= (AxeVector)inter.get(inter.size() - 1);
        }

        double x0= last.getX();
        double y0= last.getY();
        double Dx= x - x0;
        double Dy= y - y0;
        double dx= Dx / timesDelta;
        double dy= Dy / timesDelta;

        AxeVector interpol= null;

        for (int i= 0; i < timesDelta; i++) {
            x0 += dx;
            y0 += dy;
            interpol= new AxeVector(x0, y0); //, tetha, mod);
            inter.add(interpol);
        }

        addSample(headToMe, distMe, (int)timesDelta);
    }

    private void addSample(double headToMe, double distMe, int deltatime) {

        ArrayList inter= (ArrayList)interpolated.get(interpolated.size() - 1);
        ArrayList samples= (ArrayList)samplesList.get(samplesList.size() - 1);

        int iSize= inter.size();
        int sSize= samples.size();

        int maxwid= PatternSample.getMaxWideness();

        //int deltatime= iSize - (sSize+maxwid );

        if (iSize <= maxwid) {
            return;
        }

        for (int j= deltatime; j > 0; j--) {

            int now= iSize - j;
            if (now <= maxwid) {
                continue;
            }
            Point2D.Double p0= ((AxeVector)inter.get(now)).getEndPoint();
            AxeVector samps[]= new AxeVector[PatternSample.GROUPS.length];
            for (int i= 0; i < samps.length; i++) {
                Point2D.Double pf=
                    ((AxeVector)inter.get(now - PatternSample.GROUPS[i]))
                        .getEndPoint();
                samps[i]= new AxeVector(p0, pf);
            }

            try {
                samples.add(new PatternSample(samps, now, distMe,headToMe));
            } catch (AxeException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

    }

    public ArrayList getInterpolated() {
        return interpolated;
    }

//    public void save(DataOutputStream w) throws IOException {
//
//        int size= 1500;
//        int sizeCont= 0;
//
//        //this.closeRound();
//
//        restrictInterpolated(size);
//
//        //        AxeBot.getIt().out.println("Saving BotData.");
//
//        char batw= (char)AxeBot.getIt().getBattleFieldWidth();
//        char bath= (char)AxeBot.getIt().getBattleFieldHeight();
//
//        int maxwid= PatternSample.getMaxWideness();
//
//        int bitLen= OptimizedBitBuffer.countBits(Math.max(batw, bath));
//
//        int radLen= OptimizedBitBuffer.countBits(RADAR);
//
//        w.writeChar(VERSION);
//
//        //        AxeBot.getIt().out.println("    version:" + (int)VERSION);
//
//        w.writeChar(batw);
//
//        //        AxeBot.getIt().out.println("    BATW:" + batw);
//
//        w.writeChar(bath);
//        //        AxeBot.getIt().out.println("    BATH:" + bath);
//
//        //        w.writeChar((char)rounds.size());
//        //        
//        //        
//        //
//        //        for (int i= 0; i < rounds.size(); i++) {
//        //            Point rnd= (Point)rounds.get(i);
//        //            w.writeChar((char)rnd.getX());
//        //            w.writeChar((char)rnd.getY());
//        //            AxeBot.getIt().out.println("Saving BotData. round:" + rnd);
//        //        }
//
//        //int smpCnt= 0;
//
//        w.writeChar((char)interpolated.size());
//
//        AxeBot.getIt().out.println(
//            "    interpolated.size:" + interpolated.size());
//
//        for (int i= 0; i < interpolated.size(); i++) {
//
//            ArrayList interpol= (ArrayList)interpolated.get(i);
//            ArrayList samps= (ArrayList)samplesList.get(i);
//            w.writeInt((int)interpol.size());
//            AxeBot.getIt().out.println(
//                "    interpol.size():" + interpol.size());
//
//            OptimizedBitBuffer buf= new OptimizedBitBuffer();
//
//            //			for (int j= 0; j < 10; j++) {
//            //				
//            //				AxeBot.getIt().out.println(
//            //											"savind index wrong:" + j + "/" + ((PatternSample)(samps.get(j))).getPos());
//            //			}
//
//            for (int j= 0; j < interpol.size(); j++) {
//                sizeCont++;
//                AxeVector vec= (AxeVector)interpol.get(j);
//
//                //Point2D.Double pt= (Point2D.Double)interpol.get(smpCnt);
//                char x= (char)vec.getX();
//                char y= (char)vec.getY();
//
//                //            if (i < 10) {
//                //                AxeBot.getIt().out.println(i + ": " + vec.getEndPoint());
//                //            }
//                //				String dbg = j+":"+(int)x+","+(int)y;
//                buf.add(x, bitLen);
//                buf.add(y, bitLen);
//
//                if (j > maxwid) {
//                    PatternSample ps=
//                        (PatternSample)samps.get(j - (maxwid + 1));
//                    if (ps.getPos() != j) {
//                        AxeBot.getIt().out.println(
//                            "savind index wrong:" + j + "/" + ps.getPos());
//                    }
//                    //                    else {
//                    //						dbg += ","+(int)ps.getDistanceMe();
//                    //                    }
//                    buf.add((char)ps.getDistanceMe(), radLen);
//                }
//                //				if((i==0)&&(j<10)){
//                //                
//                //				AxeBot.getIt().out.println(dbg);
//                //				}
//            }
//            String out= buf.getBuffer();
//            w.writeInt((int)out.length());
//
//            AxeBot.getIt().out.println("    data len:" + out.length());
//
//            //            w.writeChars(out);
//            for (int k= 0; k < out.length(); k++) {
//                w.writeChar(out.charAt(k));
//                //				if (k < 10) {
//                //													AxeBot.getIt().out.println(
//                //														k + ": " + Integer.toBinaryString(out.charAt(k)));
//                //												}
//            }
//
//            //            for (i= 0; i < 10; i++) {
//            //                char in= out.charAt(i);
//            //                AxeBot.getIt().out.println(
//            //                    i + ": " + Integer.toBinaryString(in));
//            //            }
//        }
//        int tot= interpolated.size() * PatternSample.getMaxWideness();
//        tot= (((sizeCont - tot) * 31) + (tot * 20)) / 8;
//        AxeBot.getIt().out.println(
//            "saving interpolateds:" + sizeCont + " bytes:" + tot);
//
//    }

    public void saveCompressed(DataOutputStream w) throws IOException {
		DecimalFormat forma = new DecimalFormat("0.00");
//				String str = "";
        int sizeCont= 0;
        int bh = (int)AxeBot.getIt().getBattleFieldHeight();
        int bw = (int)AxeBot.getIt().getBattleFieldWidth();
        int diagonal = (int)Math.ceil(Math.sqrt((bh*bh)+(bw*bw)));
		int head = RoboMath.countBits( HEADS );
        
        int radar = RoboMath.countBits( Math.min( RADAR, diagonal));
        
		restrictRounds(1);

        char batw= (char)AxeBot.getIt().getBattleFieldWidth();
        char bath= (char)AxeBot.getIt().getBattleFieldHeight();

        int maxwid= PatternSample.getMaxWideness();

        int bitLen= RoboMath.countBits(Math.max(batw, bath));

        int radLen= radar;
        
//		AxeBot.getIt().out.println("    radLen:" + radLen + " diagonal:"+diagonal);

        w.writeChar(VERSION);

        w.writeChar(batw);

        w.writeChar(bath);

        w.writeChar((char)interpolated.size());

        AxeBot.getIt().out.println(
            "    interpolated.size:" + interpolated.size());

        for (int i= 0; i < interpolated.size(); i++) {
            AxeVector ante= null;
            AxeVector este= null;
            ArrayList interpol= (ArrayList)interpolated.get(i);
            ArrayList samps= (ArrayList)samplesList.get(i);
            w.writeInt((int)interpol.size());
            AxeBot.getIt().out.println(
                "    interpol.size():" + interpol.size());

            OptimizedBitBuffer buf= new OptimizedBitBuffer();

            for (int j= 0; j < interpol.size(); j++) {
                este= (AxeVector)interpol.get(j);
                sizeCont++;
                AxeVector vec= (AxeVector)este.clone();
//                str = j+":";
                if (ante == null) {
                    char x= (char)este.getX();
                    char y= (char)este.getY();
                    buf.add(x, bitLen);
                    buf.add(y, bitLen);
//                    str += (int)x+","+(int)y;
                } else {
                    vec.setOrigin(ante.getEndPoint());

                    try {
                    	double dx = vec.getDX();
						double dy = vec.getDY();
                        buf.addCoded(7, dx, 112, -8, 8);
                        buf.addCoded(7, dy, 112, -8, 8);
//						str += forma.format(dx)+";"+forma.format(dy);
                    } catch (AxeException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }

                }

                ante= este;

                if (j > maxwid) {
                    PatternSample ps=
                        (PatternSample)samps.get(j - (maxwid + 1));
                    if (ps.getPos() != j) {
                        AxeBot.getIt().out.println(
                            "savind index wrong:" + j + "/" + ps.getPos());
                    }
                    buf.add((char)ps.getDistanceMe(), radLen);
					buf.add((char)ps.getHeadToMe(), head);
//                    str += (int)ps.getDistanceMe();
                }
//				AxeBot.getIt().out.println(str);
            }
            String out= buf.getBuffer();
            w.writeInt((int)out.length());

            AxeBot.getIt().out.println("    data len:" + out.length());

            //            w.writeChars(out);
            for (int k= 0; k < out.length(); k++) {
                w.writeChar(out.charAt(k));
            }

        }
        int tot= interpolated.size() * PatternSample.getMaxWideness();
        tot= (((sizeCont - tot) * 31) + (tot * 20)) / 8;
        AxeBot.getIt().out.println(
            "saving interpolateds:" + sizeCont + " bytes:" + tot);

    }

    public void loadCompressed(DataInputStream r) throws IOException {
		DecimalFormat forma = new DecimalFormat("0.00");
//		String str = "";
		int bh = (int)AxeBot.getIt().getBattleFieldHeight();
				int bw = (int)AxeBot.getIt().getBattleFieldWidth();
				int diagonal = (int)Math.ceil(Math.sqrt((bh*bh)+(bw*bw)));
        
				int radar = RoboMath.countBits( Math.min( RADAR, diagonal));
		int head = RoboMath.countBits( HEADS );
        
		
		
        char version= r.readChar();

        //        AxeBot.getIt().out.println("    version:" + (int)VERSION);

        if (version != VERSION) {
            throw new IOException(
                "wrong version:" + (int)version + "/" + (int)VERSION);
        }

        char batw= r.readChar();

        char bath= r.readChar();

        //        AxeBot.getIt().out.println("    BATW:" + batw);

        //        AxeBot.getIt().out.println("    BATH:" + bath);

        int maxwid= PatternSample.getMaxWideness();

        if ((batw != AxeBot.getIt().getBattleFieldWidth())
            || (bath != AxeBot.getIt().getBattleFieldHeight())) {
            throw new IOException(
                "fields don't match: "
                    + batw
                    + "X"
                    + bath
                    + " / "
                    + AxeBot.getIt().getBattleFieldWidth()
                    + "X"
                    + AxeBot.getIt().getBattleFieldHeight());
        }

        int bitLen= RoboMath.countBits(Math.max(batw, bath));

        //int radLen= RoboMath.countBits(RADAR);

        int rnds= r.readChar();

        //        AxeBot.getIt().out.println("    rounds(interpolated.size):" + rnds);

        //        Point rnd= null;
        //        AxeBot.getIt().out.println("Loading BotData. rounds:" + rnds);
        //        for (int i= 0; i < rnds; i++) {
        //            rnd= new Point(r.readChar(), r.readChar());
        //            rounds.add(rnd);
        //            AxeBot.getIt().out.println("Loading BotData. round:" + rnd);
        //        }
        int inRound= 0;

        for (int i= 0; i < rnds; i++) {
            int sz= r.readInt();

            //            AxeBot.getIt().out.println("    interpol.size):" + sz);

            //rnd= (Point)rounds.get(0);
            int time= 0;

            //AxeBot.getIt().out.println("interpolated:" + interpolated.size());

            int strSz= r.readInt();

            //            AxeBot.getIt().out.println("    data size):" + strSz);

            StringBuffer inbuf= new StringBuffer(strSz);

            for (int k= 0; k < strSz; k++) {
                char in= r.readChar();
                //                                if (k < 10) {
                //                                    AxeBot.getIt().out.println(
                //                                        k + ": " + Integer.toBinaryString(in));
                //                                }
                inbuf.append(in);
            }
            OptimizedBitBuffer buf= new OptimizedBitBuffer();
            buf.setBuffer(inbuf.toString());

            ArrayList interpol=
                (ArrayList)interpolated.get(interpolated.size() - 1);

            AxeVector ante= null;
            AxeVector este= null;

            for (int j= 0; j < sz; j++) {
//                str = j+":";
                if (ante == null) {
					int x= buf.get(bitLen);
				 	int y= buf.get(bitLen);
					este= new AxeVector(x, y);
//					str += (int)x+";"+(int)y;
                } else {
                    
                    double dx=0;
					double dy=0;
                    try {
                        dx= buf.getCoded(7,112, -8, 8);
						dy = buf.getCoded(7,112, -8, 8);
                    } catch (AxeException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
//					str += forma.format(dx)+";"+forma.format(dy);
					este= new AxeVector(ante.getX()+dx, ante.getY()+dy);
                }

                ante= este;
                
                interpol.add(este);

                if (j > maxwid) {

                    int d= buf.get(radar);
					int h= buf.get(head);
						

                    this.addSample(h, d, 1);
                }
//				AxeBot.getIt().out.println(str);
                
            }
            this.newRound();
        }
    }

//    public void load(DataInputStream r) throws IOException {
//
//        char version= r.readChar();
//
//        //        AxeBot.getIt().out.println("    version:" + (int)VERSION);
//
//        if (version != VERSION) {
//            throw new IOException(
//                "wrong version:" + (int)version + "/" + (int)VERSION);
//        }
//
//        char batw= r.readChar();
//
//        char bath= r.readChar();
//
//        //        AxeBot.getIt().out.println("    BATW:" + batw);
//
//        //        AxeBot.getIt().out.println("    BATH:" + bath);
//
//        int maxwid= PatternSample.getMaxWideness();
//
//        if ((batw != AxeBot.getIt().getBattleFieldWidth())
//            || (bath != AxeBot.getIt().getBattleFieldHeight())) {
//            throw new IOException(
//                "fields don't match: "
//                    + batw
//                    + "X"
//                    + bath
//                    + " / "
//                    + AxeBot.getIt().getBattleFieldWidth()
//                    + "X"
//                    + AxeBot.getIt().getBattleFieldHeight());
//        }
//
//        int bitLen= OptimizedBitBuffer.countBits(Math.max(batw, bath));
//
//        int radLen= OptimizedBitBuffer.countBits(RADAR);
//
//        int rnds= r.readChar();
//
//        //        AxeBot.getIt().out.println("    rounds(interpolated.size):" + rnds);
//
//        //        Point rnd= null;
//        //        AxeBot.getIt().out.println("Loading BotData. rounds:" + rnds);
//        //        for (int i= 0; i < rnds; i++) {
//        //            rnd= new Point(r.readChar(), r.readChar());
//        //            rounds.add(rnd);
//        //            AxeBot.getIt().out.println("Loading BotData. round:" + rnd);
//        //        }
//        int inRound= 0;
//
//        for (int i= 0; i < rnds; i++) {
//            int sz= r.readInt();
//
//            //            AxeBot.getIt().out.println("    interpol.size):" + sz);
//
//            //rnd= (Point)rounds.get(0);
//            int time= 0;
//
//            //AxeBot.getIt().out.println("interpolated:" + interpolated.size());
//
//            int strSz= r.readInt();
//
//            //            AxeBot.getIt().out.println("    data size):" + strSz);
//
//            StringBuffer inbuf= new StringBuffer(strSz);
//
//            for (int k= 0; k < strSz; k++) {
//                char in= r.readChar();
//                //                                if (k < 10) {
//                //                                    AxeBot.getIt().out.println(
//                //                                        k + ": " + Integer.toBinaryString(in));
//                //                                }
//                inbuf.append(in);
//            }
//            OptimizedBitBuffer buf= new OptimizedBitBuffer();
//            buf.setBuffer(inbuf.toString());
//
//            ArrayList interpol=
//                (ArrayList)interpolated.get(interpolated.size() - 1);
//
//            for (int j= 0; j < sz; j++) {
//
//                int x= buf.get(bitLen);
//                int y= buf.get(bitLen);
//                //				String dbg = j+":"+x+","+y;
//                AxeVector vec= new AxeVector(x, y);
//                interpol.add(vec);
//                //                rnd= (Point)rounds.get(inRound);
//
//                //                if (j < 10) {
//                //                    AxeBot.getIt().out.println(j + ": " + vec.getEndPoint());
//                //                }
//
//                if (j > maxwid) {
//
//                    int d= buf.get(radLen);
//                    //                    dbg += ","+d;
//                    //                    AxeBot.getIt().out.println("ld ind:" + j + ":" + d);
//
//                    this.addSample(d, 1);
//                }
//                //                if((i==0)&&(j<10)){
//                //                
//                //				AxeBot.getIt().out.println(dbg);
//                //                }
//
//                //                int sampsSz= this.getSamplesListSize();
//                //                if ((sampsSz > rnd.x) && (sampsSz > rnd.y)) {
//                //                    inRound++;
//                //                    AxeBot.getIt().out.println(
//                //                        "Loading BotData. new round:" + (time + rnd.x));
//                //                    time= 0;
//                //
//                //                }
//                //time++;
//                //this.addSample(time, 1, r.readChar());
//            }
//            this.newRound();
//        }
//        //        AxeBot.getIt().out.println("interpolated:" + interpolated.size());
//        //        AxeBot.getIt().out.println(
//        //            "getSamplesListSize:" + getSamplesListSize());
//        //PatternSample.setErasedPos(-1*interpolated.size() );
//    }

    //	public void save(DataOutputStream w) throws IOException {
    //
    //			int size = 2000;
    //			int sizeCont = 0;
    //
    //			this.closeRound();
    //
    //			restrictInterpolatedSizes(size);
    //
    //			AxeBot.getIt().out.println(
    //				"Saving BotData. interpolated:"
    //					+ interpolated.size()
    //					+ " rounds:"
    //					+ rounds.size());
    //
    //	char batw = (char)AxeBot.getIt().getBattleFieldWidth();
    //	char bath = (char)AxeBot.getIt().getBattleFieldHeight();
    //
    //			int bitLen = OptimizedBitBuffer.countBits(Math.max(batw, bath));
    //
    ////			w.writeChar(batw);
    ////			w.writeChar(bath);
    //
    //			w.writeChar((char)rounds.size());
    //
    //			for (int i = 0; i < rounds.size(); i++) {
    //				Point rnd = (Point)rounds.get(i);
    //				w.writeChar((char)rnd.getX());
    //				w.writeChar((char)rnd.getY());
    //				AxeBot.getIt().out.println("Saving BotData. round:" + rnd);
    //			}
    //
    //			int smpCnt = 0;
    //        
    //			w.writeInt((int)interpolated.size());
    //		
    //			OptimizedBitBuffer buf = new OptimizedBitBuffer(); 
    //
    //			for (int i = 0; i < interpolated.size(); i++) {
    //				AxeVector vec = (AxeVector)interpolated.get(i);
    //				PatternSample ps = (PatternSample)samplesList.get(smpCnt);
    //				char x = (char)vec.getX();
    //				char y = (char)vec.getY();
    //            
    //				//buf.add(x, bits)
    //				w.writeChar(x);
    //				w.writeChar(y);
    //				if (ps.getPos() == i) {
    //					smpCnt++;
    //					w.writeChar((char)ps.getDistanceMe());
    //				} 
    //			}
    //		}
    //
    //		public void load(DataInputStream r) throws IOException {
    //
    //			int rnds = r.readChar();
    //			Point rnd = null;
    //			AxeBot.getIt().out.println(
    //						"Loading BotData. rounds:"
    //							+ rnds);
    //			for (int i = 0; i < rnds; i++) {
    //				rnd = new Point(r.readChar(), r.readChar());
    //				rounds.add(rnd);
    //				AxeBot.getIt().out.println("Loading BotData. round:" + rnd);
    //			}
    //			int inRound = 0;
    //			int sz = r.readInt();
    //			rnd = (Point)rounds.get(0);
    //			int time = 0;
    //        
    //			AxeBot.getIt().out.println("interpolated:" + interpolated.size());
    //        
    //			for (int i = 0; i < sz; i++) {
    //				AxeVector vec = new AxeVector(r.readChar(), r.readChar());
    //				interpolated.add(vec);
    //				rnd = (Point)rounds.get(inRound);
    //            
    //				time++;
    //				if (time > PatternSample.getMaxWideness()) {
    //					this.addSample(time, 1, r.readChar());
    //				}
    //			
    //				int sampsSz = this.getSamplesListSize(); 
    //				if ((sampsSz > rnd.x) && (sampsSz > rnd.y)) {
    //					inRound++;
    //					AxeBot.getIt().out.println("Loading BotData. new round:" + (time+rnd.x));
    //					time = 0;
    //				
    //				}
    //				//time++;
    //				//this.addSample(time, 1, r.readChar());
    //			}
    //			//PatternSample.setErasedPos(-1*interpolated.size() );
    //		}

    /**
     * @return
     */
    public BotScore getScorer() {
        return scorer;
    }

}
