package pez.rumble.utils;
import robocode.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;

// Wave, base class for custom event (PEZ style) stat gathering wave. By PEZ.
// http://robowiki.net/?PEZ
//
// This code is released under the RoboWiki Public Code Licence (RWPCL), datailed on:
// http://robowiki.net/?RWPCL
// (Basically it means you must keep the code public if you use it in any way.)
//
// $Id: Wave.java,v 1.10 2004/09/27 23:00:14 peter Exp $

public abstract class Wave {
    static protected AdvancedRobot robot;
    protected int numBins;
    protected int middleBin;
    protected double bulletVelocity;
    protected double distanceFromGun;
    protected double startBearing;
    protected double bearingDirection;
    protected Point2D gunLocation;
    protected Point2D targetLocation;
    protected long startTime;

    public void init(AdvancedRobot robot, int numBins) {
	this.robot = robot;
	this.numBins = numBins;
	this.middleBin = (numBins - 1) / 2;
    }
    
    public boolean passed(double distanceOffset) {
	return distanceFromTarget() < distanceOffset;
    }

    public void advance(int ticks) {
	distanceFromGun += ticks * bulletVelocity;
    }

    public int visitingIndex() {
	return visitingIndex(targetLocation);
    }

    public int visitingIndex(Point2D location) {
	return visitingIndex(PUtils.absoluteBearing(gunLocation, location));
    }

    public int visitingIndex(double bearing) {
	return (int)PUtils.minMax(
	    Math.round(((Utils.normalRelativeAngle(bearing - startBearing)) / bearingDirection) + middleBin), 1, numBins - 1);
    }

    public double maxEscapeAngle() {
	return PUtils.maxEscapeAngle(bulletVelocity);
    }

    public double gunBearing(Point2D target) {
	return PUtils.absoluteBearing(gunLocation, target);
    }

    public double distanceFromTarget(Point2D location, int timeOffset) {
	return gunLocation.distance(location) - distanceFromGun - (double)timeOffset * bulletVelocity;
    }

    public double distanceFromTarget(int timeOffset) {
	return distanceFromTarget(targetLocation, timeOffset);
    }

    public double distanceFromTarget(Point2D location) {
	return distanceFromTarget(location, 0);
    }

    public double distanceFromTarget() {
	return distanceFromTarget(0);
    }

    public void setStartTime(long time) {
	this.startTime = time - 1;
    }

    public double getStartTime() {
	return this.startTime;
    }

    public void setDistanceFromGun(double distance) {
	this.distanceFromGun = distance;
    }

    public double distanceFromGun() {
	return this.distanceFromGun;
    }

    public double travelTime(double distance) {
	return distance / bulletVelocity;
    }

    public double travelTime() {
	return distanceFromTarget(0) / bulletVelocity;
    }

    public double getFireDistance() {
	return gunLocation.distance(targetLocation);
    }

    public AdvancedRobot getRobot() {
	return robot;
    }

    public Point2D getGunLocation() {
	return gunLocation;
    }

    public void setBulletVelocity(double bulletVelocity) {
	this.bulletVelocity = bulletVelocity;
    }

    public double getBulletVelocity() {
	return this.bulletVelocity;
    }

    public void setStartBearing(double startBearing) {
	this.startBearing = startBearing;
    }

    public double getStartBearing() {
	return this.startBearing;
    }

    public void setOrbitDirection(double bearingDirection) {
	this.bearingDirection = bearingDirection;
    }
    
    public double getOrbitDirection() {
	return this.bearingDirection;
    }

    public double getGF(Point2D location) {
	return Utils.normalRelativeAngle(PUtils.absoluteBearing(gunLocation, location) - startBearing);
    }

    public void setGunLocation(Point2D gunLocation) {
	this.gunLocation = gunLocation;
    }

    public void setTargetLocation(Point2D targetLocation) {
	this.targetLocation = targetLocation;
    }

    public int botWidth() {
	return (int)Math.ceil(middleBin * PUtils.botWidthAngle(getFireDistance() / maxEscapeAngle()));
    }

    public int wallIndex(double direction, int indexes, double indexWidth, Rectangle2D fieldRectangle) {
	double index = 0;
	do {
	} while (++index < indexes &&
		fieldRectangle.contains(PUtils.project(gunLocation,
			startBearing + direction * bearingDirection * index * indexWidth, distanceFromTarget())));
	return (int)(index - 1);
    }
}
