/*
 * Created on 2004-9-25
 */
package tide.pear;

import tide.EventListener;
import tide.Robot;
import tide.RobotConsole;

/**
 * Techniques and implementation are me and iiley, but I have borrowed from
 * many places too. 

 * Many thanks to PEZ, Jim, Kawigi, Jamougha, Axe, ABC, rozu, Kuuran, FnH,
 * nano and many others who have helped us or opened their idea on robowiki.
 * Tide robot
 * @author xiemin
 */
public class Pear extends Robot
{
	private static BulletAnalyzer bulletAnalyzer;
	private static BotInfoRecorder recorder;
	/* (non-Javadoc)
	 * @see framework.Robot#initListeners()
	 */
	public void initListeners()
	{   
		//tools
		addListener(getBotInfoRecorder());
		
		addListener( (EventListener)getBulletAnalyzer());
		
		//radar
		addListener(new RadarController(getConsole()));
		
		
		//gun
		//addListener(new TestGunListener(getConsole()));
		StatistGun statistGun = new StatistGun(getConsole());
		addListener(statistGun);
		
		//NNGun nnGun = new NNGun(getConsole());
		//addListener(nnGun);
		
		//StatistFastGun fastGun = new StatistFastGun(getConsole());
		//addListener(fastGun);
		
		MultGunController gun = new MultGunController(getConsole());
		gun.addStrategy(statistGun);
		//gun.addStrategy(fastGun);
		//gun.addStrategy(nnGun);
		addListener(gun);
		
		
		
		//movement 
		//addListener(new MobileController(getConsole()));
		addListener(new WaveSurferMove2(getConsole()));
		
		//others
		//addListener(new BulletPainter(getConsole()));
	}
	
	public static BulletAnalyzer getBulletAnalyzer()
	{
		if( bulletAnalyzer == null )
			bulletAnalyzer = new StatistEnemyFireAnalyzer(getConsole());
		return bulletAnalyzer;
	}
	
	public static BotInfoRecorder getBotInfoRecorder(){
		if( recorder == null )
			recorder = new BotInfoRecorder(getConsole());
		return recorder;
	}
	
	public static void log(String str){
		getConsole().println(getConsole().getTime() + ":" + str);
	}
	
	public static RobotConsole staticGetConsole(){
		return getConsole();
	}
}
