/*
 * Created on 2004-9-27
 */
package tide.pear;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

import tide.EventListener;
import tide.HitWallEvent;
import tide.OvertimeEvent;
import tide.RobotConsole;
import tide.ScannedRobotEvent;
import tide.pear.statistic.BasicStatist;
import tide.util.BotInfo;
import tide.util.MathUtils;
import tide.util.Wave;

/**
 * Wave Surfering Movement
 * Work well in robocode,maybe not very cerrect in airobot
 * @author iiley(Chen Jing)
 */
public class WaveSurferMove2 extends EventListener {

	private static final double MAX_VELOCITY     = 8d; 
	
	private Rectangle2D.Double field;
	private List    waves;
	private Point2D enemyPos;
	private BotInfo enemyInfo;
	private BotInfo myInfo;
	private Point2D myPos;
	private String  enemyName;
	private double keepDistanceToWall = 18.1d;
	private double useVelocity        = 8d;
	private double seachDistance      = 180d;
	private double preferDistance     = 700d;
	
	private BulletForceAnalyzer bulletForceAnalyzer;
	
	private int hitWallTimes;
	private int skipTimes;
	
	/**
	 * @param console
	 */
	public WaveSurferMove2(RobotConsole console) {
		super(console);		
		field = new Rectangle2D.Double(keepDistanceToWall, keepDistanceToWall,
				console.getMapWidth() - keepDistanceToWall*2,
				console.getMapHeight() - keepDistanceToWall*2);
		bulletForceAnalyzer = new BulletForceAnalyzer();
	}
	

	
	/* (non-Javadoc)
	 * @see bridge.EventListener#onRoundBegin()
	 */
	public void onRoundBegin() {
		Pear.log("Hit Wall Time : " + hitWallTimes);
		Pear.log("Skip Time : " + skipTimes);
	}
	/* (non-Javadoc)
	 * @see bridge.EventListener#onWork()
	 */
	public void onWork() {
		if(enemyName == null){
			return;
		}
		enemyInfo = Pear.getBotInfoRecorder().getBotInfoManager().getInfoMustHaveOne(enemyName, console.getTime());
		myInfo = Pear.getBotInfoRecorder().getBotInfoManager().getInfoMustHaveOne(console.getName()+enemyName, console.getTime());
		enemyPos = enemyInfo.getLocation();
		myPos = new Point2D.Double(console.getX(), console.getY());
		waves = Pear.getBulletAnalyzer().getWaves();
		move();
		//Pear.log("my dir : " + myInfo.getDirection());
	}
	
	public void onScannedRobot(ScannedRobotEvent event) {
		if(enemyName == null){
			enemyName = event.getName();
		}
	}

	/**
	 * wave surfering move,should call this every ticks.
	 */
	private void move(){
		long time = console.getTime();
		long moveTime = -100;
		Wave nearestWave = null;
		for(int i=0; i<waves.size(); i++){
			Wave wave = (Wave)waves.get(i);
			long remainTime = wave.getRemainTime(time, myPos);
			if(remainTime > 0 && (remainTime < moveTime || moveTime< -90)){
				moveTime = remainTime;
				nearestWave = wave;
			}
		}
		
		Point2D moveCenter = (nearestWave == null) ? enemyPos : nearestWave
				.getStartPosition();
		moveCenter = enemyPos;
		double positiveDanger = 0;
		double negativeDanger = 0;
		double stopDanger     = 0;

		Point2D positivePos = new Point2D.Double();
		Point2D negativePos = new Point2D.Double();
		
		for(int i=0; i<waves.size(); i++){
			Wave wave = (Wave)waves.get(i);
			waveImpactLocation(wave, moveCenter, positivePos, negativePos);
			positiveDanger += getFactor(positivePos, wave);
			negativeDanger += getFactor(negativePos, wave);
			stopDanger     += getFactor(myPos, wave);
		}
		
		boolean antiRam = false;
		if(enemyPos.distance(myPos) < 200 && enemyInfo.getCloseVelocity() < -7.4){
			//Pear.log("close : " + enemyInfo.getCloseVelocity());
			antiRam = true;
		}		
		if(enemyPos.distance(myPos) < 130 || console.getTime()<20){
			escape();
			return;
		}
		//Pear.log("----new danger--------");
		//Pear.log("positiveDanger:"+ positiveDanger);
		//Pear.log("negativeDanger:"+ negativeDanger);
		//Pear.log("stopDanger:"+ stopDanger);
		
		if(enemyPos.distance(myPos) < 450 || waves.size()<=0){
			Wave enemyW = new Wave(new BasicStatist(1,1), enemyPos, 3, 1d, 0, time - 
					Math.max(8, Math.min((long)Math.ceil(enemyPos.distance(myPos)/11), 15)));
			waveImpactLocation(enemyW, moveCenter, positivePos, negativePos);
			double distWeigh = antiRam ? 100d : 100d;
			positiveDanger += distWeigh/Math.pow(enemyPos.distance(positivePos)-36, 2);
			negativeDanger += distWeigh/Math.pow(enemyPos.distance(negativePos)-36, 2);
			stopDanger     += distWeigh/Math.pow(enemyPos.distance(myPos)-36, 2);
		}
			//Pear.log("----d------------");
			//Pear.log("positiveDanger:"+ positiveDanger);
			//Pear.log("negativeDanger:"+ negativeDanger);
			//Pear.log("stopDanger:"+ stopDanger);
		double dir = 1;
		if(stopDanger < positiveDanger && stopDanger < negativeDanger){
			dir = 0;
		}else if(positiveDanger < negativeDanger){
			dir = 1;
		}else{
			dir = -1;
		}
		double heading = console.getHeading();
		if(dir == 0){
			console.turn(MathUtils.anglePI(enemyInfo.getAbsBearing() - Math.PI/2d - heading));
			console.move(0);
		} else {
			Point2D nextPos = new Point2D.Double();
			nextPos.setLocation(myPos);
			Point2D moveInfo = nextMovePos(moveCenter, nextPos, dir, heading,
					dir > 0 ? 8d : -8d);
			console.turn(MathUtils.anglePI(moveInfo.getX() - heading));
			console.move(moveInfo.getY());
			if(antiRam)
				console.move(moveInfo.getY()>0 ? 8:-8);
		}
	}
	private void escape(){
		Point2D destP = MathUtils.nextPoint(myPos, myInfo.getAbsBearing(), seachDistance);
		if (!field.contains(destP)) {
			Point2D destLP, destRP;
			destLP = destRP = destP;
			for (int i = 0; i < 90; i+=2) {
				destLP = MathUtils.nextPoint(myPos, myInfo.getAbsBearing()
						+ Math.toRadians(i), seachDistance);
				destRP = MathUtils.nextPoint(myPos, myInfo.getAbsBearing()
						- Math.toRadians(i), seachDistance);
				if (field.contains(destLP)) {
					destP = destLP;
					break;
				}else if(field.contains(destRP)) {
					destP = destRP;
					break;
				}
			}
			if (!field.contains(destP)) {
				if(enemyPos.distance(destLP) > enemyPos.distance(destRP)){
					destP = destLP;
				}else{
					destP = destRP;
				}
			}
		}
		moveTo(destP);
	}
	private void moveTo(Point2D pos){
		double needTurn = MathUtils.anglePI(MathUtils.heading(myPos, pos) - console.getHeading());
		double dir = 1d;
		if(Math.abs(needTurn) > Math.PI/2d){
			dir = -1d;
			needTurn = MathUtils.anglePI(MathUtils.heading(myPos, pos) + Math.PI - console.getHeading());
		}
		console.turn(needTurn);
		console.move(dir*maxMoveVelocity(needTurn));
	}
	private void waveImpactLocation(Wave wave, Point2D moveCenter, Point2D positivePos, Point2D negativePos){
		positivePos.setLocation(myPos);
		negativePos.setLocation(myPos);

		double positiveVelocity = console.getVelocity();
		double negativeVelocity = console.getVelocity();

		Point2D pHeadVel = new Point2D.Double(console.getHeading(), positiveVelocity);
		Point2D nHeadVel = new Point2D.Double(console.getHeading(), negativeVelocity);
		int i = 0;
		long time = console.getTime();
		do{
			i++;
			double positiveRemainTime = wave.getRemainTime(time+i, positivePos);
			if (positiveRemainTime >= 0) {
				if (positiveVelocity >= 0d) {
					positiveVelocity = Math.min(MAX_VELOCITY,
							positiveVelocity + 1);
				} else {
					positiveVelocity = Math.min(0.1d, positiveVelocity + 2);
				}
				pHeadVel = nextMovePos(moveCenter, positivePos, 1d, pHeadVel
						.getX(), positiveVelocity);
				positiveVelocity = pHeadVel.getY();
			}
			
			double negativeRemainTime = wave.getRemainTime(time+i, negativePos);
			if (negativeRemainTime >= 0) {
				if (negativeVelocity > 0d) {
					negativeVelocity = Math.max(-0.1d, negativeVelocity - 2);
				} else {
					negativeVelocity = Math.max(-MAX_VELOCITY,
							negativeVelocity - 1);
				}
				nHeadVel = nextMovePos(moveCenter, negativePos, -1d, nHeadVel
						.getX(), negativeVelocity);
				negativeVelocity = nHeadVel.getY();
			}
			if(positiveRemainTime < 0 && negativeRemainTime < 0 ){
				break;
			}
		}while(true);
	}
		
	private boolean isClose(){
		return enemyPos.distance(myPos) < 300 && enemyInfo.getCloseVelocity()<-7d || enemyPos.distance(myPos)<150;
	}
	
	
	private double maxMoveVelocity(double needTurn){
		return Math.min(145d/Math.abs(Math.toDegrees(needTurn)), MAX_VELOCITY);
	}
	
	private double getFactor(Point2D pos){
		long time = console.getTime();
		double force = 0;
		for(int i=0; i<waves.size(); i++){
			Wave wave = (Wave)waves.get(i);
			force += bulletForceAnalyzer.getForce(myPos, pos, wave, time);
		}
		return force;
	}
	private double getFactor(Point2D pos, Wave wave){
		long time = console.getTime();
		return bulletForceAnalyzer.getForce(myPos, pos, wave, time);
	}
	/**
	 * In this move pattern,it will move to the next position.
	 * @param centerPos move around a point,the position of the point
	 * @param currentPos robot's current position,when the method return,it be the next pos to move
	 * @param vel move velocity,velocity > 0 means unclockwish around centerPos, velocity<0 means clockwish
	 * @return the point.x be the new heading, point.y be the new velocity
	 */
	private Point2D nextMovePos(Point2D centerPos, Point2D currentPos, double dir, double nowHeading, double vel){
		Point2D tempPos = new Point2D.Double();
		tempPos.setLocation(currentPos);

		double testDistance = dir*seachDistance;
		double needTurn = 0;
		
		double distanceToCenter = currentPos.distance(centerPos);
		double deltaAngle = dir*( 2d / 180d * Math.PI)*Math.pow((preferDistance/distanceToCenter), 2d);
		
		double minHeading = MathUtils.anglePI(MathUtils.heading(centerPos, tempPos) + Math.PI/2d - deltaAngle);
		Point2D nextPos = MathUtils.nextPoint(tempPos, minHeading, testDistance);
		while(!field.contains(nextPos) && Math.abs(needTurn) < 2*Math.PI){
			needTurn += dir * (2d / 180d * Math.PI);
			nextPos = MathUtils.nextPoint(tempPos, minHeading + needTurn, testDistance);
		}
		Point2D np = MathUtils.nextPoint(tempPos, minHeading + needTurn, vel);
		
		double turnHeading = 0;
		if(dir > 0){
			turnHeading = MathUtils.anglePI(MathUtils.heading(currentPos, np) - nowHeading);
		}else{
			turnHeading = MathUtils.anglePI(MathUtils.heading(currentPos, np) + Math.PI - nowHeading);
		}
		double canTurn = turnHeading;
		if(Math.abs(canTurn) > Math.toRadians(10d)){
			canTurn = canTurn > 0 ? Math.toRadians(10d) : -Math.toRadians(10d);
		}
		double maxVelocity = maxMoveVelocity(turnHeading);
		if(Math.abs(vel) > maxVelocity){
			vel = vel > 0 ? maxVelocity : -maxVelocity;
		}
		np = MathUtils.nextPoint(tempPos, nowHeading + canTurn, vel);
		currentPos.setLocation(np);
		return new Point2D.Double(nowHeading + canTurn, vel);
	}	
	
	/* (non-Javadoc)
	 * @see tide.EventListener#onOvertime(tide.OvertimeEvent)
	 */
	public void onOvertime(OvertimeEvent event) {
		skipTimes++;
		Pear.log("Over Time : " + skipTimes);
	}
	
	
	/* (non-Javadoc)
	 * @see tide.EventListener#onHitWall(tide.HitWallEvent)
	 */
	public void onHitWall(HitWallEvent event) {
		hitWallTimes++;
		Pear.log("Hit Wall Time : " + hitWallTimes);
	}
}
