/*
 * Created on 2004-6-2
 */
package tide.util;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

/**
 * Math Utils
 */
public class MathUtils
{
	/**
	 * 2 PI
	 */
	public static final double DOUBLE_PI=Math.PI*2;
    
    /**
     * return the angle from 0 to 360
     */    
    public static double angle360(double angle){
    	angle %= 360;
    	if(angle < 0){
        	angle += 360;
    	}
    	return angle;
    }
    
    /**
     * return the angle from 0 to PI
     */    
    public static double angleDoublePI(double angle){
    	angle %= DOUBLE_PI;
    	if(angle < 0){
        	angle += DOUBLE_PI;
    	}
    	return angle;
    }
    
    /**
     * return the angle from -PI to PI
     */
	public static double anglePI( double ang ) {	
		return Math.atan2( Math.sin( ang ), Math.cos( ang ) );
	}
		
	/**
	 * return the distance between (x1,y1) to (x2,y2)
	 */ 
	public static double distance(double x1, double y1, double x2, double y2)
	{
		return Point2D.distance(x1, y1, x2, y2);
	}

	/**
	 * return the distance between pi to p2
	 */ 
	public static double distance(Point2D p1, Point2D p2)
	{
		return Point2D.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
	}
	
	/**
	 * return the heading from (x1,y1) to (x2,y2)
	 */
	public static double heading(double x1, double y1, double x2, double y2)
	{
		return Math.atan2(y2-y1, x2-x1);
	}
	
	/**
	 * return the heading from p1 to p2
	 */
	public static double heading(Point2D p1, Point2D p2){
		return heading(p1.getX(), p1.getY(), p2.getX(), p2.getY());
	}

	/**
	 * return the bearing of heading relative base
	 */
	public static double bearing(double heading, double base)
	{
		return anglePI( anglePI(heading) - anglePI(base));
	}
    	
	/**
	 * Return the absolutely bearing of the two heading
	 * return bearing 0<=bearing<=PI
	 */
	public static double absBearing(double heading1, double heading2)
	{
		return Math.abs(bearing(heading1,heading2));
	}
	
	/**
	 * return the position what angle heading distance to originPoint
	 */
	public static Point2D.Double nextPoint(Point2D originPoint, double angle, double distance){
		return new Point2D.Double(originPoint.getX()+Math.cos(angle)*distance, originPoint.getY()+Math.sin(angle)*distance);
	}	
	
    /**
     * return the cross point of l1 and l2
     * (this method's result is not very accurate)
     */
    public static Point2D.Double crossPoint(Line2D l1, Line2D l2){
	    double a1, b1, a2, b2, x, y;
		double x11, y11, x12, y12, x21, y21, x22, y22;
		x11 = l1.getX1();
		y11 = l1.getY1();
		x12 = l1.getX2();
		y12 = l1.getY2();

		x21 = l2.getX1();
		y21 = l2.getY1();
		x22 = l2.getX2();
		y22 = l2.getY2();
        
		double addNaN = 0.00000000001;
	    a1 = (y11-y12+addNaN)/(x12*y11-x11*y12+addNaN);
	    b1 = (x12-x11+addNaN)/(x12*y11-x11*y12+addNaN);
	    a2 = (y21-y22+addNaN)/(x22*y21-x21*y22+addNaN);
	    b2 = (x22-x21+addNaN)/(x22*y21-x21*y22+addNaN);
	    x = (b1-b2+addNaN)/(a2*b1-a1*b2+addNaN);
	    y = (a1-a2+addNaN)/(b2*a1-b1*a2+addNaN);
	    return new Point2D.Double(x, y);
    }
    
	/**
	 * Return get gauss value
	 * @param point
	 * @param power
	 * @param range
	 * @param delta
	 * @return
	 */
	public static double gauss(Point2D point, Point2D power, double range, double delta)
	{
		double distance = distance(point, power);
		double force = gauss(distance, range, delta);
		return force;
	}
	
	/**
	 * Return the gauss value.( y = range*exp(-0.5*(x/delta)^2) )
	 * @param x
	 * @param range
	 * @param delta
	 * @return
	 */
	public static double gauss(double x, double range, double delta)
	{
		double y = range*Math.exp(-0.5*x*x/(delta*delta));
		return y;
	}
	
}
