/*
 * Created on 2004-10-8
 */
package tide.util;

/**
 * A statist.Always use to do guess factors.
 * @author iiley(Chen Jing)
 */
public interface Statist {
	
	/**
	 * return the factor/probability of this index
	 * @param index
	 * @return the factor/probability of this index
	 */
	public float getFactor(int index);
	
	/**
	 * return the factors size.
	 * @return the factors size.
	 */
	public int size();
	
	/**
	 * rate the factor of this index.
	 * @param index
	 */
	public void rate(int index);
	
	/**
	 * rate the bearing of factor to the highest
	 * @param bearing
	 */
	public void rateHit(int index);
	
	/**
	 * return the index of the highest factor
	 * @return the index of the highest factor
	 */
	public int getHighestFactorIndex();
	
	/**
	 * @return the weigh of this Statist
	 */
	public float getWeigh();
}
