package ag.team;


/**
 * A collection of robot data
 * @author agrosse
 *
 */
public class Team_RobotData implements java.io.Serializable {

	static final long serialVersionUID = 1002;
	
	String mName;
	long mTick;
	double mX, mY, mHeading, mVelocity, mEnergy;

	/**
	 * Constructor
	 * @param name The name of the robot for this data
	 * @param tick Current turn
	 * @param x X-Position of the robot
	 * @param y Y-Position of the robot
	 * @param heading Heading of the robot (in Radians)
	 * @param velocity Velocity of the robot
	 * @param energy Energy of the robot
	 */
	public Team_RobotData(String name, long tick, double x, double y, 
			double heading, double velocity, double energy) {
		super();
		mName = name;
		mTick = tick;
		mX = x;
		mY = y;
		mHeading = heading;
		mVelocity = velocity;
		mEnergy = energy;
	}
		
	/**
	 * Returns the energy of the robot.
	 * @return the energy of the robot.
	 */
	public double getEnergy() {
		return mEnergy;
	}

	/**
	 * Returns the heading of the robot.
	 * @return the heading of the robot.
	 */
	public double getHeading() {
		return mHeading;
	}

	/**
	 * Returns the name of the robot.
	 * @return the name of the robot.
	 */
	public String getName() {
		return mName;
	}

	/**
	 * Returns the tick for this dataset.
	 * @return the tick for this dataset.
	 */
	public long getTick() {
		return mTick;
	}

	/**
	 * Returns the velocity of the robot.
	 * @return the velocity of the robot.
	 */
	public double getVelocity() {
		return mVelocity;
	}

	/**
	 * Returns the x-position of the robot.
	 * @return the x-position of the robot.
	 */
	public double getX() {
		return mX;
	}

	/**
	 * Returns the y-position of the robot.
	 * @return the y-position of the robot.
	 */
	public double getY() {
		return mY;
	}

	
}
