package bayen.nut;
import robocode.*;
import java.util.*;
import robocode.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.*;

class GFGun1 extends Gun {
	public GFGun1(){
		renderables = new Vector();
	}
	public String getName(){return "Main GF gun";}
	public Color getColor(){return Color.blue;}
	ScannedRobotEvent en;
	//ScannedRobotEvent e;
	private static double BULLET_POWER = 3.0;
	public int others;
	private static String enemy;
	private static double lateralDirection;
	private static double lastEnemyVelocity;
	public static final double TWO_PI = Math.PI*2;
	public static final double HALF_PI = Math.PI/2;
	private long lastTimeStill = 0;
	public void onScannedRobot(ScannedRobotEvent E) {
		e = E;
		BULLET_POWER = (Squirrel.getEnergy() / (e.getDistance() / 25));
		if(BULLET_POWER < 0.1)
		BULLET_POWER = 0.1;
		if(BULLET_POWER > 3.0)
		BULLET_POWER = 3.0;
		//gunHeat = Squirrel.getGunHeat();
		lastTimeStill++;
		if(e.getVelocity() == 0)
		lastTimeStill = 0;
		en = e;
		double bulletpower = BULLET_POWER;
		double enemyAbsoluteBearing = Squirrel.getHeadingRadians() + en.getBearingRadians();
		double enemyDistance = en.getDistance();
		double enemyVelocity = en.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(en.getHeadingRadians() - enemyAbsoluteBearing));
		}
		GFTWave1 wave = new GFTWave1(Squirrel, this, others);
		wave.enemyName = e.getName();
		if(enemy == null) {
			enemy = e.getName();
			wave.restoreFactors(enemy);
		}
		wave.gunLocation = new Point2D.Double(Squirrel.getX(), Squirrel.getY());
		GFTWave1.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = bulletpower;
		double enemyX = Squirrel.getX() + en.getDistance() * Math.sin(enemyAbsoluteBearing);
		double enemyY = Squirrel.getY() + en.getDistance() * Math.cos(enemyAbsoluteBearing);
		double angle = Math.atan2(Squirrel.getX() - enemyX, Squirrel.getY() - enemyY);
		while(angle < 0.0){
		 	angle += 2.0 * Math.PI;
		}
		while(angle >= 2.0 * Math.PI){
		 	angle -= 2.0 * Math.PI;
		}
		double eHeading = e.getHeadingRadians();
		double eRelativeHeading = normalizeHeading(angle - eHeading);
		//System.out.println(Math.toDegrees(eRelativeHeading));
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity, lastTimeStill, eHeading, eRelativeHeading);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = enemyAbsoluteBearing;
		wave.realWave = (Squirrel.getGunHeat() == 1 + bulletpower / 5);
		//if (Squirrel.getEnergy() >= bulletpower) {
			Squirrel.addCustomEvent(wave);
		//}
	}
	public void shoot(double bulletpower) {
		double enemyAbsoluteBearing = Squirrel.getHeadingRadians() + en.getBearingRadians();
		double enemyDistance = en.getDistance();
		double enemyVelocity = en.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(en.getHeadingRadians() - enemyAbsoluteBearing));
		}
		GFTWave1 wave = new GFTWave1(Squirrel, this, others);
		wave.enemyName = e.getName();
		if(enemy == null) {
			enemy = e.getName();
			wave.restoreFactors(enemy);
		}
		wave.gunLocation = new Point2D.Double(Squirrel.getX(), Squirrel.getY());
		GFTWave1.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = bulletpower;
		double enemyX = Squirrel.getX() + en.getDistance() * Math.sin(enemyAbsoluteBearing);
		double enemyY = Squirrel.getY() + en.getDistance() * Math.cos(enemyAbsoluteBearing);
		double angle = Math.atan2(Squirrel.getX() - enemyX, Squirrel.getY() - enemyY);
		while(angle < 0.0){
		 	angle += 2.0 * Math.PI;
		}
		while(angle >= 2.0 * Math.PI){
		 	angle -= 2.0 * Math.PI;
		}
		double eHeading = e.getHeadingRadians();
		double eRelativeHeading = normalizeHeading(angle - eHeading);
		//System.out.println(Math.toDegrees(eRelativeHeading));
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity, lastTimeStill, eHeading, eRelativeHeading);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = enemyAbsoluteBearing;
		wave.realWave = true;
		//System.out.println("Fired Real Wave");
		//if (Squirrel.getEnergy() >= bulletpower) {
			Squirrel.addCustomEvent(wave);
		//}
	}
	public double getFiringAngle(double bulletpower) {
		double enemyAbsoluteBearing = Squirrel.getHeadingRadians() + en.getBearingRadians();
		double enemyDistance = en.getDistance();
		double enemyVelocity = en.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(en.getHeadingRadians() - enemyAbsoluteBearing));
		}
		GFTWave1 wave = new GFTWave1(Squirrel,this,others);
		wave.enemyName = e.getName();
		wave.gunLocation = new Point2D.Double(Squirrel.getX(), Squirrel.getY());
		GFTWave1.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = bulletpower;
		double enemyX = Squirrel.getX() + en.getDistance() * Math.sin(enemyAbsoluteBearing);
		double enemyY = Squirrel.getY() + en.getDistance() * Math.cos(enemyAbsoluteBearing);
		double angle = Math.atan2(Squirrel.getX() - enemyX, Squirrel.getY() - enemyY);
		while(angle < 0.0){
		 	angle += 2.0 * Math.PI;
		}
		while(angle >= 2.0 * Math.PI){
		 	angle -= 2.0 * Math.PI;
		}
		double eHeading = en.getHeadingRadians();
		double eRelativeHeading = normalizeHeading(angle - eHeading);
		//System.out.println(Math.toDegrees(eRelativeHeading));
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity, lastTimeStill, eHeading, eRelativeHeading);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = enemyAbsoluteBearing;
		if (Squirrel.getEnergy() >= bulletpower) {
			//Squirrel.addCustomEvent(wave);
		}
		//System.out.println("MostVisitedBin is " + wave.getMostVisitedInt());
		return Utils.normalRelativeAngle(enemyAbsoluteBearing + wave.mostVisitedBearingOffset());
	}
	public void run(AdvancedRobot bot) {
		Squirrel = bot;
		others = Squirrel.getOthers();
		lateralDirection = 1;
		lastEnemyVelocity = 0;
		GFTWave1 wave = new GFTWave1(Squirrel,this,others);
	}
	public void endRound() {
		if (Squirrel.getRoundNum() == Squirrel.getNumRounds() - 1) {
       	GFTWave1 wave = new GFTWave1(Squirrel,this,others);
		wave.saveFactors(enemy);
    }
	}
	public static double normalizeHeading(double ang) {
		while (ang < 0) ang += TWO_PI;
		while (ang > TWO_PI) ang -= TWO_PI;
		return ang;
	}
	public static abstract class Renderable{
	public abstract void render(Graphics2D g);
	
	public static class Circle extends Renderable{
		Point2D.Double center;
		double radius;
		Color color;
		public Circle(Point2D.Double center, double radius, Color color){
			this.center = center;
			this.radius = radius;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawOval(	(int)Math.round(center.x - radius),
						(int)Math.round(center.y - radius),
						(int)Math.round(2 * radius),
						(int)Math.round(2 * radius));
		}
	}
	
	public static class Dot extends Renderable{
		Point2D.Double point;
		double radius;
		Color color;
		public Dot(Point2D.Double point, Color color){
			this.point = point;
			this.radius = 2;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.fillOval(	(int)Math.round(point.x - radius),
						(int)Math.round(point.y - radius),
						(int)Math.round(2 * radius),
						(int)Math.round(2 * radius));
		}
	}
	
	public static class Line extends Renderable{
		Point2D.Double p1, p2;
		Color color;
		
		double radius;
		public Line(Point2D.Double p1, Point2D.Double p2, Color color){
			this.p1 = p1;
			this.p2 = p2;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawLine(	(int)Math.round(p1.x),
						(int)Math.round(p1.y),
						(int)Math.round(p2.x),
						(int)Math.round(p2.y));
		}
	}
	
	public static class Text extends Renderable{
		String text;
		double x, y;
		Color color;
		
		double radius;
		public Text(String text, double x, double y, Color color){
			this.text = text;
			this.x = x;
			this.y = y;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawString(text, (float)x, (float)y);
		}
	}
	}
	
	
	
	//public static Vector renderables;
	
	
	public void onPaint(Graphics2D g){
		Iterator i = renderables.iterator();
		while(i.hasNext()){
			Renderable r = (Renderable) i.next();
			r.render(g);
		}
		renderables.clear();
	}
	
	public static void drawLine(Point2D.Double p1, Point2D.Double p2, Color color){
		renderables.add(new Renderable.Line(p1, p2, color));
	}
	
	public static void drawCircle(Point2D.Double center, double radius, Color color){
		renderables.add(new Renderable.Circle(center, radius, color));
	}
	
	public static void drawPoint(Point2D.Double p1, Color color){
		renderables.add(new Renderable.Dot(p1, color));
	}
	
	public static void drawText(String text, double x, double y, Color color){
		renderables.add(new Renderable.Text(text, x, y, color));
	}
}