package bayen.nut;
import robocode.*;
import java.util.*;
import robocode.util.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics2D;
class GFTWave5 extends Condition {
	static Point2D targetLocation;

	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double lateralDirection;
	boolean realWave;
	private static boolean bulletHit = false;

	private static final double MAX_DISTANCE = 900;
	private static final int DISTANCE_INDEXES = 5;
	private static final int VELOCITY_INDEXES = 5;
	private static final int BINS = 25;
	private static final int MIDDLE_BIN = (BINS - 1) / 2;
	private static final double MAX_ESCAPE_ANGLE = 0.7;
	private static final double BIN_WIDTH = MAX_ESCAPE_ANGLE / (double)MIDDLE_BIN;
	
	private static double weightn = 150;
	
	private static double[][][][] statBuffers = new double[DISTANCE_INDEXES][VELOCITY_INDEXES][VELOCITY_INDEXES][BINS];

	private double[] buffer;
	private AdvancedRobot robot;
	private double distanceTraveled;
	
	GFTWave5(AdvancedRobot _robot) {
		this.robot = _robot;
	}
	
	public boolean test() {
		if(robot.getOthers() > 1) weightn = 3;
		advance();
		if (hasArrived()) {
			boolean realBullet = false;
			if(bulletHit) {
				realBullet = true;
				bulletHit = false;
			}
			double weightnn = weightn;
			if(realWave && !realBullet) weightnn /= 50;
			if(!realBullet) buffer[currentBin()] = rollingAverage(buffer[currentBin()], 1, weightnn);
			if(!realBullet) missedBins();
			if(realBullet) buffer[currentBin()] = rollingAverage(buffer[currentBin()], 0, weightnn / 2);
			//if(realBullet) System.out.println("REAL BULLET");
			//System.out.println(weightnn);
			robot.removeCustomEvent(this);
		}
		return false;
	}

	double mostVisitedBearingOffset() {
		return (lateralDirection * BIN_WIDTH) * (mostVisitedBin() - MIDDLE_BIN);
	}

	void bulletHitTrue() {
		bulletHit = true;
	}
	
	void setSegmentations(double distance, double velocity, double lastVelocity) {
		int distanceIndex = (int)(distance / (MAX_DISTANCE / DISTANCE_INDEXES));
		int velocityIndex = (int)Math.abs(velocity / 2);
		int lastVelocityIndex = (int)Math.abs(lastVelocity / 2);
		buffer = statBuffers[distanceIndex][velocityIndex][lastVelocityIndex];
	}

	private void advance() {
		distanceTraveled += GFTUtils.bulletVelocity(bulletPower);
	}

	private boolean hasArrived() {
		return distanceTraveled > gunLocation.distance(targetLocation);
	}
	
	private int currentBin() {
		int bin = (int)Math.round(((Utils.normalRelativeAngle(GFTUtils.absoluteBearing(gunLocation, targetLocation) - bearing)) /
				(lateralDirection * BIN_WIDTH)) + MIDDLE_BIN);
		return GFTUtils.minMax(bin, 0, BINS - 1);
	}
	private void missedBins() {
		double weightnn = weightn;
			if(realWave) weightnn /= 50;
		int hitBin = currentBin();
		for (int i = 0; i < BINS; i++) {
			if (i != hitBin) {
				buffer[i] = rollingAverage(buffer[i], 0, weightnn);
			}
		}
	}
	
	private int mostVisitedBin() {
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++) {
			if (buffer[i] > buffer[mostVisited]) {
				mostVisited = i;
			}
		}
		return mostVisited;
	}	
	public double rollingAverage(double oldVal, double newVal, double weight) {
		return ((weight - 1.0) * oldVal + newVal) / weight;
	}
}

												