package paolord;
import robocode.*;
import java.awt.Color;

/**
 * TheHulk v1.0
 * Created by Angelo Paolo Obispo. Updated on Feb 16, 2008.
 * This robot uses Energy Differential to dodge bullets.
 */
public class TheHulk extends AdvancedRobot
{
	private byte scanDirection=1;
	double previousEnergy=100;
	private byte moveDirection=1;
		
	double normalizeBearing(double angle) {
	while (angle >  180) angle -= 360;
	while (angle < -180) angle += 360;
	return angle;
	}
			
	public void run() {
		
		while(true) {
			if(getEnergy()<75){
				setColors(Color.green,Color.green,Color.green);
				}
			setAdjustRadarForRobotTurn(true);
			setAdjustGunForRobotTurn(true);
			execute();
			setTurnRadarRight(360);
			
			}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double firepower = Math.min(400 / e.getDistance(), 3);
				
		setTurnRadarRight(normalizeBearing(getHeading()-getRadarHeading()+e.getBearing()));
		scanDirection*=-1;
		setTurnRadarRight(normalizeBearing(45*scanDirection));		
		setTurnRight(90+e.getBearing());
		setAhead(1000*moveDirection);
		execute();
		
		setTurnGunRight(normalizeBearing(getHeading()-getGunHeading()+e.getBearing()));
		if(getEnergy()>2.0){
		if (getGunHeat() == 0 && Math.abs(getGunTurnRemaining()) < 10)
		setFire(firepower);
		}
		else if(e.getEnergy()==0 && e.getVelocity()==0){
			setAhead(0);
			setFire(0.1);
		}		
		double changeInEnergy=previousEnergy-e.getEnergy();
		if(changeInEnergy>0&&changeInEnergy<=3){
			moveDirection*=-1;
			setAhead((e.getDistance()/4+25)*moveDirection);
		}
		
		previousEnergy=e.getEnergy();
	
	}

	public void OnHitWall(HitWallEvent e){moveDirection*=-1;}
	public void OnHitRobot(HitRobotEvent e){moveDirection*=-1;}
	
}
