package ags.muse.recon;

import ags.util.points.*;
import ags.muse.base.Rules;
import ags.muse.physics.*;
import ags.muse.recon.events.*;

public class SelfRobot extends Robot {
    public SelfRobot(Rules rules) {
        super(rules, null, rules.NAME);
    }

    // Variables
    private AbsolutePoint nextLocation;
    private double gunHeading, gunHeat, radarHeading;
    
    // Getters
    public AbsolutePoint getNextLocation() { return nextLocation; }
    public double getGunHeading() { return gunHeading; }
    public double getGunHeat() { return gunHeat; }
    public double getRadarHeading() { return radarHeading; }
    
    @Override
    public boolean update(ReconEvent event) {
        if (!(event instanceof SelfReconEvent)) {
            throw new IllegalArgumentException();
        }
        if (super.update(event)) {
            SelfReconEvent selfEvent = (SelfReconEvent)event;
            gunHeading = selfEvent.getGunHeading();
            gunHeat = selfEvent.getGunHeat();
            radarHeading = selfEvent.getRadarHeading();
            nextLocation = getLocation();
            return true;
        }
        return false;
    }

    public void setIntention(Rules rules, double ahead, double turn) {
        RobotSim sim = new RobotSim();
        sim.location = getLocation();
        sim.velocity = getVelocity();
        PhysicsEngine.simulateTick(rules, sim, ahead, turn, true);
        nextLocation = sim.location;
    }
}
