package penguin;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.ArrayList;
import java.awt.Color;
import java.awt.Graphics2D;

public class Joker extends AdvancedRobot
{
	static Enemy whale;
	SurfWave surfWave;
	GunWave gunWave;

	static ArrayList<SurfWave> WaveGroup;
	static ArrayList<GunWave> GunGroup;
	//ArrayList<Double> directionList;
	
	static final int SBINS = 45;
	static final int GBINS = 45;
	static final int middleSBin = (SBINS+1)/2;
	static final int middleGBin = (GBINS+1)/2;
	static final int nearWallSegments = 2;
	static final int distanceSegments = 4;
	static final int velocitySegments = 5;
	static final int lastVelocitySegments = velocitySegments;
	static final int lateralHeadingSegments = 5;
	static final int bulletNumberSegments = 12;
	static final int bPowerSegments = 4;

	static double MaxDistance = 1000;

	static double[][][][][][][] segmentedDanger = new double [nearWallSegments][distanceSegments][bulletNumberSegments][velocitySegments][bPowerSegments][lastVelocitySegments][SBINS];
	static double[][][][][][] segmentedShotArray = new double [nearWallSegments][distanceSegments][velocitySegments][lastVelocitySegments][lateralHeadingSegments][GBINS];
	//static double[][] segmentedShotArray = new double [velocitySegments][GBINS];

	static double[] dangerArray = new double[SBINS];
	static double[] shotArray = new double [GBINS];
	static double[] tempDanger = new double [SBINS];

	static int wallSeg=0;
	static int distSeg=0;
	static int vSeg=0;
	static int lvSeg=0;
	static int headSeg=4;
	static int bulletNSeg=0;
	static int projectedwallSeg=0;
	static int projecteddistSeg=0;
	static int projectedlvSeg=0;
	static int projectedvSeg=0;
	static int projectedheadSeg=0;
	static int projectedbulletNSeg=0;
	static int projectedbPowerSeg=0;
	static int bPowerSeg = 0;
	
	static int theirClockwise = 1;
	
	static double heading;
	static double velocity;
	static double lateralDirection=1;
	static double lastVelocity;
	static double lateralHeading;
	static double offWall = 1;
	static int binOffset = 1;
	
	static double desiredAngle;
	
	static Point2D.Double ourPosition;
	static Point2D.Double mapMiddle;
	
	static RoundRectangle2D.Double playField;
	static double battleWidth, battleHeight;
	
	static double clockwise = 1;
	static double statDir = clockwise;
	static double tempDirection = 1;
	
	static double bPower = 3;
	static double bSpeed = 20-3*bPower;
	
	static final double PI = Math.PI;
	static double angleToAimAt=0;
	
	static double emptyDirection = 1;
	
	static boolean reversed = false;
	static boolean emptySurf = true;
	static boolean surfing = true;

	public void run() {

		battleWidth = getBattleFieldWidth();
		battleHeight = getBattleFieldHeight();
		
		Color purple = Color.getHSBColor(0.8f, 0.9f, 0.8f);

		 setColors(purple,Color.green,Color.white);
		 setBulletColor(purple);
		
		whale = new Enemy();
		WaveGroup = new ArrayList<SurfWave>();
		GunGroup = new ArrayList<GunWave>();

		playField = new RoundRectangle2D.Double(20,20,battleWidth-40,battleHeight-40,10,10);
		mapMiddle = new Point2D.Double((battleWidth/2),(battleHeight)/2);
		
	//	setGunImageName("DooderShooter");

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
	//	whale.seen = false;
		reversed = false;
		
		WaveGroup.clear();

		while(true) {
			
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}
	
	void update(){
	
		ourPosition = new Point2D.Double(getX(),getY());
		tempDirection = 1;

	//	if(getRadarTurnRemaining()==0)
	//	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	
		heading = getHeadingRadians();
		velocity = getVelocity();

		advanceWaves();
		
	//	speed();
		
		

		whale.seen = false;
	//	execute();
		
	}
	void aim(){
		setTurnGunRightRadians(Utils.normalRelativeAngle(angleToAimAt-getGunHeadingRadians()));
	}
	
	void advanceWaves(){
		SurfWave testWave;
		double timeDelta=0;
		if(!WaveGroup.isEmpty()){
		for(int i = 0; i < WaveGroup.size(); i++){
			testWave = (SurfWave)WaveGroup.get(i);
			if(testWave!=null){
			timeDelta = getTime() - testWave.shotTime;
			testWave.distTraveled = testWave.bSpeed*(timeDelta);
			double distDelta = (getDistance(testWave.enemyLocation, ourPosition)-testWave.distTraveled);
			testWave.timeTillHit = distDelta/testWave.bSpeed;
			if(distDelta <= 0){
				WaveGroup.remove(i);
				reversed = false;
				i--;
			} 
			}
		}
		}
		GunWave advwave;
		for(int i =0; i < GunGroup.size(); i ++){
			advwave = (GunWave)(GunGroup.get(i));
			advwave.distTraveled = advwave.bSpeed * (getTime() - advwave.time);
		//	double howfar = Math.sqrt((Math.pow((whale.position.x - advwave.ourpos.x),2)) + (Math.pow((whale.position.y - advwave.ourpos.y),2)));
			double howfar = whale.position.distance(advwave.ourpos);
			if (advwave.distTraveled > howfar){
				storeShotData(advwave, whale.position);
				GunGroup.remove(i);
				i--;
			}
		}
	} 
	
	void shoot(){
		setAimAngle(findHeaviestBin());
		aim();
	}

	void speed(){

		SurfWave avoidWave = getClosestSurfableWave();
		tempDirection = 1;
		surfing = true;
//		if(avoidWave.present){
		if(!WaveGroup.isEmpty()&&avoidWave!=null){
		emptySurf = false;
		double goDir=clockwise*avoidWave.lateralDirection;
		double turnAmount = desiredAngle - heading;
		double projectDistance = 160*avoidWave.Clockwise;

		double distValue = 160;

		if(avoidWave.enemyLocation!=null)
		setDirection(avoidWave);
	
		
		
		if(clockwise*avoidWave.Clockwise<0){ reversed = true; }
		
		goDir = clockwise * avoidWave.lateralDirection;
		
		if(lateralDirection*clockwise>0){ reversed = false; }		
		
		projectDistance = distValue*goDir;

		turnAmount = getTurnAmount(ourPosition,avoidWave.enemyLocation,sign(velocity));

		tempDirection = (reversed?-1:1);

			
			desiredAngle = Utils.normalRelativeAngle(turnAmount+heading);

			setTurnRightRadians((turnAmount));
			setAhead(projectDistance);
	

			setMaxVelocity((PI)/Math.abs(getTurnRemainingRadians()));
		}
		else emptySurf = true;
	}

	void setDirection(SurfWave dodgeWave){
	

		double nextV = getVelocity();
		Point2D.Double nextPos = ourPosition, backPos = ourPosition, tempPos;
		double tempDir, maxTurn, nextHeading;
		double turnAmt = 0;
		double dangerBack = getDanger(dodgeWave,ourPosition), dangerFront = getDanger(dodgeWave,ourPosition);
		double dist = 1000;
		boolean wavePassed;
		long itterations;
		
		if(whale.seen){

		for(int d=-1; d<1; d++){
		
		if(d==0) d = 1;
		tempDir = clockwise*dodgeWave.lateralDirection*d;
		nextV = getVelocity();
		tempPos = ourPosition;
		nextHeading = heading;
		wavePassed = false;
		itterations = 1;
		reversed = false;
		
		while(!wavePassed){
		
			nextV += ((nextV*tempDir)<0?2*tempDir:tempDir);

			nextV = limit(-8,nextV,8);

			maxTurn = PI/720d*(40d - 3d*Math.abs(nextV));
			
			turnAmt = getTurnAmount(tempPos,dodgeWave.enemyLocation,sign(nextV));
			nextV = limit(-8,(int)new Double(limit(-PI/Math.abs(turnAmt),nextV,PI/Math.abs(turnAmt))).intValue(),8);
			turnAmt = limit(-maxTurn,turnAmt,maxTurn);

    		nextHeading = Utils.normalRelativeAngle(nextHeading + turnAmt);

			tempPos = project(tempPos,nextHeading,nextV);
			
			dist = getDistance(dodgeWave.enemyLocation,tempPos)-(itterations*dodgeWave.bSpeed)-(dodgeWave.distTraveled);
			if(dist<=0) wavePassed = true;
			itterations++;
		}
		if(d==-1) backPos = tempPos;
		if(d==1) nextPos = tempPos;
		dangerBack = getDanger(dodgeWave,backPos);
		dangerFront = getDanger(dodgeWave,nextPos); 
		}
		}

		if(dangerFront>dangerBack) clockwise *= -1;


	}


	public void onScannedRobot(ScannedRobotEvent e) {
	
	//	setTurnRadarLeftRadians(getRadarTurnRemainingRadians()+PI/10);
		update();
		
		setInfo(e);
		setGun(e);
		shoot();
		
		setTurnRadarRightRadians(Utils.normalRelativeAngle(whale.absBearing - getRadarHeadingRadians())*2);
	
		double tBulletPower = whale.lastHealth - whale.health;
		if(tBulletPower<= 3 && tBulletPower >0){
			reactToShot(e, tBulletPower);
		}
		whale.lastHealth = whale.health;

	//	if(getEnergy()>bPower)
	//	setGun(e);
	
		offWall = 1;
		if(whale.seen&&WaveGroup.isEmpty()&&surfing&&emptySurf) {
			setTurnRightRadians(getTurnAmount(ourPosition, whale.position, sign(velocity)));
			setMaxVelocity((PI)/Math.abs(getTurnRemainingRadians()));
			setAhead(160*emptyDirection);
			Point2D.Double nextPos = project(ourPosition,heading,160*emptyDirection);
			if(!playField.contains(nextPos)&&getDistance(whale.position,nextPos)<whale.distance)
		    emptyDirection*=-1;
		}
		
		speed();
		execute();
	
	}
	
	void setInfo(ScannedRobotEvent e){
	
		whale.heading = e.getHeadingRadians();
		whale.ourHeading = getHeadingRadians();
		whale.bearing = e.getBearingRadians();
		whale.absBearing = NormaliseBearing(whale.bearing + whale.ourHeading);
		whale.distance = e.getDistance();
		whale.position = project(ourPosition, whale.absBearing, whale.distance);
		whale.health = e.getEnergy();
		whale.absBearingToUs = absoluteBearing(whale.position, ourPosition);
		whale.ourLateralHeading = Utils.normalRelativeAngle(heading - whale.absBearingToUs);
		whale.ourLateralVelocity = getVelocity() * Math.sin(whale.bearing);
		whale.lateralDirection = 1;
		if(sign(whale.ourLateralVelocity)<0)
		whale.lateralDirection = -1;
		if(whale.ourLateralVelocity==0)
		whale.lateralDirection = clockwise;
		lateralDirection = whale.lateralDirection;
		whale.velocity = e.getVelocity();
		whale.eLateralHeading = Utils.normalRelativeAngle(whale.heading - whale.absBearing);
		whale.lastLateralVelocity = whale.eLateralVelocity;
		whale.eLateralVelocity = (whale.velocity * Math.sin(whale.eLateralHeading));
		theirClockwise = new Double(whale.eLateralDirection).intValue();
		if(whale.velocity!=0)
		whale.eLateralDirection = (int)((whale.eLateralVelocity)>0?1:-1);
		if(whale.velocity==0)
			whale.eLateralDirection = theirClockwise;
		
		//
		setSegmentation();
		//
		lastVelocity = velocity;
		whale.ourLastLateralVelocity = whale.ourLateralVelocity;
		whale.seen = true;
	}
	
	void setSegmentation(){
		wallSeg = 0;
		if(!playField.contains(project(ourPosition, heading, 160))) wallSeg = 1;
		if(!playField.contains(project(ourPosition, heading, -160))) wallSeg = 1;
		whale.wallSeg = 0;
		if(!playField.contains(project(whale.position, whale.heading, 160))) whale.wallSeg = 1;
		if(!playField.contains(project(whale.position, whale.heading, -160))) whale.wallSeg = 1;
		whale.lvSeg = whale.vSeg;
		whale.vSeg = (int)Math.abs(whale.eLateralVelocity / (8/(velocitySegments-1)));
		distSeg = (int)(whale.distance / (MaxDistance / new Double(distanceSegments).doubleValue()));
		whale.distSeg = distSeg;
		headSeg = (int)limit(0,(Math.round(Math.abs(whale.ourLateralHeading / (Math.PI/2)) * (new Double(lateralHeadingSegments-1).doubleValue()))),lateralHeadingSegments-1);
		whale.headSeg = (int)limit(0,(Math.round(Math.abs(whale.eLateralHeading / (Math.PI/2)) * (new Double(lateralHeadingSegments-1).doubleValue()))),lateralHeadingSegments-1);
		
		bulletNSeg = limit(1,WaveGroup.size(),11); bPowerSeg = (int)Math.ceil(bPower);

		lvSeg = vSeg;
		vSeg = limit(-4,(int)Math.abs(whale.ourLateralVelocity / (8/(velocitySegments-1))),4);
	
		dangerArray = segmentedDanger[wallSeg][distSeg][bulletNSeg][vSeg][bPowerSeg][lvSeg];
	//	shotArray = segmentedShotArray[whale.wallSeg][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg];

	}

	void reactToShot(ScannedRobotEvent e, double instancePower){
		surfWave = new SurfWave();
		surfWave.heading = whale.ourLateralHeading;
		surfWave.velocity = whale.ourLastLateralVelocity;
		surfWave.lateralDirection = whale.lateralDirection;
		surfWave.lastVelocity = whale.ourLastLateralVelocity;
		surfWave.lateralHeading = whale.ourLateralHeading;
		surfWave.wallSeg = wallSeg;
		surfWave.distSeg = distSeg;
		surfWave.vSeg = vSeg;
		surfWave.lvSeg = lvSeg;
		surfWave.headSeg = headSeg;
		surfWave.bulletNSeg = bulletNSeg;
		surfWave.shotTime = getTime()-1;
		surfWave.enemyLocation = whale.position;
		surfWave.dist = whale.distance;
		surfWave.bPower = instancePower;
		surfWave.bPowerSeg = (int)Math.ceil(surfWave.bPower);
		surfWave.bSpeed = getBSpeed(surfWave.bPower);
		surfWave.distTraveled = surfWave.bSpeed;
		surfWave.bearingToUs = /*NormaliseBearing(*/absoluteBearing(whale.position, ourPosition);//);
		surfWave.Clockwise = clockwise;
		surfWave.maxBearingOffset = Math.asin(8/surfWave.bSpeed) * surfWave.lateralDirection;
		surfWave.bearingToThem = e.getBearingRadians();
		surfWave.timeTillHit = new Double(surfWave.dist/surfWave.bSpeed).longValue();
		WaveGroup.add(surfWave);
		bPower = surfWave.bPower;
	}
	void setGun(ScannedRobotEvent e){

		if (getEnergy()>bPower){
		if (getGunTurnRemainingRadians()==0){
		if (getGunHeat() == 0) {
			GunWave gunWave = new GunWave();
			gunWave.bearing = whale.absBearing;
			bSpeed = getBSpeed(bPower);
			gunWave.bSpeed = bSpeed;
			gunWave.dist = whale.distance;
			gunWave.distTraveled = 0;
			gunWave.location = whale.position;
			gunWave.time = getTime();
			gunWave.lateralVelocity = whale.eLateralVelocity;
			gunWave.lateralDirection = (whale.eLateralDirection);
			gunWave.maxBearingOffset = Math.asin(8/gunWave.bSpeed) * gunWave.lateralDirection;
			gunWave.ourpos = new Point2D.Double ((getX()),(getY()));
			gunWave.maxBearing = NormaliseBearing(gunWave.bearing+gunWave.maxBearingOffset);
			gunWave.minBearing = NormaliseBearing(gunWave.bearing-gunWave.maxBearingOffset);
			gunWave.nearWallSegment = whale.wallSeg;
			gunWave.distanceSegment = whale.distSeg;
			gunWave.lateralVelocitySegment = whale.vSeg;
			gunWave.lastVelocitySegment = whale.lvSeg;
			gunWave.lateralHeadingSegment = whale.headSeg;
			
			GunGroup.add(gunWave);
				
			setFire(bPower); 
		}}}
	}
	
	void logHit(SurfWave hitWave, HitByBulletEvent bulletEvent){
		Bullet bull = bulletEvent.getBullet();
		hitWave = getIncidentShotWave();
		Point2D.Double bulletSpot = new Point2D.Double(bull.getX(),bull.getY());
		if(!(hitWave).equals(null)){

		int hitBin = getBin(hitWave, bulletSpot);

		double multiplier = 0;
		
		for(int b = 0; b < SBINS; b++){			
		
			multiplier = (1/(Math.pow(hitBin-b,2)+1));

			segmentedDanger[hitWave.wallSeg][hitWave.distSeg][hitWave.bulletNSeg][hitWave.vSeg][hitWave.bPowerSeg][hitWave.lvSeg][b] +=
				multiplier;
		
		for(int w = 0; w < nearWallSegments; w++){

				segmentedDanger[w][hitWave.distSeg][hitWave.bulletNSeg][hitWave.vSeg][hitWave.bPowerSeg][hitWave.lvSeg][b] +=
					((1/(Math.pow(hitWave.wallSeg - w,2)+1))) * multiplier;
					
		}
	
			for(int d = 0; d < distanceSegments; d++){

					segmentedDanger[hitWave.wallSeg][d][hitWave.bulletNSeg][hitWave.vSeg][hitWave.bPowerSeg][hitWave.lvSeg][b] +=
						((1/(Math.pow(hitWave.distSeg - d,2)+1))) * multiplier;
						
			}
					
				for(int e = 0; e < bulletNumberSegments; e ++){
					
					segmentedDanger[hitWave.wallSeg][hitWave.distSeg][e][hitWave.vSeg][hitWave.bPowerSeg][hitWave.lvSeg][b] +=
						(1/(Math.pow(hitWave.bulletNSeg - e,2)+1)) * multiplier;
		
				}
				
					for(int o = 0; o < velocitySegments; o ++){
				
						segmentedDanger[hitWave.wallSeg][hitWave.distSeg][hitWave.bulletNSeg][o][hitWave.bPowerSeg][hitWave.lvSeg][b] +=
							(1/(Math.pow(hitWave.vSeg - o,2)+1)) * multiplier;
							
					}
				for(int p = 0; p < bPowerSegments; p ++){
				
						segmentedDanger[hitWave.wallSeg][hitWave.distSeg][hitWave.bulletNSeg][hitWave.vSeg][p][hitWave.lvSeg][b] +=
							(1/(Math.pow(hitWave.bPowerSeg - p,2)+1)) * multiplier;
							
					}
				for(int r = 0; r < lastVelocitySegments; r ++){
				
						segmentedDanger[hitWave.wallSeg][hitWave.distSeg][hitWave.bulletNSeg][hitWave.vSeg][hitWave.bPowerSeg][r][b] +=
							(1/(Math.pow(hitWave.lvSeg - r,2)+1)) * multiplier;
							
					}
			}
		}

	}
	
	public void storeShotData(GunWave fW, Point2D.Double pos){
		int catchBin = getGunBin(fW, pos);
		//	segmentedShotArray[fW.nearWallSegment][fW.distanceSegment][fW.lateralVelocitySegment][fW.lastVelocitySegment][fW.lateralHeadingSegment][catchBin] += 1;
		double binBonus;
		for(int i = 0; i < GBINS; i ++){
			binBonus = 1 / (Math.pow((catchBin - i),2) + 1);
			shotArray[i] *= binBonus;
			shotArray[i] += binBonus;
			
	
			segmentedShotArray[fW.nearWallSegment][fW.distanceSegment][fW.lateralVelocitySegment][fW.lastVelocitySegment][fW.lateralHeadingSegment][i] *=
				binBonus;

			for(int w = 0; w < nearWallSegments; w ++){	
segmentedShotArray[w][fW.distanceSegment][fW.lateralVelocitySegment][fW.lastVelocitySegment][fW.lateralHeadingSegment][i] 
					+= ((1 / (Math.pow((fW.nearWallSegment - w),2) + 1)) * (binBonus));
			}
			for(int d = 0; d < distanceSegments; d ++){
segmentedShotArray[fW.nearWallSegment][d][fW.lateralVelocitySegment][fW.lastVelocitySegment][fW.lateralHeadingSegment][i]
					+= ((1 / (Math.pow((fW.distanceSegment - d),2) + 1)) * (binBonus));
			}
			for(int v = 0; v < velocitySegments; v ++){		
segmentedShotArray[fW.nearWallSegment][fW.distanceSegment][v][fW.lastVelocitySegment][fW.lateralHeadingSegment][i]
					 += (( 1 / (Math.pow((fW.lateralVelocitySegment - v),2) * 1)) + (binBonus));
			}
			for(int lv = 0; lv < lastVelocitySegments; lv ++){
segmentedShotArray[fW.nearWallSegment][fW.distanceSegment][fW.lateralVelocitySegment][lv][fW.lateralHeadingSegment][i]
					+= ((1 / (Math.pow((fW.lastVelocitySegment - lv),2) + 1)) * (binBonus));
			}
			for(int h = 0; h < lateralHeadingSegments; h ++){
segmentedShotArray[fW.nearWallSegment][fW.distanceSegment][fW.lateralVelocitySegment][fW.lastVelocitySegment][h][i]
					+= ((1 / (Math.pow((fW.lateralHeadingSegment - h),2) + 1)) * (binBonus));
			}
		}
	}
	
	public int getGunBin(GunWave fadingWave, Point2D.Double location){
		int gunBin = middleGBin;
		double deltaBearingPercent = NormaliseBearing(absoluteBearing(fadingWave.ourpos,location) - (fadingWave.bearing))/(fadingWave.maxBearingOffset);
		gunBin = (int)limit(0,((new Double(deltaBearingPercent*(middleGBin)).intValue()) + (middleGBin)),GBINS-1);
		return gunBin;
	}
	
	int getBin(SurfWave wave, Point2D.Double position){
		
		int bin = (middleSBin);

		if(!(wave.equals(null))){

		double bearingOffset = NormaliseBearing((absoluteBearing(wave.enemyLocation,position)-wave.bearingToUs));
		double bearingOffsetPercent = bearingOffset/wave.maxBearingOffset;
		double binOffset = bearingOffsetPercent * middleSBin;
		bin = (int)Math.round(middleSBin + binOffset);
		}
		
		return (int)limit(0,bin,SBINS-1);
	
	} 
	
	int findHeaviestBin(){
		int heavyBin = (int)new Double(middleGBin).intValue();//,adjustedBin = heavyBin;
		int tempBin = heavyBin;
		if(whale.seen){
		double botWidth = Math.asin(18/(getDistance(ourPosition, whale.position)));
		double binWidth = Math.asin(8/bSpeed)/(new Double(GBINS).doubleValue());
//		int heavySegBin = heavyBin;
		double binWeight = 0;//, adjustedWeight = 0;
	//	double lastDanger;// = binWeight;
		int currBin = middleGBin;
		currBin = 0;
			int deltaBin = new Double(Math.ceil(Math.abs(botWidth/binWidth))+1).intValue();
		int negativeBin = 0, positiveBin = 2*deltaBin;

	/*	if(positiveBin >= SBINS-1)
		currBin = (SBINS-1) - deltaBin;

		if(negativeBin <= 0)
		currBin = deltaBin;
		
		negativeBin = limit(0,currBin-deltaBin,currBin);

		positiveBin = limit(currBin,(currBin + deltaBin),SBINS-1);*/
		
		//tempDanger = segmentedDanger[wave.wallSeg][wave.distSeg][wave.bulletNSeg][wave.vSeg][wave.bPowerSeg][wave.lvSeg];
	//	int tempLowBin, tempHighBin;

		double dangerCount;// = 0;
		for(int i = 0; i < GBINS; i ++){
			currBin = i;
	//		dangerCount = 0;
//			negativeBin = currBin - deltaBin;
		//	if(negativeBin < 0) currBin = deltaBin;
//			positiveBin = currBin + deltaBin;
		//	if(positiveBin >= GBINS) currBin = GBINS-1-deltaBin;

		/*	tempHighBin = limit(currBin,currBin+deltaBin,GBINS-1+deltaBin); // (int)limit(i,(i + deltaBin),GBINS-1);
			if(positiveBin>GBINS-1) tempLowBin = GBINS-1-2*deltaBin;
			tempLowBin = limit(-deltaBin,positiveBin-2*deltaBin,currBin);
			if(negativeBin<0) tempHighBin = 2*deltaBin;*/
		//	out.println("deltaBin : " + 2*deltaBin);
				
		/*	for(int Q = limit(0,tempLowBin,currBin); Q <= limit(currBin,tempHighBin,GBINS-1); Q++){
				dangerCount+=shotArray[Q];// *(Math.random()*.3+.8);
			}*/
	/*		for(int Q = negativeBin; Q <= positiveBin; Q++){
				dangerCount+=shotArray[limit(0,Q,GBINS-1)];// *(Math.random()*.3+.8);
			}*/
			dangerCount = shotArray[currBin];
		
			if(dangerCount>binWeight){
			//				relativeHeight = shotArray[i]-binWeight;
							binWeight = dangerCount;
							tempBin = currBin;
				/*	if(lastDanger==dangerCount)*/ //tempBin = (positiveBin+negativeBin)/2;
			}
	//		lastDanger = dangerCount;
		}
/*		double[] gunArray = shotArray;
		int heavyW=whale.wallSeg,heavyD=whale.distSeg,heavyV=whale.vSeg,heavyLV=whale.lvSeg,heavyH=whale.headSeg;
		double relativeHeight = 0, adjustedHeight = 0, relativeWeight = 0;
		
		for(int i = 0; i < GBINS; i ++){
		//	for(int q = 0; q < 2; q++){
  			for(int w = 0; w < nearWallSegments; w ++){	

				if (segmentedShotArray[w][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg][i] > gunArray[i])
					//segmentedShotArray[whale.wallSeg][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg][i])
					heavyW = w;

			}
 
			for(int d = 0; d < distanceSegments; d ++){
				
				if (segmentedShotArray[heavyW][d][whale.vSeg][whale.lvSeg][whale.headSeg][i] > gunArray[i])
				//	segmentedShotArray[whale.wallSeg][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg][i])
					heavyD = d;

			}
			
			for(int v = 0; v < velocitySegments; v ++){		
				
				if (segmentedShotArray[heavyW][heavyD][v][whale.lvSeg][whale.headSeg][i] > gunArray[i])
				//	segmentedShotArray[whale.wallSeg][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg][i])
					heavyV = v;

			}

			for(int lv = 0; lv < lastVelocitySegments; lv ++){
				
				if (segmentedShotArray[heavyW][heavyD][heavyV][lv][whale.headSeg][i] > gunArray[i])
				//	segmentedShotArray[whale.wallSeg][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg][i])
					heavyLV = lv;

			}

			for(int h = 0; h < lateralHeadingSegments; h ++){
				
				if (segmentedShotArray[heavyW][heavyD][heavyV][heavyLV][h][i] > gunArray[i])
				//	segmentedShotArray[whale.wallSeg][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg][i])
					heavyH = h;

			
					}//}}}}
			gunArray = segmentedShotArray[heavyW][heavyD][heavyV][heavyLV][heavyH];
				if(gunArray[i]>adjustedWeight){
						//	binWeight = segmentedShotArray[w][d][v][lv][h][i];
						//	binWeight = gunArray[i];
							adjustedHeight = gunArray[i]-adjustedWeight;
							adjustedWeight = gunArray[i];
							adjustedBin = i;
				}
		//	}}}}}	
			//	else adjustedBin = tempBin;
			}
			
	//				if(segmentedShotArray[w][d][v][lv][h][i]>binWeight){
					//	binWeight = segmentedShotArray[w][d][v][lv][h][i];
		/*				heavyW = (int)Math.round((w+whale.wallSeg)/2);
						heavyD = (int)Math.round((d+whale.distSeg)/2);
						heavyV = (int)Math.round((v+whale.vSeg)/2);
						heavyLV = (int)Math.round((lv+whale.lvSeg)/2);
						heavyH = (int)Math.round((h+whale.headSeg)/2);
		*/			//	gunArray = segmentedShotArray[heavyW][heavyD][heavyV][heavyLV][heavyH];
						//heavyBin = i;
				//		heavySegBin = i;
				//		heavyBin = i;
			/*	binWeight = 0;	
				for(int i = 0; i < GBINS; i ++){
						if(shotArray[i]>binWeight){
			//				relativeHeight = shotArray[i]-binWeight;
							binWeight = shotArray[i];
							tempBin = i;
						}
				}*/
				/*		if(gunArray[i]>adjustedWeight){
						//	binWeight = segmentedShotArray[w][d][v][lv][h][i];
						//	binWeight = gunArray[i];
							adjustedHeight = gunArray[i]-adjustedWeight;
							adjustedWeight = gunArray[i];
							adjustedBin = i;
						}*/
					//	else adjustedBin = tempBin;
				//		relativeWeight = /*limit(0,*/relativeHeight/(adjustedHeight+relativeHeight);//,1);
	//			heavyBin = limit(0,(int)Math.round((tempBin)+(adjustedBin-tempBin)*whale.eLateralDirection * (relativeWeight)),SBINS-1);
			//			heavyBin = (int)Math.round((tempBin+adjustedBin)/2);
			}
						heavyBin = tempBin;
				//		out.println(tempBin + " to " + heavyBin + " from " + adjustedBin);
		//	}
	/*	if(shotArray[i]>binWeight){
			binWeight = shotArray[i];
			heavyBin = i;
		}
	}*/
//		binWeight = 
//		segmentedShotArray[whale.wallSeg][whale.distSeg][whale.vSeg][whale.lvSeg][whale.headSeg][heavyBin];
		return heavyBin; 
	}
	
	public void setAimAngle(double targetBin){
		double midBin = middleGBin;
		double binOffPercent = (double)(targetBin - midBin)/(midBin);
		double angleOffset = binOffPercent * Math.asin(8/bSpeed) * whale.eLateralDirection;
		angleToAimAt = Utils.normalRelativeAngle(whale.absBearing + angleOffset);
	}
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////	
	double getDanger(SurfWave wave, Point2D.Double position){//, int pwallSeg, int pdistSeg, int pbulletNSeg, int pvSeg, int pbPowerSeg, int plvSeg){
		double botWidth = Math.asin(18/(getDistance(wave.enemyLocation, position)));
		double binWidth = wave.maxBearingOffset/(new Double(SBINS).doubleValue());
		binOffset = new Double(Math.ceil(Math.abs(botWidth/binWidth))+1).intValue();
		int currBin = getBin(wave, position);
		int negativeBin = currBin-binOffset, positiveBin = currBin+binOffset;

		if(positiveBin >= SBINS-1)
		currBin = (SBINS-1) - binOffset;

		if(negativeBin <= 0)
		currBin = binOffset;
		
		negativeBin = limit(0,currBin-binOffset,currBin);

		positiveBin = limit(currBin,(currBin + binOffset),SBINS-1);
		
		tempDanger = segmentedDanger[wave.wallSeg][wave.distSeg][wave.bulletNSeg][wave.vSeg][wave.bPowerSeg][wave.lvSeg];


		double dangerCount = 0;
		for(int i = negativeBin; i <= positiveBin; i++){
			dangerCount+=tempDanger[i];// *(Math.random()*.3+.8);
		}
		

		return dangerCount;
	}


	double getDanger(SurfWave wave, int currBin){
		
		double botWidth = Math.asin(18/(getDistance(wave.enemyLocation, ourPosition)));
		double binWidth = wave.maxBearingOffset/(new Double(SBINS).doubleValue());
		binOffset = new Double(Math.ceil(Math.abs(botWidth/binWidth))+1).intValue();
		int negativeBin = currBin-binOffset, positiveBin = currBin+binOffset;
		int tempBin = currBin;

		if(positiveBin >= SBINS)
		tempBin = (SBINS-1) - binOffset;

		if(negativeBin <= 0)
		tempBin = binOffset;
		
		negativeBin = limit(0,tempBin-binOffset,tempBin);

		positiveBin = limit(tempBin,(tempBin + binOffset),SBINS-1);
		
		double dangerCount = 0;
		for(int i = negativeBin; i <= positiveBin; i++){
			dangerCount+=dangerArray[i];
		}
		

		return dangerCount;
	}
//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
	double getTurnAmount(Point2D.Double position, Point2D.Double rotationLocation, double dir){
		heading = getHeadingRadians(); velocity = getVelocity();

		double absBearingToIncident = absoluteBearing(position,rotationLocation);
		double tangentLine = Utils.normalRelativeAngle(absBearingToIncident - PI/2 - PI/8*dir);
		double amountToTurn = NormaliseBearing(tangentLine - heading);
		long turnItterations = 1;
		Point2D.Double nextPosition = position;
		double projectDistance, distValue;

			
			double directionClear = dir;
			
			distValue = 160;

			double goAngle = tangentLine;
			projectDistance = distValue*directionClear;

			nextPosition = project(position, goAngle, projectDistance);


	while(!playField.contains(nextPosition)){
			
			amountToTurn = NormaliseBearing(amountToTurn+.01*directionClear);
			
			wallSeg = 1;
			
			goAngle = Utils.normalRelativeAngle(heading+amountToTurn);
			nextPosition = project(position, goAngle, projectDistance);

			turnItterations++;
			if(turnItterations > 314) break;

		}
		
		desiredAngle=Utils.normalRelativeAngle(goAngle);
		amountToTurn = NormaliseBearing(amountToTurn);
		
		return amountToTurn;

	}

	public void onHitByBullet(HitByBulletEvent e) {

		SurfWave hitWave = getIncidentShotWave();
		try{
			logHit(hitWave, e);
		}
		catch (NullPointerException npe) {
			out.println("A bullet snuck past our notice: ");
		}
		
	}

	public void onHitWall(HitWallEvent e) {
		reversed = false;
		offWall = -1;
	}

	SurfWave getClosestSurfableWave(){
		SurfWave testWave, closeWave = new SurfWave();
		double dist = MaxDistance, timeDelta=0;

		for(int w = 0; w < WaveGroup.size(); w++){
			testWave = (SurfWave)WaveGroup.get(w);
			timeDelta = getTime() - testWave.shotTime;
			testWave.distTraveled = testWave.bSpeed*(timeDelta);
			double distDelta = (getDistance(testWave.enemyLocation, ourPosition)-testWave.distTraveled);
			testWave.present = false;
			if((distDelta<(dist))&&(distDelta>=(testWave.bSpeed))){
				closeWave = testWave;
				closeWave.present = true;
				dist = distDelta;
			}
		}

		return closeWave;
		
	}
	
	SurfWave getIncidentShotWave(){
		
		SurfWave checkWave, hitWave = new SurfWave();
		double dist = MaxDistance, timeDelta = 0, distDelta = 0;
		
		for(int r = 0; r < WaveGroup.size(); r++){
			checkWave = (SurfWave)WaveGroup.get(r);
			timeDelta = getTime() - checkWave.shotTime;
			checkWave.distTraveled = (checkWave.bSpeed)*(timeDelta);
			distDelta = (getDistance(checkWave.enemyLocation, ourPosition)-checkWave.distTraveled);
			if(Math.abs(distDelta)<dist){
				hitWave = checkWave;
				dist = Math.abs(distDelta);
			}
		}
		
		return hitWave;

	}
	

	static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }
	static double absoluteBearing(double sourcex, double sourcey,double targetx,double targety){
		return Math.atan2(targetx - sourcex, targety - sourcey);
	}	

	static Point2D.Double project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	static double limit(double min, double value, double max){
		if(max>=min)
		return Math.min(Math.max(min,value),max);
		if(max<min)
		return Math.min(Math.max(max,value),min);
		return Math.min(Math.max(min,value),max);
	}
	static int limit(int min, int value, int max){
		if(max>=min)
		return Math.min(Math.max(min,value),max);
		if(min>max)
		return Math.min(Math.max(min,value),max);
		return Math.min(Math.max(min,value),max);
	}
	static double getBSpeed(double power){
		return (20-(power*3));
	}
	double getDistance(Point2D.Double them, Point2D.Double us){
		double x = them.x - us.x;
		double y = them.y - us.y;
		return Math.sqrt((x*x) + (y*y));
	}
	double NormaliseBearing(double ang) {
		if (ang > PI)
			ang -= 2*PI;
		if (ang < -PI)
			ang += 2*PI;
		return ang;
	}
	static int sign(int number){
		return (number>=0?1:-1);
	}
	static double sign(double number){
		return (number>=0?1:-1);
	}

////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
public void onPaint(Graphics2D g) {

	//	g.drawString("Fighting: " + enemy.name, 2, new Double(this.getBattleFieldHeight()).intValue()-10);
	g.setColor(Color.green);
	g.drawOval(new Double(getX() - 25).intValue(), new Double(getY() - 25).intValue(), 50, 50);
	if(GunGroup!=null)
	for(int i = 0; i < GunGroup.size(); i ++){
		GunWave gW = (GunWave)GunGroup.get(i);
		double radius = gW.distTraveled+gW.bSpeed;
		Point2D.Double midBin = new Point2D.Double((radius*Math.sin(gW.bearing)) + gW.ourpos.getX(), (radius*Math.cos(gW.bearing)) + gW.ourpos.getY());
		Point2D.Double maxBin = new Point2D.Double((radius*Math.sin(gW.maxBearing)) + gW.ourpos.getX(), (radius*Math.cos(gW.maxBearing)) + gW.ourpos.getY());
		Point2D.Double minBin = new Point2D.Double((radius*Math.sin(gW.minBearing)) + gW.ourpos.getX(), (radius*Math.cos(gW.minBearing)) + gW.ourpos.getY());
		g.setColor(Color.RED);
		g.drawOval(new Double(gW.ourpos.getX() - (radius)).intValue(), new Double(gW.ourpos.getY() - (radius)).intValue(), new Double(radius*2).intValue(), new Double(radius*2).intValue());
		g.setColor(Color.YELLOW);
		g.drawOval(new Double(midBin.x - 5).intValue(), new Double(midBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.BLUE);
		g.drawOval(new Double(maxBin.x - 5).intValue(), new Double(maxBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.WHITE);
		g.drawOval(new Double(minBin.x - 5).intValue(), new Double(minBin.y - 5).intValue(), 10, 10);
	}

}


////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////



}

class Enemy{
	
	double ourLateralVelocity;
	double ourLastLateralVelocity;
	double heading;
	double ourHeading;
	double bearing;
	double health;
	double lastHealth;
	double absBearing;
	double absBearingToUs;
	double distance;
	double ourLateralHeading;
	double lateralDirection;
	double velocity;
	double lastLateralVelocity;
	double eLateralHeading;
	double eLateralVelocity=1;
	double eLateralDirection;
	
	int wallSeg=0;
	int distSeg=0;
	int vSeg=0;
	int lvSeg=0;
	int headSeg=4;
	int bulletNSeg=0;
	
	boolean seen = false;
	
	Point2D.Double position;
	
	Enemy(){
		health = 100; lastHealth = 100;
	}


}

class SurfWave {
	

	int wallSeg;
	int distSeg;
	int vSeg;
	int lvSeg;
	int headSeg;
	int bulletNSeg;
	int bPowerSeg;
	
	double heading;
	double velocity;
	double lateralDirection;
	double lastVelocity;
	double lateralHeading;
	double bearingToThem;
	
	double bearingToUs;
	
	double shotTime;
	double dist;
	double distTraveled;
	double bPower, bSpeed;
	double maxBearingOffset, Clockwise, timeTillHit;
	
	
	Point2D.Double enemyLocation;
	Point2D.Double ourposition;
	
	boolean present = false;
	

}

class GunWave{
	double bearing;
	double bSpeed;
	double dist;
	double distTraveled;
	Point2D.Double location;
	double time;
	double direction;
	Point2D.Double ourpos;
	double maxBearingOffset;
	double lateralVelocity;
	double lateralDirection;
	
	double maxBearing;
	double minBearing;
	
	int nearWallSegment = 0;
	int distanceSegment = 4;
	int lateralVelocitySegment;
	int lateralHeadingSegment;
	int lastVelocitySegment;
	int binGroupSegment;
}
