package ins;
import robocode.*;

/**
	(\      /) /\ ( \ \\  //(\  ()    /\    (\  () /\
	(   \    /   )( /\ )( |_\ | \   \/   / ( \ \ ( )   / /\ \   ( \ \ ( )( /\ )
	( )\ \  / /( )( |    | )(  __ |  \      /  ( )\ \( )  / /__\ \  ( )\ \( )( |    | )
	( ) \ \/ / ( )( \____/ )( | / |   (    )   ( ) \ \ ) / _____  \ ( ) \ \ )( \____/ )
	(_)  \__/  (_) \______/ (____/    (____)   (_)  \__)/_/     \__\(_)  \__) \______/
	
- a robot by Insectoid.
 * A 1v1 nano, Codesize 249
 *
 * Version History:
 *  V 0.8:
 *   -patternmatcher(big thankyou to mike and kawigi)
 *   -random movement
 *   -No colors
 *	V 0.7.1 :
 *	 -Exact same as 0.7, but with colors. Style!
 * One-Time Gold in MiniBot Challenge
 * Two-Time Silver in MiniBot Challenge
 *	V 0.7 : 
 *	 -No colors 
 *	 -Hopefully better dodging 
 *	 -Codesize 242 
 -----------------------------
 *	V 0.6.1 : 
 *	 -Shrink wrapped 
 *	 -general bugs fixed, better
 -----------------------------
 *	V 0.5 : 
 *	 -Better doding 
 *	 -Two bytes less 
 *	 -Codesize:230 
 * One-Time Silver in Minibot Challenge
 ----------------------------
 *	V 0.4 : 
 *	 -Dodging 
 *	 -More accurate aim 
 *	 -Codesize:232 
 ----------------------------
 *	V 0.35 : 
 *	 -Some general bug fixes, Codesize is down. 
 *	 -Codesize:213 
 ----------------------------
 *	V 0.3 : 
 *	 -Firing code is based on Daniel's idea of averaging lead. I may 
 *	 have some sinppets of it. 
 *	 -Codesize:218 
 ----------------------------
 *	V 0.2 : 
 *	 -First public release 
 *	 -Codesize 202 
 ----------------------------
 * Thanks to:
 * Daniel Pereira and his great guns(Mine's Based off His!)
 * Jan Schrader's Lemon, for radar
 * Mike Dorgan's UDNTB 1.1, for advance shot detector
 * DrLoco, who helped me fit in colors.
 */
public class MobyNano extends AdvancedRobot
{
	static boolean ahead;
	static final int 	SEARCH_DEPTH = 32;
	static StringBuffer patternMatcher = new StringBuffer("" + 
										 	(char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + 
										    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + 
										    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + 
										    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + 
										    (char)-8 +(char)-3 +(char)2 + (char)7 + (char)-5 +(char)5 + (char)-7 +(char)-2 +
										    (char)3 + (char)8 + (char)-4 +(char)-1+ (char)4 + (char)-6 +(char)1 + (char)6);
	/**
	 * run: MobyNano's default behavior
	 */
	public void run() {
		setAdjustGunForRobotTurn(true);
		setTurnRadarRightRadians(1D/0D);
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		double targetBearing=e.getBearingRadians();
		int 	searchlength = SEARCH_DEPTH;
		int 	matchIndex;
		if(Math.random()>.95) {
			ahead = !ahead;
		}
		setAhead(ahead ? 1000 : -100);
		setTurnRight(90+e.getBearing());
		patternMatcher.insert(0, (char)((Math.sin(e.getHeadingRadians() - (targetBearing = targetBearing + getHeadingRadians()))*e.getVelocity())));
		while ((matchIndex = patternMatcher.toString().indexOf(patternMatcher.substring(0, searchlength--), 1)) < 0);
		searchlength =  matchIndex - (int)((e.getDistance())/(11));
		do
		{
			targetBearing += Math.asin(((byte)patternMatcher.charAt(matchIndex--))/e.getDistance());
		}
		while (matchIndex >= Math.max(0, searchlength));
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(targetBearing - getGunHeadingRadians()));
		setFire(Math.min(getEnergy()-3, e.getEnergy()) / 4);
		setTurnRadarLeftRadians(getRadarTurnRemaining());
		
	}
	public void onHitWall(HitWallEvent e) {
		ahead=!ahead;
	}
}
