package jf;
import robocode.*;
import java.util.Vector;
import java.awt.Graphics2D;
import java.awt.Color;
/**
 * MyClass - a class by (your name here)
 */
public class LearningGun
{
	AdvancedRobot me;
	
	double startingEnergy = 100;

	Vector waves;
	
	double enemyEnergy = 100;
  	int dist_num = 4;

  	int BINS = 21; // 0-20
 	int CENTER_BIN = 10;
  
 	double[] shootAngle = new double [dist_num];
  	double[] shots = new double [dist_num];

public LearningGun( AdvancedRobot r) {
	me = r;
	
	waves = new Vector();
}

public void onScannedRobot(ScannedRobotEvent e){
	me.setTurnRadarRightRadians(fixAngle( 2.0 * ( e.getBearingRadians() + me.getHeadingRadians() - me.getRadarHeadingRadians())) );

	double energyDrop = startingEnergy - e.getEnergy();
	enemyEnergy = e.getEnergy();
	
	double X = me.getX() + e.getDistance() *Math.sin(me.getHeadingRadians() + e.getBearingRadians() );
	double Y = me.getY() + e.getDistance() *Math.cos(me.getHeadingRadians() + e.getBearingRadians() );

	if (energyDrop >= 0.01 && energyDrop <= 3.0){
		//BULLET!!
	}

	double firepower = 2.0;
	
	// Fire a wave
	Wave newW = new Wave( me.getX(), me.getY(), firepower, me.getTime() , fixAngle( me.getHeadingRadians() + e.getBearingRadians()), clockwise(e), distance(e.getDistance()));
	waves.add(newW);
	
	// Kill old waves
	for ( int i = 0; i < waves.size(); i++){
		Wave w = (Wave)waves.get(i);
		
		double d = Math.sqrt( (X -w.x)*(X -w.x) + (Y - w.y)*(Y - w.y) );

		if (w.distance(me.getTime()) > d ){
			// Wave hit!!
			waves.remove( w );
			i--;
			
			//Learn from wave
			shots[w.distance] = shots[w.distance] + 1;
			double angle = w.cW * fixAngle(fixAngle(me.getHeadingRadians() + e.getBearingRadians()) - w.bearing);
			shootAngle[w.distance] = ( angle + shots[w.distance]*shootAngle[w.distance]) /(shots[w.distance] +1); 
}
}
double b = fixAngle(me.getHeadingRadians() + e.getBearingRadians());
double headOn = fixAngle(b- me.getGunHeadingRadians());
int dist = distance(e.getDistance());
me.setTurnGunRightRadians( fixAngle(headOn + clockwise(e)*shootAngle[dist]));

me.setFire(firepower);
}
public void onPaint(Graphics2D g){
	g.setColor(Color.BLUE);
	
	System.out.println( shootAngle);
	
	for (Object o : waves){
		Wave w = (Wave)o;
		
		int radius = (int)w.distance( me.getTime());
		g.drawOval((int)w.x - radius , (int)w.y - radius, 2*radius, 2*radius);
		
		double x2 = w.x + w.distance( me.getTime() )*Math.sin(w.bearing);
		double y2 = w.y + w.distance( me.getTime() )*Math.cos(w.bearing);
		
		g.drawLine( (int)w.x , (int)w.y, (int)x2,(int)y2);
	}
}
public int distance(double d){
	
	if(d <= 100){
	return 0;	
	}
	else if(d <= 200){
	return 1;	
	}

	else if(d <= 450){
	return 2;	
	}
	return 3;
}
public double clockwise(ScannedRobotEvent e){
	double angle  = e.getVelocity()*fixAngle(e.getHeadingRadians() - ( me.getHeadingRadians() + e.getBearingRadians()));
	
	if (angle >= 0){
		return 1.0;	
	}
	else {
		return -1.0;
	}
}
public double fixAngle (double d){
	
	if (Math.abs(d) > Math.PI * 2.0){
		d = d % (Math.PI * 2.0);
	}
	if (d > Math.PI ){
		d -= 2.0*Math.PI;
	}

	if (d < -Math.PI ){
		d += 2.0*Math.PI;
	}
	return d;
	}	
}
