/*
 * Created on Feb 15, 2004
 */
package davidalves;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

import davidalves.net.AdvancedTeamRobot;
import davidalves.net.gun.GuessFactorGun;
import davidalves.net.gun.GuessFactorGunManager;
import davidalves.net.gun.segmentation.*;
import davidalves.net.movement.RamEvasionWallSmoother;
import davidalves.net.movement.WallSmoother;
import davidalves.net.movement.WaveSurfing;
import davidalves.net.strategy.Strategy;
import davidalves.net.util.*;
import robocode.*;

public final class PhoenixOS extends AdvancedTeamRobot {
	
	public static boolean movingAllowed = true;
	public static boolean firingAllowed = true;
	public static boolean targetingChallengeMode = false;
	public static boolean useHeadOnTargeting = false;
	
	static RobotState myState = null;
	static RobotState targetState = null;
	
	static GuessFactorGunManager myGuns;
	
	static ArrayList myWaves = new ArrayList(120);
	
	static WallSmoother ramEvasion = new RamEvasionWallSmoother();
	static WaveSurfing adaptiveMovement = new WaveSurfing();
	
	static long timesRammed;
	static double damageInflicted;
	static long skippedTurns;
	static int wins;
	
	static double enemyFirePower;
	
	static boolean aiming = false;
	
	public void run() {
		
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		setColors(Color.darkGray, Color.darkGray, Color.cyan);
		
		
		enemyFirePower = 0.0;
		aiming = false;
		targetState = null;
		myState = null;
		
		if(getRoundNum()==0){
			super.init();
			
			adaptiveMovement.init();
			
			GuessFactorGun[] guns = new GuessFactorGun[2];
			guns[0] = new GuessFactorGun(
					new Segmentation[]{
							new AccelerationSegmentation(3),
							new AttackAngleSegmentation(5),
							new BulletSpeedSegmentation(4),
							new OrbitalWallsSegmentation(.9, .6, 3),
							new SpeedSegmentation(3),
							new TimeAtVelocityFactorSegmentation(2),
						}, 15, .99, true);
			guns[1] = new GuessFactorGun(
					new Segmentation[]{
							new AccelerationSegmentation(3),
							new AttackAngleSegmentation(5),
							new BulletSpeedSegmentation(4),
							new NonlinearDistanceSegmentation(),
							new OrbitalWallsSegmentation(.9, -.4, 3),
							new OrbitalWallsSegmentation(.9, .6, 4),
							new SpeedSegmentation(4),
							new TimeAtVelocityFactorSegmentation(4),
						}, 15, .99, true);
			myGuns = new GuessFactorGunManager(guns, 100);
		}
		
		if(getOthers() > 1) {
			throw new RuntimeException("1-v-1 only for now");
		}
		
		adaptiveMovement.reset();
		
		myGuns.reset();
		myWaves.clear();
		
		do{
			updateMyState();
			Strategy.update(myState, targetState);
			radar();
			myWaves();
			myGuns.updateBulletTracker(getOthers() > 0);
			if(movingAllowed) movement();
			if(targetState!= null){
				if(firingAllowed) aim();
			}
			execute();
		} while(true);
	}

	private void updateMyState() {
		RobotState myPreviousState = myState;
		myState = new RobotState();
		myState.heading = getHeadingRadians();
		myState.velocity = getVelocity();
		myState.energy = getEnergy();
		myState.time = getTime();
		myState.name = getName();
		myState.x = getX();
		myState.y = getY();
		myState.calculateDeltas(myPreviousState);
	}
	
	private void myWaves(){
		Wave w = null;
		Iterator i = myWaves.iterator();
		while(i.hasNext()){
			w = (Wave) i.next();
			
			if(w.isSolvable(targetState, getTime())){
			
				myGuns.doWave(w, targetState, 1.0);
				i.remove();
			
			} else if(w.timeToImpact(targetState, getTime()) < -3){
			
				i.remove();
			}
		}
	}

	private void radar() {
		
		boolean radarLocked = (getOthers() == 1) && targetState != null;
		
		if(!radarLocked || (getTime() - targetState.time) > 2){
			setTurnRadarRight(Double.POSITIVE_INFINITY);
		//Lock radar
		} else {
			Point targetsNextPosition = targetState.project(targetState.heading, targetState.velocity);
			//Point myNextPosition = myState.project(myState.heading, myState.velocity);
			double radarOffset = Utils.angularDifferenceBetween(getRadarHeadingRadians(), myState.absoluteAngleTo(targetsNextPosition));
			
			if (radarOffset < 0){
				radarOffset -= 25.0 / myState.distanceTo(targetState);
			} else {
				radarOffset += 25.0 / myState.distanceTo(targetState);
			}
			setTurnRadarRightRadians(radarOffset);
		}
	}

	private void aim() {
		double bulletPower = 3;
		double maxBulletPower = 3;
		boolean energyManaged = false;
		
		if(!targetingChallengeMode){
			if(myState.distanceTo(targetState) > 150) bulletPower = Math.min(bulletPower, 2.4);
			if(myState.distanceTo(targetState) > 300) bulletPower = Math.min(bulletPower, 2.0);
			
			maxBulletPower = Math.min(getEnergy() * 35.0 / myState.distanceTo(targetState), Utils.powerNeededToKill(targetState.energy));
			maxBulletPower = Utils.bindToRange(.1, maxBulletPower, 3.0);
			if(maxBulletPower < bulletPower){
				bulletPower = maxBulletPower;
				//energyManaged = true;
			}
			
		}
		
		double timeToFire = Math.ceil(getGunHeat() / getGunCoolingRate());
		if(!aiming){
			if(timeToFire > 2.0 || getEnergy() == 0.0){
				setTurnGunRightRadians(Utils.angularDifferenceBetween(getGunHeadingRadians(), myState.absoluteAngleTo(targetState)));
			} else {
				aiming = true;
				setTurnGunRightRadians(Utils.angularDifferenceBetween(getGunHeadingRadians(),myGuns.getBestGun(myState, targetState, bulletPower).getFiringAngle(myState, targetState, bulletPower)));
			}
		}
		
		
		if(targetingChallengeMode || (getEnergy() > 7.0 || getEnergy() - bulletPower > targetState.energy)){
			if(getGunHeat()==0.0 && getGunTurnRemaining() == 0.0){
				Bullet b = setFireBullet(bulletPower);
				if(b != null)myGuns.shotFired(myGuns.getBestGun(), b);
				aiming = false;
			}
		}
		if(getEnergy() != 0.0 && targetState.energy != 0.0 && myState.distanceTo(targetState) > 75 && !energyManaged)
			myWaves.add(new Wave(myState, targetState, getTime(), bulletPower));
	}

	private void movement() {
		Point destination = null;
		if(targetState != null &&
				(timesRammed > getRoundNum() * 2 && myState.distanceTo(targetState) < 180 )){
			Point cw = ramEvasion.getSmoothedDestination(myState, targetState, 1.0);
			Point ccw = ramEvasion.getSmoothedDestination(myState, targetState, -1.0);
			if(cw.distanceTo(targetState) < ccw.distanceTo(targetState)){
				destination = ccw;
			} else {
				destination = cw;
			}
		} else {
			adaptiveMovement.manageWaves(targetState, myState, getTime());
			adaptiveMovement.chooseDestination(myState, targetState, getTime());
			
			destination = adaptiveMovement.getDestination();
		}
		if(destination != null)
			driveTo(destination);
	}



	public void onScannedRobot(ScannedRobotEvent e) {
		//TODO: Make this method cope with multiple enemies
		double absBearing, distance, x, y;
		
		if(targetState == null) targetState = new RobotState();
		
		RobotState previousEnemyState = targetState;
		RobotState enemyState = new RobotState();
		
		distance = e.getDistance();
		absBearing = Utils.normalAbsoluteAngle(e.getBearingRadians() + getHeadingRadians());
		x = getX() + distance * Math.sin(absBearing);
		y = getY() + distance * Math.cos(absBearing);
		
		if(e.getVelocity() != 0){
			firingAllowed = true;
		}
		
		enemyState.heading = e.getHeadingRadians();
		enemyState.velocity = e.getVelocity();
		enemyState.x = x;
		enemyState.y = y;
		enemyState.energy = e.getEnergy();
		enemyState.time = getTime();
		enemyState.name = e.getName();
		
		enemyState.calculateDeltas(previousEnemyState);
		
		double wallDamage = 0;
		if (previousEnemyState.energy - enemyState.energy > 0 && Math.abs(enemyState.velocity) == 0 && Math.abs(previousEnemyState.velocity) > 2.0) {
			wallDamage = Math.abs(previousEnemyState.velocity) / 2.0 - 1.0;
		}
		if(wallDamage < 0) wallDamage = 0;
		
		double bulletPower = (previousEnemyState.energy - wallDamage)- enemyState.energy;
		
		if(bulletPower <= 3.0 && bulletPower >= .1){
			//TODO: figure out if this should be enemyState or previousEnemyState
			Wave wave = new Wave(previousEnemyState, myState, getTime() - 1, bulletPower);
			adaptiveMovement.addRealWave(wave);
			enemyFirePower = bulletPower;
		}
		
		targetState = enemyState;
	}
	
	public void onBulletHit(BulletHitEvent e){
		//TODO: Make this method cope with multiple enemies
		if(targetState != null){
			if(e.getName() == targetState.name){
				targetState.energy = e.getEnergy();
			}
		}
		myGuns.hit(e.getBullet());
		damageInflicted += Utils.bulletDamage(e.getBullet().getPower());
	}
	
	public void onHitByBullet(HitByBulletEvent e){
		//TODO: Make this method cope with multiple enemies
		Bullet b = e.getBullet();
		targetingChallengeMode = false;
		movingAllowed = true;
		adaptiveMovement.bulletHit(b, myState, e.getTime(), true);
	}
	
	public void onHitRobot(HitRobotEvent e){
		timesRammed++;
		if(targetState != null){
			if(e.getName() == targetState.name){
				targetState.energy = e.getEnergy();
			}
		}
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e){
		Bullet b = e.getHitBullet();
		adaptiveMovement.bulletHit(b, myState, e.getTime(), false);
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		myWaves.clear();
		targetState = null;
	}
	
	public void onHitWall(HitWallEvent e){
		warning("Hit wall.  Position: " + myState + " destination: " + adaptiveMovement.getDestination());
	}
	
	public void onSkippedTurn(SkippedTurnEvent e){
		warning("Skipped turn " + e.getTime());
		skippedTurns++;
	}
	
	public void onDeath(DeathEvent e){
		endRound();
	}
	
	public void onWin(WinEvent e){
		endRound();
		wins++;
	}
	
	public void endRound(){
		int roundsElapsed = 1 + getRoundNum();
		PhoenixOS.info("--- Round ended ---");
		PhoenixOS.info("Damage taken from known waves:   " + Utils.format(adaptiveMovement.damageInflictedByKnownWaves) + "  average per round: " + Utils.format((adaptiveMovement.damageInflictedByKnownWaves) / roundsElapsed));
		PhoenixOS.info("Damage taken from unknown waves: " + Utils.format(adaptiveMovement.damageInflictedByUnknownWaves) + "  average per round: " + Utils.format((adaptiveMovement.damageInflictedByUnknownWaves) / roundsElapsed));
		PhoenixOS.info("Damage inflicted: " + Utils.format(damageInflicted) + "  average per round: " + Utils.format(damageInflicted / roundsElapsed));
		PhoenixOS.info("Turns skipped: " + skippedTurns + "  average per round: " + Utils.format(((double)skippedTurns) / roundsElapsed));
		PhoenixOS.info("Wins: " + wins + " / " + roundsElapsed + " (" + Utils.format(100.0 * wins / roundsElapsed) + "%)");
		myGuns.printStats();
	}
}
