/*
 * Created on Feb 29, 2004
 *
 */
package davidalves.net.gun;

import davidalves.PhoenixOS;
import davidalves.net.Constants;
import davidalves.net.gun.segmentation.Segmentation;
import davidalves.net.util.*;

public class GuessFactorGun {
	public static final int MAX_SEGMENTS = 10;
	private int GF0;
	
	private double rollStatsFactor;
	
	
	private int shots;
	private int hits;
	
	Segmentation[] segmentation;
	final float[] noData;
	int[][] segmentVisits = new int[MAX_SEGMENTS][20];
	float[][][][][][][][][][][] data; //MAX_SEGMENTS + 1 dimensions, last one is GF
	int  [][][][][][][][][][] visitCounts;
	
	public GuessFactorGun(Segmentation[] segmentation, int GF0, double rollStatsFactor, boolean noDataAssumesHOT){
		this.rollStatsFactor = rollStatsFactor;
		this.GF0 = GF0;
		if(segmentation.length < MAX_SEGMENTS){
			
		}
		if(segmentation.length <= MAX_SEGMENTS){
			
			Segmentation[] fullSegmentation = new Segmentation[MAX_SEGMENTS];
			
			for(int i = 0; i < MAX_SEGMENTS; i++){
				fullSegmentation[i] = i < segmentation.length?segmentation[i]:Segmentation.nullSegmentation; 
			}

			segmentation = fullSegmentation;
			
			this.segmentation = segmentation;
			
			
			this.data = new float  [segmentation[0].numSegments()]
									[segmentation[1].numSegments()]
									[segmentation[2].numSegments()]
									[segmentation[3].numSegments()]
									[segmentation[4].numSegments()]
									[segmentation[5].numSegments()]
									[segmentation[6].numSegments()]
									[segmentation[7].numSegments()]
									[segmentation[8].numSegments()]
									[segmentation[9].numSegments()]
									[GF0 * 2 + 1];
			this.visitCounts = new int  [segmentation[0].numSegments()]
										[segmentation[1].numSegments()]
										[segmentation[2].numSegments()]
										[segmentation[3].numSegments()]
										[segmentation[4].numSegments()]
										[segmentation[5].numSegments()]
										[segmentation[6].numSegments()]
										[segmentation[7].numSegments()]
										[segmentation[8].numSegments()]
										[segmentation[9].numSegments()];
			
			noData = new float[GF0 * 2 + 1];
			
			if(noDataAssumesHOT){
				noData[GF0] = 1;
			}
			
		} else {
			throw new RuntimeException("Invalid number");
		}
	}
	
	public void setGF0(int GF0){
		this.GF0 = GF0;
	}
	
	public int getGF0(){
		return GF0;
	}
	
	public void reset(){}
	
	public int[] getSegments(RobotState shooter, RobotState target, double bulletPower){
		int[] segments = new int[MAX_SEGMENTS];
		for(int i = 0; i < MAX_SEGMENTS; i++){
			segments[i] = segmentation[i].getSegment(shooter, target, bulletPower);
		}
		return segments;
	}
	
	public float[] getData(int[] segments){
		try{
			//TODO: Some function is modifying this array... so I need to return copies until I figure out where
			float[] temp = new float[noData.length];
			if(getVisits(segments) == 0){
				System.arraycopy(noData,0,temp,0,noData.length);	
			} else {
				System.arraycopy(data[segments[0]][segments[1]][segments[2]][segments[3]][segments[4]][segments[5]][segments[6]][segments[7]][segments[8]][segments[9]],0,temp,0,noData.length);
			}
			//return data[segments[0]][segments[1]][segments[2]][segments[3]][segments[4]][segments[5]][segments[6]];
			return temp;
		} catch(ArrayIndexOutOfBoundsException e){
			for(int i = 0; i < MAX_SEGMENTS; i++){
				if(segments[i] >= segmentation[i].numSegments()){
					PhoenixOS.error(" Overflow on " + i + "(" + segments[i] + ")");
				} else if (segments[i] < 0){
					PhoenixOS.error(" Underflow on " + i + "(" + segments[i] + ")");
				}
			}
			throw e;
		}
	}
	
	public int getVisits(int[] segments){
		try{
			return visitCounts[segments[0]][segments[1]][segments[2]][segments[3]][segments[4]][segments[5]][segments[6]][segments[7]][segments[8]][segments[9]];
		} catch(ArrayIndexOutOfBoundsException e){
			for(int i = 0; i < MAX_SEGMENTS; i++){
				if(segments[i] >= segmentation[i].numSegments()){
					PhoenixOS.error(" Overflow on " + i + "(" + segments[i] + ")");
				} else if (segments[i] < 0){
					PhoenixOS.error(" Underflow on " + i + "(" + segments[i] + ")");
				}
			}
			throw e;
		}
	}
	
	public double getGuessFactor(RobotState shooter, RobotState target, double bulletPower){
		
		//TODO: Don't return guessFactors that will fire off the field - test
		
		int[] segments = getSegments(shooter, target, bulletPower);
		
		double bestScore = 0.0;
		int best = GF0 + GF0 / 4;
		float[] data = getData(segments);
		for(int i = 0; i < GF0 * 2 + 1; i++){
			int test = (i + GF0) % data.length;
			double score = data[test];
			if(score > bestScore){
				//PhoeniX.info("Projecting GF " + i);
				Point projected = shooter.project(shooter.absoluteAngleTo(target) + getAngleForGF(test, bulletPower) * target.directionOrbitingAround(shooter),shooter.distanceTo(target) * Utils.bulletSpeed(bulletPower) / (Utils.bulletSpeed(bulletPower) + Constants.SPEED_MAX));
				if(projected.isOnDrivableField()){
					bestScore = score;
					best = test;
				}
				
			}
		}
		return getAngleForGF(best, bulletPower) * target.directionOrbitingAround(shooter);
	}
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower){
		Point shootersNextPosition = shooter.project(shooter.heading, shooter.velocity);
		Point targetsNextPosition = target.project(target.heading, target.velocity);
		return Utils.normalAbsoluteAngle(shootersNextPosition.absoluteAngleTo(targetsNextPosition) + getGuessFactor(shooter, target, bulletPower));
	}
	
	public void doWave(Wave wave, Point impactLocation, double weight){
		
		int solutionGF = wave.getSolutionGF(impactLocation, GF0);
		
		int[] segments = getSegments(wave.shooterAtFireTime, wave.targetAtFireTime, wave.power); 
		try{
			
			if(rollStatsFactor < 1.0) {
				for(int i = 0; i < 2 * GF0 + 1; i++){
					data[segments[0]][segments[1]][segments[2]][segments[3]][segments[4]][segments[5]][segments[6]][segments[7]][segments[8]][segments[9]][i] *= rollStatsFactor; 
				}
			}
			solutionGF = Math.max(Math.min(solutionGF, 2 * GF0), 0);
			visitCounts[segments[0]][segments[1]][segments[2]][segments[3]][segments[4]][segments[5]][segments[6]][segments[7]][segments[8]][segments[9]]++;
			
			data[segments[0]][segments[1]][segments[2]][segments[3]][segments[4]][segments[5]][segments[6]][segments[7]][segments[8]][segments[9]][solutionGF] += weight;
			
			for(int i = 0; i < MAX_SEGMENTS; i++){
				segmentVisits[i][segments[i]]++;
			}
			
		} catch(ArrayIndexOutOfBoundsException e){
			for(int i = 0; i < MAX_SEGMENTS; i++){
				if(segments[i] >= segmentation[i].numSegments()){
					PhoenixOS.error(" Overflow on " + i + "(" + segments[i] + ")");
				} else if (segments[i] < 0){
					PhoenixOS.error(" Underflow on " + i + "(" + segments[i] + ")");
				}
			}
			throw e;
		}
	}
	
	public double getAngleForGF(int GF, double bulletPower){
		return Utils.maxEscapeAngle(bulletPower) * (GF - GF0) / GF0;
	}
	
	public void miss(){
		shots++;
	}
	public void hit(){
		hits++;
		shots++;
	}
	
	public int getShotsFired(){
		return shots;
	}
	public int getHits(){
		return hits;
	}
	
	public double getAccuracy(){
		return 100.0 *  hits / shots;
	}
	
	public int numSegments(){
		int total = 1;
		for(int i = 0; i < MAX_SEGMENTS; i++){
			total *= segmentation[i].numSegments();
		}
		return total;
	}
	
	public void printSegmentationInfo(){
		PhoenixOS.info("Segmentation data");
		for(int i = 0; i < MAX_SEGMENTS; i++){
			String s = i + ":";
			for(int ii = 0; ii < segmentation[i].numSegments(); ii++){
				s += " ";
				s += segmentVisits[i][ii];
			}
			PhoenixOS.info(s);
		}
	}	
}
