/*
 * Created on Sep 9, 2004
 *
 */
package davidalves.net.gun.segmentation;

import davidalves.net.Constants;
import davidalves.net.util.RobotState;

/*
 * Splits distance traveled into equally sized segments
 * 
 * @author David Alves
 *
 */
public class BulletSpeedSegmentation extends LinearSegmentation {
	
	public BulletSpeedSegmentation(int segments){
		super(Constants.BULLET_SPEED_MIN, Constants.BULLET_SPEED_MAX, false, false, segments);
	}

	protected double getValue(RobotState shooter, RobotState target, double bulletPower) {
		return 20.0 - 3.0 * bulletPower;
	}
	
}
