/*
 * Created on Oct 20, 2004
 *
 */
package davidalves.net.movement;

import davidalves.PhoenixOS;
import davidalves.net.Constants;
import davidalves.net.strategy.Strategy;
import davidalves.net.util.*;

/**
 * @author David Alves
 *
 */
public class LimitedWallSmoother extends WallSmoother{
	
	NoFearTheWallsWallSmoother cornerEscape = new NoFearTheWallsWallSmoother();
	
	public Point getSmoothedDestination(Point position, Point orbitCenter, double direction) {
		final double STICK_LENGTH = 200;
		final double ONE_DEGREE = Constants.ONE_DEGREE_IN_RADIANS;
		final double SMOOTHING_PER_ADJUST = 9.95 * ONE_DEGREE;
		double maxSmoothAngle;
		
		double desiredDistance = Strategy.getDesiredDistance();
		
		double desiredAngle = Utils.normalAbsoluteAngle(position.absoluteAngleTo(orbitCenter) - direction * Math.PI / 2.0);
		
		if(position.distanceTo(orbitCenter) < desiredDistance){
			//Drive away from enemy at a sharp angle if we are close to them, shallow if far
			if(PhoenixOS.bot.getGunHeat() > 1.6){ 
				//In the beginning of the round (before anyone can fire)
				//drive almost directly away from the enemy
				desiredAngle -= direction * Utils.scaledValue(20 * ONE_DEGREE, 60 * ONE_DEGREE, position.distanceTo(orbitCenter)/desiredDistance);
				maxSmoothAngle = 20 * ONE_DEGREE;
			} else {
				//Once bots can fire, stay closer to perpendicular
				desiredAngle -= direction * Utils.scaledValue(15 * ONE_DEGREE, 20 * ONE_DEGREE, position.distanceTo(orbitCenter)/desiredDistance);
				maxSmoothAngle = 80 * ONE_DEGREE;
			}
		} else {
			//Drive towards enemy
			desiredAngle += direction * Utils.scaledValue(5 * ONE_DEGREE, 10 * ONE_DEGREE, position.distanceTo(orbitCenter)/desiredDistance);
			maxSmoothAngle = 50 * ONE_DEGREE;
		}
		double angle = desiredAngle;
		long maxAdjustments = Math.round(maxSmoothAngle / SMOOTHING_PER_ADJUST);
		long adjustments = 0;
		Point projected;
		while((!(projected = position.project(angle, STICK_LENGTH)).isOnDrivableField()) && adjustments <= maxAdjustments)
		{
			adjustments++;
			angle += direction * SMOOTHING_PER_ADJUST;
		}
		if(adjustments <= maxAdjustments) {
			return projected;
		}
		return position;
	}
}
