package jam.utils;
import java.util.*;
import java.io.*;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.zip.*;

public class jUtil {

	//Kawigi's save/load methods
	public static Object restoreObject(File f){
		Object o = "FNF";
		try
		{
			ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(f)));
			o = in.readObject();
			in.close();
		} catch (Exception ex){}
		return o;
	}
	
	public static void saveObject(Object o, File f)
	{
		try{
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(f)));
			out.writeObject(o);
			out.close();
		}
		catch (Exception ex){}
	}

	//Paul Evan's Rolling Average function
	public static double rollingAverage(double n, double oldVal, double entry){
		return (n*oldVal + entry)/(n + 1D);
	}

	
	public static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance){
		
		return new Point2D.Double(loc.x + distance*Math.sin(heading), loc.y + distance*Math.cos(heading));			
	}
	
	public static double angleBetween(Point2D.Double origin, Point2D.Double p1, Point2D.Double p2){
		return Utils.normalRelativeAngle(absoluteBearing(origin, p1) - absoluteBearing(origin, p2));
		
	}

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

	public static double bulletVelocity(double power){
		return 20D - 3D*power;	
	}
	
	public static double maxEscapeAngle(double velocity){
		return Math.asin(8D/velocity);	
	}
	
	public static double bindToRange(double value, double min, double max){
		
		if (value > max)
			value = max;
		if (value < min)
			value = min;
		return value;
	}

}